<section class="content">
    <div class="row">
        <div class="col-sm-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
                <div class="row">
                    <div class="col-sm-10">
                        <div class="box-header">
                        </div>
                    </div>
                </div>
                <div class="box-body">
                <div id="alert-error" class="alert alert-danger text-center" style="display:none;"></div>
                <div id="alert-success" class="alert alert-success alert-dismissable message-success text-center text-success" style="display:none;"></div>
                    <div id="form" class="box" style="border-top: 0px solid;">
                        <div class="box-body">
                            <form class="form-horizontal" action="procesar_formulario.php" method="post">

                                <div class="form-group">
                                    <label class="control-label col-sm-2" for="mes"><?= lang('report_type'); ?>:</label>
                                    <div class="col-sm-4">
                                        <select class="form-control" name="report_type" id="report_type">
                                            <option value="RVIE">Registro de Ventas e Ingresos Electrónicos – RVIE</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-sm-2" for="anio"><?= lang('year'); ?>:</label>
                                    <div class="col-sm-4">
                                        <select class="form-control" name="anio" id="anio">
                                            <?php
                                            $currentYear = date("Y");
                                            $firstYear = $currentYear - 10;
                                            for ($i = $firstYear; $i <= $currentYear; $i++) {
                                                echo "<option value='$i' " . (($i == $currentYear) ? 'selected' : '') . ">$i</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-sm-2" for="mes"><?= lang('month'); ?>:</label>
                                    <div class="col-sm-4">
                                        <select class="form-control" name="mes" id="mes">
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class=" col col-sm-12 text-right mt-5">
                                        <button type="button" id='btn-generar-propuesta' class="btn btn-primary">Generar</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    $(document).ready(function() {
        $('#btn-generar-propuesta').click(function(e) {
            var csrfName = '<?php echo $this->security->get_csrf_token_name(); ?>';
            var csrfHash = '<?php echo $this->security->get_csrf_hash(); ?>';
            var data = {
                '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>',
            };
            data.anio = $("#anio").val();
            data.mes = $("#mes").val();
            data.report_type = $("#report_type").val();

            $.ajax({
                url: base_url + "reports/exportarSireVentas",
                destroy: true,
                type: 'POST',
                dataType: 'json',
                data: data,
                async: false,
            }).done(function(data) {
                if(data.result == 'ok'){
                    $('#alert-success').html('<strong>éxito!</strong> ' + data.mensaje);
                    $('#alert-success').show('fade');
                    $('#cargando').hide('fade');
                    setTimeout(function () {
                        $('#alert-success').hide('fade');
                    }, 8000);
                    var $a = $("<a>");
                    $a.attr("href", data.file);
                    $("body").append($a);
                    $a.attr("download", data.filename);
                    $a[0].click();
                    $a.remove();
                }else{
                    $('#alert-error').html('<strong>¡Alerta!</strong> ' + data.mensaje);
                    $('#alert-error').show('fade');
                    $('#cargando').hide('fade');
                    setTimeout(function () {
                        $('#alert-error').hide('fade');
                    }, 8000);
                }
            });

        });
        $('#anio').change(function () {
            var meses = [
                'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'
            ];
    
            var currentYear = new Date().getFullYear();
            var mesActual = new Date().getMonth() + 1; // Se suma 1 ya que los meses en JavaScript son 0-indexados
            var $selectMes = $('#mes');
            var selectedYear = $(this).val();
            $selectMes.empty();

            for (var numeroMes = 1; numeroMes <= 12; numeroMes++) {
                if (selectedYear == currentYear && numeroMes <= mesActual) {
                    var selected = (numeroMes == mesActual) ? 'selected' : '';
                    $selectMes.append('<option value="' + numeroMes + '" ' + selected + '>' + meses[numeroMes - 1] + '</option>');
                } else if (selectedYear < currentYear) {
                    var selected = (numeroMes == mesActual) ? 'selected' : '';
                    $selectMes.append('<option value="' + numeroMes + '" ' + selected + '>' + meses[numeroMes - 1] + '</option>');
                }
            }
        });

        // Inicializar la lista de meses
        $('#anio').trigger('change');
    });
</script>