<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>
<script>
    $(document).ready(function () {
        $('#listados').DataTable({
            "responsive": true,
            "order": [[ 1, "desc" ]],
            "language": {
                "url": "<?= $assets ?>/dist/js/pages/es_es.lang"
            },
            "displayLength": 25,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "<?= site_url('payment_methods/get_payment_methods') ?>",
                "dataSrc" : "listados",
            },
            "columns": [
                //{ "data": "id" },
                { "data": "code" },
                { "data": "description" },
                { "data": "edit" },
                { "data": "delete" }
            ],
            columnDefs: [
                { orderable: false, targets: -1 },
                { orderable: false, targets: -2 },
                { orderable: false, targets: -3 }
            ]                        
        });
    });
</script>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <a href="<?= site_url('payment_methods/add'); ?>" class="btn btn-primary"> <?= lang('btn_add_payment_methods'); ?></a>
            </div>
        </div>

        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
                <div class="box-body">
                    <div class="table-responsive">
                        <!--<table id="listados" class="display" style="width:100%">-->
                        <table id="listados" class="table table-bordered table-hover table-striped table-condensed" style="width:100%">
                            <thead>
                                <tr>
                                    <!--<th width="20">#</th>-->
                                    <th width="70">C&oacute;digo</th>
                                    <th>Nombre</th>
                                    <th width="10"></th>
                                    <th width="10"></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript" src="<?= $assets ?>plugins/datatables/datatable.min.js"></script>
