<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Jobs\SendRejectedInvoicesSummaryJob;

class SendRejectedInvoicesSummary extends Command
{
    protected $signature = 'mail:rejected-invoices-summary';
    protected $description = 'Envía un resumen de comprobantes rechazados';

    public function handle()
    {
        // Ejemplo de uso de DB (si lo necesitas aquí)
        $count = DB::connection('mysql')
            ->table('email_recipients')
            ->count();

        dispatch(new SendRejectedInvoicesSummaryJob());

        $this->info("Job despachado. Correos activos: {$count}");
    }
}
