<?php (defined('BASEPATH')) or exit('No direct script access allowed'); ?>
<link href="<?= $assets ?>plugins/bootstrap-toggle/bootstrap-toggle.min.css" rel="stylesheet">
<link href="<?= $assets ?>dist/css/pages/settings.css" rel="stylesheet">
<script src="<?= $assets ?>plugins/bootstrap-toggle/bootstrap-toggle.min.js"></script>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <?= form_open_multipart("settings", 'class="validation"'); ?>
            <div>
                <ul class="tabs">
                    <li class="active"><a href="#tab1">General</a></li>
                    <li><a href="#tab2">Mod ventas</a></li>
                    <li><a href="#tab3">Mod almacén</a></li>
                    <li><a href="#tab4">Mod FE</a></li>
                </ul>
            </div>
            <div id="tab1">
                <div class="box" style="border-top: 2.5px solid #004785;">
                    <div class="box-body">
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang("site_name", 'site_name'); ?>
                                        <?= form_input('site_name', set_value('site_name', isset($form_data['site_name']) ? $form_data['site_name'] : $settings['site_name']), 'class="form-control" id="site_name" required="required" maxlength="80"'); ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang("phone_contact", 'phone_contact'); ?>
                                        <?= form_input('tel', set_value('tel', isset($form_data['tel']) ? $form_data['tel'] : $settings['tel']), 'class="form-control" id="tel" required="required" maxlength="15"'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('language', 'language'); ?>
                                        <?php $available_langs = array(
                                            'english' => 'English', 'spanish' => 'Español'
                                        ); ?>
                                        <?= form_dropdown('language', $available_langs, set_value('language', isset($form_data['language']) ? $form_data['language'] : $settings['language']), 'class="form-control tip select2" id="language"  required="required" style="width:100%;"'); ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <!-- <?= lang("currency_code", 'currency_code'); ?> -->
                                        <?= lang('currency_name', 'currency_name'); ?>
                                        <?php $cy = array('PEN' => lang('currency_pen'), 'USD' => lang('currency_usd')); ?>
                                        <!-- <?= form_input('currency_prefix', set_value('currency_prefix', isset($form_data['currency_prefix']) ? $form_data['currency_prefix'] : $settings['currency_prefix']), 'class="form-control" id="currency_code" required="required"'); ?> -->
                                        <?= form_dropdown('currency_prefix', $cy, set_value('currency_prefix', $settings['currency_prefix']), 'class="form-control select2" id="currency_code"  required="required"'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang("default_order_tax", 'default_tax_rate'); ?>
                                        <?= form_input('tax_rate', set_value('tax_rate', isset($form_data['tax_rate']) ? $form_data['tax_rate'] : $settings['default_tax_rate']), 'class="form-control" id="default_tax_rate" required="required" maxlength="5" oninput="this.value = this.value.replace(/[^0-9.]/g, \'\');"'); ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('row_per_page', 'rows_per_page') ?>
                                        <?php
                                        $rw = array('10' => '10', '25' => '25', '50' => '50', '100' => '100');
                                        echo form_dropdown('rows_per_page', $rw, set_value('rows_per_page', isset($form_data['rows_per_page']) ? $form_data['rows_per_page'] : $settings['rows_per_page']), 'class="form-control select2" id="rows_per_page" style="width:100%;" required="required"') ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('default_email', 'default_email'); ?>
                                        <?= form_input('default_email', set_value('default_email', isset($form_data['default_email']) ? $form_data['default_email'] : $settings['default_email']), 'class="form-control tip" id="default_email" required maxlength="80"'); ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang("mail_incidents", 'mail_incidents'); ?>
                                        <?= form_input('mail_incidents', set_value('mail_incidents', isset($form_data['mail_incidents']) ? $form_data['mail_incidents'] : $settings['mail_incidents']), 'class="form-control" id="mail_incidents" required="required" maxlength="80"'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <?= lang('dateformat', 'dateformat'); ?> <a href="http://php.net/manual/en/function.date.php" target="_blank"><i class="fa fa-external-link"></i></a>
                                            <?= form_input('dateformat', set_value('dateformat', isset($form_data['dateformat']) ? $form_data['dateformat'] : $settings['dateformat']), 'class="form-control tip" id="dateformat"  required="required" maxlength="10"'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('timeformat', 'timeformat'); ?>
                                        <?= form_input('timeformat', set_value('timeformat', isset($form_data['timeformat']) ? $form_data['timeformat'] : $settings['timeformat']), 'class="form-control tip" id="timeformat"  required="required" maxlength="10"'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('rounding', 'rounding'); ?>
                                        <?php
                                        $rnd = array('0' => lang('disable'), '1' => lang('to_nearest_005'), '5' => lang('next_to_10'), '2' => lang('to_nearest_050'), '3' => lang('to_nearest_number')); //, '4' => lang('to_next_number')
                                        echo form_dropdown('rounding', $rnd, set_value('rounding', isset($form_data['rounding']) ? $form_data['rounding'] : $settings['rounding']), 'class="form-control select2" id="rounding" style="width:100%;" required="required"');
                                        ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="box" style="border-top: 0px solid;">
                <div class=" box-header h4">
                <?= lang("server_email", 'server_email'); ?>
                </div>
                    <div class="box-body">
                        <div class="row" id="sendmail_config" style="display: none;">
                            <div class="col-md-12">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?= lang("mailpath", 'mailpath'); ?>
                                        <div class="controls"> <?php echo form_input('mailpath', $Settings->mailpath, 'class="form-control tip" id="mailpath"'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="row" id="smtp_config">
                            <div class="col-md-12">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?= lang("email_protocol", 'protocol'); ?>
                                        <div class="controls">
                                            <?php
                                            $popt = array('mail' => 'PHP Mail Function', 'sendmail' => 'Send Mail', 'smtp' => 'SMTP');
                                            echo form_dropdown('protocol', $popt, set_value('protocol', isset($form_data['protocol']) ? $form_data['protocol'] : $settings['protocol']), 'class="form-control tip select2" id="protocol" style="width:100%;" required="required"');
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?= lang("smtp_host", 'smtp_host'); ?>
                                        <div class="controls"> <?php echo form_input('smtp_host', set_value('smtp_host', isset($form_data['smtp_host']) ? $form_data['smtp_host'] : $settings['smtp_host']), 'class="form-control tip" id="smtp_host" required maxlength="50"'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?= lang("smtp_user", 'smtp_user'); ?>
                                        <div class="controls"> <?php echo form_input('smtp_user', set_value('smtp_user', isset($form_data['smtp_user']) ? $form_data['smtp_user'] : $settings['smtp_user']), 'class="form-control tip" id="smtp_user" required maxlength="80"'); ?> </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?= lang("smtp_pass", 'smtp_pass'); ?>
                                        <div class="controls"> <?php echo form_password('smtp_pass', set_value('smtp_pass', isset($form_data['smtp_pass']) ? $form_data['smtp_pass'] : $settings['smtp_port']), 'class="form-control tip" id="smtp_pass" required maxlength="25"'); ?> </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?= lang("smtp_port", 'smtp_port'); ?>
                                        <div class="controls"> <?php echo form_input('smtp_port', set_value('smtp_port', isset($form_data['smtp_port']) ? $form_data['smtp_port'] : $settings['smtp_port']), 'class="form-control tip" id="smtp_port" required maxlength="10" oninput="this.value = this.value.replace(/[^0-9.]/g, \'\');"'); ?> </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?= lang("smtp_crypto", 'smtp_crypto'); ?>
                                        <?php
                                        $crypto_opt = array('' => lang('none'), 'tls' => 'TLS', 'ssl' => 'SSL');
                                        echo form_dropdown('smtp_crypto', $crypto_opt, set_value('smtp_crypto', isset($form_data['smtp_crypto']) ? $form_data['smtp_crypto'] : $settings['smtp_crypto']), 'class="form-control tip select2" id="smtp_crypto" style="width:100%;" required');
                                        ?>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>

                <div class="box" style="border-top: 0px solid;">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <p><?= lang('shortcut_heading') ?></p>

                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('focus_add_item', 'focus_add_item'); ?>
                                            <?php echo form_input('focus_add_item', set_value('focus_add_item', isset($form_data['focus_add_item']) ? $form_data['focus_add_item'] : $settings['focus_add_item']), 'class="form-control tip" id="focus_add_item" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('add_customer', 'add_customer'); ?>
                                            <?php echo form_input('add_customer', set_value('add_customer', isset($form_data['add_customer']) ? $form_data['add_customer'] : $settings['add_customer']), 'class="form-control tip" id="add_customer" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('toggle_category_slider', 'toggle_category_slider'); ?>
                                            <?php echo form_input('toggle_category_slider', set_value('toggle_category_slider', isset($form_data['toggle_category_slider']) ? $form_data['toggle_category_slider'] : $settings['toggle_category_slider']), 'class="form-control tip" id="toggle_category_slider" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('cancel_sale', 'cancel_sale'); ?>
                                            <?php echo form_input('cancel_sale', set_value('cancel_sale', isset($form_data['cancel_sale']) ? $form_data['cancel_sale'] : $settings['cancel_sale']), 'class="form-control tip" id="cancel_sale" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('suspend_sale', 'suspend_sale'); ?>
                                            <?php echo form_input('suspend_sale', set_value('suspend_sale', isset($form_data['suspend_sale']) ? $form_data['suspend_sale'] : $settings['suspend_sale']), 'class="form-control tip" id="suspend_sale" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('print_order', 'print_order'); ?>
                                            <?php echo form_input('print_order', set_value('print_order', isset($form_data['print_order']) ? $form_data['print_order'] : $settings['print_order']), 'class="form-control tip" id="print_order" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('print_bill', 'print_bill'); ?>
                                            <?php echo form_input('print_bill', set_value('print_bill', isset($form_data['print_bill']) ? $form_data['print_bill'] : $settings['print_bill']), 'class="form-control tip" id="print_bill" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('finalize_sale', 'finalize_sale'); ?>
                                            <?php echo form_input('finalize_sale', set_value('finalize_sale', isset($form_data['finalize_sale']) ? $form_data['finalize_sale'] : $settings['finalize_sale']), 'class="form-control tip" id="finalize_sale" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('today_sale', 'today_sale'); ?>
                                            <?php echo form_input('today_sale', set_value('today_sale', isset($form_data['today_sale']) ? $form_data['today_sale'] : $settings['today_sale']), 'class="form-control tip" id="today_sale" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('open_hold_bills', 'open_hold_bills'); ?>
                                            <?php echo form_input('open_hold_bills', set_value('open_hold_bills', isset($form_data['open_hold_bills']) ? $form_data['open_hold_bills'] : $settings['open_hold_bills']), 'class="form-control tip" id="open_hold_bills" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4">
                                        <div class="form-group">
                                            <?= lang('close_register', 'close_register'); ?>
                                            <?php echo form_input('close_register', set_value('close_register', isset($form_data['close_register']) ? $form_data['close_register'] : $settings['close_register']), 'class="form-control tip" id="close_register" required maxlength="20"'); ?>
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>

                <div class="box" style="border-top: 0px solid;">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('direccion', 'direccion') ?>
                                    <?= form_input('direccion', set_value('direccion', isset($form_data['direccion']) ? $form_data['direccion'] : $settings['direccion']), 'class="form-control" id="direccion" required="required" maxlength="150"') ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('region', 'region') ?>
                                    <?= form_input('region', set_value('region', isset($form_data['region']) ? $form_data['region'] : $settings['region']), 'class="form-control" id="region" required="required" maxlength="20"') ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('pais', 'pais') ?>
                                    <?= form_input('pais', set_value('pais', isset($form_data['pais']) ? $form_data['pais'] : $settings['pais']), 'class="form-control" id="pais" required="required" maxlength="20"') ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box" style="border-top: 0px solid;">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <?= lang('login_logo', 'logo'); ?>
                                            <input type="file" name="userfile" id="logo" accept=".jpg, .png, .jpeg">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            <div id="tab2" style="display:none;">
            <div class="box" style="border-top: 2.5px solid #004785;"s>
                    <div class="box-body">
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="checkbox" <?= ($settings['retencion'] == 1) ? 'checked' : '' ?> id="retencion" name="retencion" data-style="ios" data-onstyle="primary" data-toggle="toggle" data-on=" " data-off=" " data-size="mini">
                                        <?= lang('retencion', 'retencion') ?>
                                        <input type="hidden" value="<?= set_value('retencion_hidden', isset($form_data['retencion']) ? $form_data['retencion'] : $settings['retencion']); ?>" id="retencion_hidden" name="retencion_hidden">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="checkbox" <?= ($settings['gratuito'] == 1) ? 'checked' : '' ?> id="gratuito" name="gratuito" data-style="ios" data-onstyle="primary" data-toggle="toggle" data-on=" " data-off=" " data-size="mini">
                                        <?= lang('gratuito', 'gratuito') ?>
                                        <input type="hidden" value="<?= set_value('gratuito_hidden', isset($form_data['gratuito']) ? $form_data['gratuito'] : $settings['gratuito']); ?>" id="gratuito_hidden" name="gratuito_hidden">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <?php
                                            $new_number = (int)$settings['invoice_number'] + 1;
                                            $invoice_format = $settings['invoice_format'];

                                            $parte1 = explode('{', $invoice_format);
                                            $parte2 = explode('}', $parte1[1]);

                                            $parentesis = $parte2[0];

                                            $buscar = strpos($parentesis, '+');
                                            if ($buscar) {
                                                $numero = explode('+', $parentesis);
                                                $new_format = str_pad((string)$new_number, strlen($numero[0]), "0", STR_PAD_LEFT);
                                            } else {
                                                $new_format = str_pad((string)$new_number, strlen($parentesis), "0", STR_PAD_LEFT);
                                            }

                                            $next_invoice = $parte1[0] . $new_format;

                                            ?>
                                            <?= lang('invoice_format', 'invoice_format') . ' - Siguiente N°: ' . $next_invoice; ?>
                                            <?= form_input('invoice_format', set_value('invoice_format', isset($form_data['invoice_format']) ? $form_data['invoice_format'] : $settings['invoice_format']), 'class="form-control tip" id="invoice_format"  required="required" maxlength="20"'); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <?php
                                            $new_number = (int)$settings['bill_number'] + 1;
                                            $bill_format = $settings['bill_format'];

                                            $parte1 = explode('{', $bill_format);
                                            $parte2 = explode('}', $parte1[1]);

                                            $parentesis = $parte2[0];

                                            $buscar = strpos($parentesis, '+');
                                            if ($buscar) {
                                                $numero = explode('+', $parentesis);
                                                $new_format = str_pad((string)$new_number, strlen($numero[0]), "0", STR_PAD_LEFT);
                                            } else {
                                                $new_format = str_pad((string)$new_number, strlen($parentesis), "0", STR_PAD_LEFT);
                                            }

                                            $next_bill = $parte1[0] . $new_format;
                                            ?>
                                            <?= lang('bill_format', 'bill_format') . ' - Siguiente N° : ' . $next_bill; ?>
                                            <?= form_input('bill_format', set_value('bill_format', isset($form_data['bill_format']) ? $form_data['bill_format'] : $settings['bill_format']), 'class="form-control tip" id="bill_format"  required="required" maxlength="20"'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <?php
                                            $new_number = (int)$settings['nventa_number'] + 1;
                                            $nventa_format = $settings['nventa_format'];

                                            $parte1 = explode('{', $nventa_format);
                                            $parte2 = explode('}', $parte1[1]);

                                            $parentesis = $parte2[0];

                                            $buscar = strpos($parentesis, '+');
                                            if ($buscar) {
                                                $numero = explode('+', $parentesis);
                                                $new_format = str_pad((string)$new_number, strlen($numero[0]), "0", STR_PAD_LEFT);
                                            } else {
                                                $new_format = str_pad((string)$new_number, strlen($parentesis), "0", STR_PAD_LEFT);
                                            }

                                            $next_venta = $parte1[0] . $new_format;
                                            ?>
                                            <?= lang('nventa_format', 'nventa_format') . ' - Siguiente N° ' . $next_venta; ?>
                                            <?= form_input('nventa_format', set_value('nventa_format', isset($form_data['nventa_format']) ? $form_data['nventa_format'] : $settings['nventa_format']), 'class="form-control tip" id="nventa_format"  required="required" maxlength="20"'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <?php
                                            $new_number = (int)$settings['note_credit_bill_number'] + 1;
                                            $note_credit_bill_format = $settings['note_credit_bill_format'];

                                            $parte1 = explode('{', $note_credit_bill_format);
                                            $parte2 = explode('}', $parte1[1]);

                                            $parentesis = $parte2[0];

                                            $buscar = strpos($parentesis, '+');
                                            if ($buscar) {
                                                $numero = explode('+', $parentesis);
                                                $new_format = str_pad((string)$new_number, strlen($numero[0]), "0", STR_PAD_LEFT);
                                            } else {
                                                $new_format = str_pad((string)$new_number, strlen($parentesis), "0", STR_PAD_LEFT);
                                            }

                                            $next_note_credit = $parte1[0] . $new_format;
                                            ?>
                                            <?= lang('note_credit_bill_format', 'note_credit_bill_format') . ' - Siguiente N°: ' . $next_note_credit; ?>
                                            <?= form_input('note_credit_bill_format', set_value('note_credit_bill_format', isset($form_data['note_credit_bill_format']) ? $form_data['note_credit_bill_format'] : $settings['note_credit_bill_format']), 'class="form-control tip" id="note_credit_bill_format"  required="required" maxlength="20"'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <?php
                                            $new_number = (int)$settings['note_credit_invoice_number'] + 1;
                                            $note_credit_invoice_format = $settings['note_credit_invoice_format'];

                                            $parte1 = explode('{', $note_credit_invoice_format);
                                            $parte2 = explode('}', $parte1[1]);

                                            $parentesis = $parte2[0];

                                            $buscar = strpos($parentesis, '+');
                                            if ($buscar) {
                                                $numero = explode('+', $parentesis);
                                                $new_format = str_pad((string)$new_number, strlen($numero[0]), "0", STR_PAD_LEFT);
                                            } else {
                                                $new_format = str_pad((string)$new_number, strlen($parentesis), "0", STR_PAD_LEFT);
                                            }

                                            $next_note_credit = $parte1[0] . $new_format;
                                            ?>
                                            <?= lang('note_credit_invoice_format', 'note_credit_invoice_format') . ' - Siguiente N°: ' . $next_note_credit; ?>
                                            <?= form_input('note_credit_invoice_format', set_value('note_credit_invoice_format', isset($form_data['note_credit_invoice_format']) ? $form_data['note_credit_invoice_format'] : $settings['note_credit_invoice_format']), 'class="form-control tip" id="note_credit_invoice_format"  required="required" maxlength="20"'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box" >
                    <div class="box-body">
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang("default_discount", 'default_discount'); ?>
                                        <?= form_input('default_discount', set_value('default_discount', isset($form_data['default_discount']) ? $form_data['default_discount'] : $settings['default_discount']), 'class="form-control" id="default_discount" required="required" maxlength="11" oninput="this.value = this.value.replace(/[^0-9.]/g, \'\');"'); ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('delete_code', 'pin_code'); ?>
                                        <?php echo form_password('pin_code', set_value('pin_code', isset($form_data['pin_code']) ? $form_data['pin_code'] : $settings['pin_code']), 'class="form-control" name="pin_code" id="pin_code" required maxlength="20"'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('display_kb', 'display_kb') ?>
                                        <?php
                                        $dtime = array('1' => lang('yes'), '0' => lang('no'));
                                        echo form_dropdown('display_kb', $dtime, set_value('display_kb', isset($form_data['display_kb']) ? $form_data['display_kb'] : $settings['display_kb']), 'class="form-control select2" id="display_kb" style="width:100%;" required="required"') ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang("item_addition", "item_addition"); ?>
                                        <?php
                                        $ia = array(0 => lang('add_new_item'), 1 => lang('increase_quantity_if_item_exist'));
                                        echo form_dropdown('item_addition', $ia, set_value('item_addition', isset($form_data['item_addition']) ? $form_data['item_addition'] : $settings['item_addition']), 'id="item_addition" class="form-control tip select2" required="required" style="width:100%;"');
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('default_category', 'default_category'); ?>
                                        <?php
                                        foreach ($categories as $catrgory) {
                                            $ct[$catrgory->id] = $catrgory->name;
                                        }
                                        echo form_dropdown('default_category', $ct, set_value('default_category', isset($form_data['default_category']) ? $form_data['default_category'] : $settings['default_category']), 'class="form-control select2" style="width:100%;" id="default_category" required="required"'); ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('default_customer', 'default_customer'); ?>
                                        <?php
                                        foreach ($customers as $customer) {
                                            $cu[$customer['id']] = $customer['name'];
                                        }
                                        echo form_dropdown('default_customer', $cu, set_value('default_customer', isset($form_data['default_customer']) ? $form_data['default_customer'] : $settings['default_customer']), 'class="form-control select2" style="width:100%;" id="default_customer" required="required"'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang("default_warehouse", 'default_warehouse'); ?>
                                        <?php
                                        // $wh[""] = lang("none2");
                                        foreach ($warehouses as $warehouse) {
                                            $wh[$warehouse->id] = $warehouse->warehouse;
                                        }
                                        echo form_dropdown('default_warehouse', $wh, set_value('default_warehouse', isset($form_data['default_warehouse']) ? $form_data['default_warehouse'] : $settings['default_warehouse']), 'class="form-control select2" style="width:100%;" id="default_warehouse" required="required"'); ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('display_product', 'display_product') ?>
                                        <?php
                                        $dprv = array('1' => 'Nombre', '2' => 'Foto', '3' => 'Ambos');
                                        echo form_dropdown('display_product', $dprv, set_value('display_product', isset($form_data['display_product']) ? $form_data['display_product'] : $settings['bsty']), 'class="form-control select2" id="display_product" style="width:100%;" required="required"') ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <?= lang('pro_limit', 'pro_limit') ?>
                                        <?= form_input('pro_limit', set_value('pro_limit', isset($form_data['pro_limit']) ? $form_data['pro_limit'] : $settings['pro_limit']), 'class="form-control" id="pro_limit" required="required"') ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <!-- <?= lang("tax_ICBPER", 'tax_ICBPER'); ?> -->
                                        <?= lang('tax_ICBPER', 'tax_ICBPER'); ?>
                                        <?php $aSale = array('0' => lang('ICBPER_sin'), '1' => lang('ICBPER_2019'), '2' => lang('ICBPER_2020'), '3' => lang('ICBPER_2021'), '4' => lang('ICBPER_2022'), '5' => lang('ICBPER_2023')); ?>
                                        <!-- <?= form_input('advanced_sale_code', set_value('advanced_sale_code', isset($form_data['advanced_sale_code']) ? $form_data['advanced_sale_code'] : $settings['tax_icbper']), 'class="form-control" id="advanced_sale_code" required="required"'); ?> -->
                                        <?= form_dropdown('tax_ICBPER', $aSale, set_value('tax_ICBPER', $settings['tax_icbper']), 'class="form-control select2" id="tax_ICBPER_code" style="width:100%;" required="required"'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <!-- <?= lang("type_Print", 'type_Print'); ?> -->
                                        <?= lang('type_Print', 'type_Print'); ?>
                                        <?php $aSale = array('0' => lang('usar voucher'), '1' => lang('usar pdf')); ?>
                                        <!-- <?= form_input('type_Print', set_value('type_Print', isset($form_data['type_Print']) ? $form_data['type_Print'] : $settings['type_Print']), 'class="form-control" id="type_Print" required="required"'); ?> -->
                                        <?= form_dropdown('type_Print', $aSale, set_value('type_Print', $settings['type_Print']), 'class="form-control select2" id="type_Print" style="width:100%;" required="required"'); ?>
                                    </div>
                                </div>
                                <div class="col col-md-6">
                                    <?= lang("default_pdf", 'default_pdf'); ?>
                                    <div class="form-group">
                                        <select name="pdf_format" onchange="imagenpdf(this.options[this.selectedIndex].value)" class="form-control select2" style="width:80%;" id="default_pdf" required="required">
                                            <?php if ($settings['pdf_format'] == 1) { ?>
                                                <option value="1" selected>formato de pdf 1 </option>
                                                <option value="2">formato de pdf 2 </option>
                                            <?php } else if ($settings['pdf_format'] == 2) { ?>
                                                <option value="1" selected>formato de pdf 1 </option>
                                                <option value="2" selected>formato de pdf 2 </option>
                                            <?php } ?>
                                        </select>
                                        <img src="" id="img" alt="Demo" width="100" height="100" onclick="tamañoimagen(this.width,this.height)" style=" visibility: hidden;">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                
                <div class="box" style="border-top: 0px solid;">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <?= lang("bill_header", 'bill_header'); ?>
                                            <?= form_textarea('bill_header', set_value('bill_header', isset($form_data['bill_header']) ? $form_data['bill_header'] : $settings['header']), 'class="form-control redactor" id="bill_header"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <?= lang("bill_footer", 'bill_footer'); ?>
                                            <?= form_textarea('bill_footer', set_value('bill_footer', isset($form_data['bill_footer']) ? $form_data['bill_footer'] : $settings['footer']), 'class="form-control redactor" id="bill_footer"'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>                            
                <!--<div class="box" style="border-top: 0px solid;">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">

                                <div class="form-group">
                                     <?= lang("advanced_sale", 'advanced_sale'); ?> 
                                    <?= lang('advanced_sale', 'advanced_sale'); ?>
                                    <?php $aSale = array('0' => lang('no'), '1' => lang('yes')); ?>
                                    <?= form_input('advanced_sale_code', set_value('advanced_sale_code', isset($form_data['advanced_sale_code']) ? $form_data['advanced_sale_code'] : $settings['advanced_sale']), 'class="form-control" id="advanced_sale_code" required="required"'); ?> 
                                    <?= form_dropdown('advanced_sale', $aSale, set_value('advanced_sale', $settings['advanced_sale']), 'class="form-control select2" style="width:100%;" id="advanced_sale_code"  required="required"'); ?>
                                </div>



                                <div class="col-md-12">
                                        <div class="form-group">
                                            <input type="checkbox" <?= ($settings['negocio']) == 1 ? 'checked' : '' ?> id="negocio" name="negocio" data-style="ios" data-onstyle="warning" data-toggle="toggle" data-on=" " data-off=" ">
                                            <?= lang('negocio', 'negocio') ?>
                                            <input type="hidden" value="<?= set_value('negocio', isset($form_data['negocio']) ? $form_data['negocio'] : $settings['negocio']); ?>" id="negocio_hidden" name="negocio_hidden">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <input type="checkbox" <?= ($settings['habilita_btn_pago'] == 1) ? 'checked' : '' ?> id="habilita_btn_pago" name="habilita_btn_pago" data-style="ios" data-onstyle="warning" data-toggle="toggle" data-on=" " data-off=" ">
                                            <?= lang('habilita_btn_pago', 'habilita_btn_pago') ?>
                                            <input type="hidden" value="<?= set_value('habilita_btn_pago', isset($form_data['habilita_btn_pago']) ? $form_data['habilita_btn_pago'] : $settings['habilita_btn_pago']); ?>" id="habilita_btn_pago_hidden" name="habilita_btn_pago_hidden">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <input type="checkbox" <?= ($settings['habilita_btn_caja'] == 1) ? 'checked' : '' ?> id="habilita_btn_caja" name="habilita_btn_caja" data-style="ios" data-onstyle="warning" data-toggle="toggle" data-on=" " data-off=" ">
                                            <?= lang('habilita_btn_caja', 'habilita_btn_caja') ?>
                                            <input type="hidden" value="<?= set_value('habilita_btn_caja', isset($form_data['habilita_btn_caja']) ? $form_data['habilita_btn_caja'] : $settings['habilita_btn_caja']); ?>" id="habilita_btn_caja_hidden" name="habilita_btn_caja_hidden">
                                        </div>
                                    </div>

                            </div>-->




                <!---->


                <!---->






                <!--<div class="col-md-12">
                                    <div class="form-group">
                                        <input type="checkbox"  <?= ($settings['traders'] == 1) ? 'checked' : '' ?> id="traders" name="traders" data-style="ios" data-onstyle="warning" data-toggle="toggle" data-on=" " data-off=" ">
                                        <?= lang('traders', 'traders') ?>
                                        <input type="hidden" value="<?= set_value('traders', isset($form_data['traders']) ? $form_data['traders'] : $settings['traders']); ?>" id="traders_hidden" name="traders_hidden">
                                    </div>
                                </div>


                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang('logo_auth', 'logo_auth'); ?>
                                    <input type="file" name="logo_auth" id="logo_auth" accept=".jpg, .png, .jpeg">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang('logo_pdf', 'logo_pdf'); ?>
                                    <input type="file" name="logo_pdf" id="logo_pdf" accept=".jpg, .png, .jpeg">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang('pos_logo', 'pos_logo') ?>
                                    <?php
                                    $dposition = array('1' => lang('Vertical'), '2' => lang('Horizontal'));
                                    echo form_dropdown('pos_logo', $dposition, set_value('pos_logo', isset($form_data['pos_logo']) ? $form_data['pos_logo'] : $settings['pos_logo']), 'class="form-control select2" id="pos_logo" style="width:100%;" required="required"') ?>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div><?= lang("type_imagen_pdf", 'type_imagen_pdf'); ?></div>
                            <select name="type_imagen_pdf" onchange="typeImgPdf(this.options[this.selectedIndex].value)" class="form-control select2" style="width:80%;" id="type_imagen_pdf" required="required">
                                <?php if ($settings['type_imagen_pdf'] == 1) { ?>
                                    <option value="1" selected>Tipo de imágen PDF 1</option>
                                    <option value="2">Tipo de imágen PDF 2</option>
                                <?php } else if ($settings['type_imagen_pdf'] == 2) { ?>
                                    <option value="1" selected>Tipo de imágen PDF 1</option>
                                    <option value="2">Tipo de imágen PDF 2</option>
                                <?php } ?>
                            </select>
                            <img src="" id="imgTypeImagenPdf" alt="Demo" width="100" height="100" onclick="sizeImgPdf(this.width,this.height)" style="visibility: hidden;">
                        </div>
                    </div>
                </div>-->
            </div>
            <div id="tab3" style="display:none;">
                <div class="box" style="border-top: 2.5px solid #004785;">
                    <div class="box-body">
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <?php
                                            $new_number = (int)$settings['referral_guide_number'] + 1;
                                            $referral_guide_format = $settings['referral_guide_format'];

                                            $parte1 = explode('{', $referral_guide_format);
                                            $parte2 = explode('}', $parte1[1]);

                                            $parentesis = $parte2[0];

                                            $buscar = strpos($parentesis, '+');
                                            if ($buscar) {
                                                $numero = explode('+', $parentesis);
                                                $new_format = str_pad((string)$new_number, strlen($numero[0]), "0", STR_PAD_LEFT);
                                            } else {
                                                $new_format = str_pad((string)$new_number, strlen($parentesis), "0", STR_PAD_LEFT);
                                            }

                                            $next_note_credit = $parte1[0] . $new_format;
                                            ?>
                                            <?= lang('referral_guide_format', 'referral_guide_format') . ' - Siguiente N°: ' . $next_note_credit; ?>
                                            <?= form_input('referral_guide_format', set_value('referral_guide_format', isset($form_data['referral_guide_format']) ? $form_data['referral_guide_format'] : $settings['referral_guide_format']), 'class="form-control tip" id="referral_guide_format"  required="required" maxlength="20"'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col col-md-6">

                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <!-- Codigo para la pestaña 2-->
            <div id="tab4" style="display:none;">
                <div class="box" style="border-top: 2.5px solid #004785;">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <?= lang('mode', 'mode') ?><br />
                                    <?= lang('beta', 'beta') ?> &nbsp; &nbsp;

                                    <?php
                                    if ($settings['beta'] == 1) {
                                        $check_box = "";
                                        $datos_beta = "block";
                                        $datos_produc = "none";
                                    } else {
                                        $check_box = "Checked";
                                        $datos_beta = "none";
                                        $datos_produc = "block";
                                    }
                                    ?>
                                    <input type="checkbox" <?= $check_box; ?> id="beta_checkbox" name="beta_checkbox" data-style="ios slow" data-onstyle="success" data-toggle="toggle" data-on=" " data-off=" " data-size="small">
                                    &nbsp;&nbsp; <?= lang('produccion', 'produccion') ?>
                                    <input type="hidden" value="<?= $settings['beta']; ?>" id="beta_hidden" name="beta_hidden">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('ruc', 'ruc') ?>
                                    <?= form_input('ruc', set_value('ruc', isset($form_data['ruc']) ? $form_data['ruc'] : $settings['ruc']), 'class="form-control" id="ruc" disabled') ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('razon_social', 'razon_social') ?>
                                    <?= form_input('razon_social', set_value('razon_social', isset($form_data['razon_social']) ? $form_data['razon_social'] : $settings['razon_social']), 'class="form-control" id="razon_social" disabled') ?>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <hr class="border-box">
                                <p class="h5"><b>Usuario secundario SUNAT</b></p>
                                <p class="text-help"><i><?= lang('help_usuario_secundario') ?></i></p>
                                <div class="form-group">
                                    <div class="row">
                                        <!--------campos del usuario secundario produccion----------->
                                        <div class="col-md-6" style="display:<?= $datos_produc; ?>" id="div_user_sol">
                                            <div class="form-group">
                                                <?= lang('user_sol', 'user_sol') ?>
                                                <?= form_input('user_sol', set_value('user_sol', isset($form_data['user_sol']) ? $form_data['user_sol'] : $settings['user_sol']), 'class="form-control" id="user_sol" maxlength="8"') ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6" style="display:<?= $datos_produc; ?>" id="div_pass_sol">
                                            <div class="form-group">
                                                <?= lang('pass_sol', 'pass_sol') ?>
                                                <?= form_password('pass_sol', set_value('pass_sol', isset($form_data['pass_sol']) ? $form_data['pass_sol'] : $settings['pass_sol']), 'class="form-control" id="pass_sol" maxlength="15"') ?>
                                            </div>
                                        </div>

                                        <!--------campos del usuario secundario produccion----------->
                                        <!--------campos del usuario secundario beta----------->

                                        <div class="col-md-6" style="display:<?= $datos_beta; ?>" id="div_beta_user_sol">
                                            <div class="form-group">
                                                <?= lang('beta_user_sol', 'beta_user_sol') ?>
                                                <?= form_input('beta_user_sol', set_value('beta_user_sol', isset($form_data['beta_user_sol']) ? $form_data['beta_user_sol'] : $settings['beta_user_sol']), 'class="form-control" id="beta_user_sol" maxlength="8"') ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6" style="display:<?= $datos_beta; ?>" id="div_beta_pass_sol">
                                            <div class="form-group">
                                                <?= lang('beta_pass_sol', 'beta_pass_sol') ?>
                                                <?= form_password('beta_pass_sol', set_value('beta_pass_sol', isset($form_data['beta_pass_sol']) ? $form_data['beta_pass_sol'] : $settings['beta_pass_sol']), 'class="form-control" id="beta_pass_sol" maxlength="15"') ?>
                                            </div>
                                        </div>
                                        <!--------campos del usuario secundario produccion----------->
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <hr class="border-box">
                                <span class="h5"><b>Credenciales api SUNAT</b></span>
                                <p class="text-help"><i><?= lang('help_credenciales_api_sunat') ?></i></p>
                                <div class="form-group">
                                    <div class="row">
                                        <!-- ---------produccion----------->
                                        <div class="col-md-6" style="display:<?= $datos_produc; ?>" id="div_client_id">
                                            <div class="form-group">
                                                <?= lang('client_id', 'client_id')  ?>
                                                <?= form_input('client_id', set_value('client_id', isset($form_data['client_id']) ? $form_data['client_id'] : $settings['client_id']), 'class="form-control" id="client_id" maxlength="50"') ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6" style="display:<?= $datos_produc; ?>" id="div_client_pass">
                                            <div class="form-group">
                                                <?= lang('client_pass', 'client_pass') ?>
                                                <?= form_input('client_pass', set_value('client_pass', isset($form_data['client_pass']) ? $form_data['client_pass'] : $settings['client_pass']), 'class="form-control" id="client_pass" maxlength="50"') ?>
                                            </div>
                                        </div>
                                        <!---------------produccion------------------------->
                                        <!-- ---------beta----------->
                                        <div class="col-md-6" style="display:<?= $datos_beta; ?>" id="div_client_id_beta">
                                            <div class="form-group">
                                                <?= lang('beta_client_id', 'beta_client_id') ?>
                                                <?= form_input('beta_client_id', set_value('beta_client_id', isset($form_data['beta_client_id']) ? $form_data['beta_client_id'] : $settings['beta_client_id']), 'class="form-control" id="beta_client_id" maxlength="50"') ?>

                                            </div>
                                        </div>
                                        <div class="col-md-6" style="display:<?= $datos_beta; ?>" id="div_client_pass_beta">
                                            <div class="form-group">
                                                <?= lang('beta_client_pass', 'beta_client_pass') ?>
                                                <?= form_input('beta_client_pass', set_value('beta_client_pass', isset($form_data['beta_client_pass']) ? $form_data['beta_client_pass'] : $settings['beta_client_pass']), 'class="form-control" id="beta_client_pass" maxlength="50"') ?>
                                            </div>
                                        </div>
                                        <!-- ---------beta----------->
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <hr class="border-box">

                                <span class="h5"><b>Certificado digital</b></span>
                                <p class="text-help"><i><?= lang('help_certificado_digital') ?></i></p>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-md-6" style="display:<?= $datos_beta; ?>" id="div_beta_pass_firma">
                                            <div class="form-group">
                                                <?= lang('beta_pass_firma', 'beta_pass_firma') ?>
                                                <?= form_password('beta_pass_firma', set_value('beta_pass_firma', isset($form_data['beta_pass_firma']) ? $form_data['beta_pass_firma'] : $settings['beta_pass_firma']), 'class="form-control" id="beta_pass_firma" ') ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6" style="display:<?= $datos_produc; ?>" id="div_certificado">
                                            <div class="form-group">
                                                <?= lang('certificado', 'certificado') ?> &nbsp;&nbsp;&nbsp;&nbsp;
                                                <?php if ($exist_pfx == 1) { ?>
                                                    <label style="color: green;"><i class="fa fa-check-circle"></i> &nbsp;Se tiene un certificado digital cargado</label>
                                                <?php } else { ?>
                                                    <label style="color: red;"><i class="fa fa-times-circle-o"></i> &nbsp;No se tiene ningun certificado digital cargado</label>
                                                <?php } ?>
                                                <input type="file" name="certificado" id="certificado" accept=".pfx">

                                            </div>
                                        </div>
                                        <div class="col-md-6" style="display:<?= $datos_produc; ?>" id="div_pass_firma">
                                            <div class="form-group">
                                                <?= lang('pass_firma', 'pass_firma') ?>
                                                <?= form_password('pass_firma', set_value('pass_firma', isset($form_data['pass_firma']) ? $form_data['pass_firma'] : $settings['pass_firma']), 'class="form-control" id="pass_firma" ') ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div>
            <div class="clearfix"></div>
                <?= form_submit('update', lang('update_settings'), 'class="btn btn-sm btn-primary"'); ?>
            </div>
            <?= form_close(); ?>
        </div>
</section>
<script type="text/javascript">
    /**/
    $(document).ready(function() {
        if ($('#protocol').val() == 'smtp') {
            $('#smtp_config').slideDown();
        } else if ($('#protocol').val() == 'sendmail') {
            $('#sendmail_config').slideDown();
        }
        $('#protocol').change(function() {
            if ($(this).val() == 'smtp') {
                $('#sendmail_config').slideUp();
                $('#smtp_config').slideDown();
            } else if ($(this).val() == 'sendmail') {
                $('#smtp_config').slideUp();
                $('#sendmail_config').slideDown();
            } else {
                $('#smtp_config').slideUp();
                $('#sendmail_config').slideUp();
            }
        });
        /*
        if ($('#stripe').val() == 0) {
            $('#stripe_con').slideUp();
        } else {
            $('#stripe_con').slideDown();
        }
        $('#stripe').change(function() {
            if ($(this).val() == 0) {
                $('#stripe_con').slideUp();
            } else {
                $('#stripe_con').slideDown();
            }
        });
        */

        // $('#enable_java_applet').change(function () {
        //     var ja = $(this).val();
        //     if (ja == 1) {
        //         $('#jac').slideDown();
        //     } else {
        //         $('#jac').slideUp();
        //     }
        // });

        // var ja = '<?= $Settings->java_applet ?>';
        // if (ja == 1) {
        //     $('#jac').slideDown();
        // } else {
        //     $('#jac').slideUp();
        // }

    });

    /***************************************TRJ088 - KENY PONTE - 03/09/2019******************************* */
    function imagenpdf(value) {
        if (value == "") {
            document.getElementById("img").style = 'visibility:hidden';
            document.getElementById('img').width = 100
            document.getElementById('img').height = 100
        }
        if (value == 1) {
            document.getElementById("img").src = " <?= site_url('uploads/pdf1.png'); ?>";
            document.getElementById("img").style = 'visibility:visible';
            document.getElementById("img").style = 'cursor:pointer';
        } else if (value == 2) {
            document.getElementById("img").src = "<?= site_url('uploads/pdf2.png'); ?>";
            document.getElementById("img").style = 'visibility:visible';
            document.getElementById("img").style = 'cursor:pointer';
        }
    }

    function tamañoimagen(x, y) {
        if (x == 100 && y == 100) {
            document.getElementById('img').width = 500
            document.getElementById('img').height = 500
        } else if (x == 500 && y == 500) {
            document.getElementById('img').width = 100
            document.getElementById('img').height = 100

        }
    }

    function typeImgPdf(value) {
        if (value == "") {
            document.getElementById("imgTypeImagenPdf").style = 'visibility:hidden';
            document.getElementById('imgTypeImagenPdf').width = 100
            document.getElementById('imgTypeImagenPdf').height = 100
        }
        if (value == 1) {
            document.getElementById("imgTypeImagenPdf").src = " <?= site_url('uploads/type_img_pdf_1.png'); ?>";
            document.getElementById("imgTypeImagenPdf").style = 'visibility:visible';
            document.getElementById("imgTypeImagenPdf").style = 'cursor:pointer';
        } else if (value == 2) {
            document.getElementById("imgTypeImagenPdf").src = "<?= site_url('uploads/type_img_pdf_2.png'); ?>";
            document.getElementById("imgTypeImagenPdf").style = 'visibility:visible';
            document.getElementById("imgTypeImagenPdf").style = 'cursor:pointer';
        }
    }

    function sizeImgPdf(x, y) {
        if (x == 100 && y == 100) {
            document.getElementById('imgTypeImagenPdf').width = 376
            document.getElementById('imgTypeImagenPdf').height = 270
        } else if (x == 376 && y == 270) {
            document.getElementById('imgTypeImagenPdf').width = 100
            document.getElementById('imgTypeImagenPdf').height = 100
        }
    }

    /***************************************TRJ088 - KENY PONTE - 03/09/2019******************************* */

    $("#beta_checkbox").on('change', function() {

        var isChecked = document.getElementById('beta_checkbox').checked;

        if (isChecked) {
            document.getElementById("div_certificado").style.display = 'block';

            document.getElementById("div_beta_pass_firma").style.display = 'none';
            document.getElementById("div_beta_pass_sol").style.display = 'none';
            document.getElementById("div_beta_user_sol").style.display = 'none';
            document.getElementById("div_pass_firma").style.display = 'block';
            document.getElementById("div_pass_sol").style.display = 'block';
            document.getElementById("div_user_sol").style.display = 'block';
            document.getElementById("div_client_id_beta").style.display = 'none';
            document.getElementById("div_client_pass_beta").style.display = 'none';
            document.getElementById("div_client_id").style.display = 'block';
            document.getElementById("div_client_pass").style.display = 'block';
            $('#beta_hidden').val('0');
        } else {
            document.getElementById("div_certificado").style.display = 'none';

            document.getElementById("div_beta_pass_firma").style.display = 'block';
            document.getElementById("div_beta_pass_sol").style.display = 'block';
            document.getElementById("div_beta_user_sol").style.display = 'block';
            document.getElementById("div_pass_firma").style.display = 'none';
            document.getElementById("div_pass_sol").style.display = 'none';
            document.getElementById("div_user_sol").style.display = 'none';
            document.getElementById("div_client_id_beta").style.display = 'block';
            document.getElementById("div_client_pass_beta").style.display = 'block';
            document.getElementById("div_client_id").style.display = 'none';
            document.getElementById("div_client_pass").style.display = 'none';
            $('#beta_hidden').val('1');
        }

    });

    /**/
    // $(document).ready(function () {
    //     $('#type_imagen_pdf').change(function () {
    //         if ($(this).is(':checked')) {
    //             $('#type_imagen_pdf_hidden').val(1);
    //         } else {
    //             $('#type_imagen_pdf_hidden').val(2);
    //         }
    //     });
    //     $('#type_imagen_pdf_hidden').val($('#type_imagen_pdf').is(':checked') ? 1 : 2);
    // });

    $("#negocio").on('change', function() {
        var isChecked = document.getElementById('negocio').checked;
        if (isChecked) {
            $('#negocio_hidden').val('1');
        } else {
            $('#negocio_hidden').val('0');
        }
    });
    $("#habilita_btn_pago").on('change', function() {
        var isChecked = document.getElementById('habilita_btn_pago').checked;
        if (isChecked) {
            $('#habilita_btn_pago_hidden').val('1');
        } else {
            $('#habilita_btn_pago_hidden').val('0');
        }
    });
    $("#habilita_btn_caja").on('change', function() {
        var isChecked = document.getElementById('habilita_btn_caja').checked;
        if (isChecked) {
            $('#habilita_btn_caja_hidden').val('1');
        } else {
            $('#habilita_btn_caja_hidden').val('0');
        }
    });
    $("#traders").on('change', function() {
        var isChecked = document.getElementById('traders').checked;
        if (isChecked) {
            $('#traders_hidden').val('1');
        } else {
            $('#traders_hidden').val('0');
        }
    });
    $("#retencion").on('change', function() {
        var isChecked = document.getElementById('retencion').checked;
        if (isChecked) {
            $('#retencion_hidden').val('1');
        } else {
            $('#retencion_hidden').val('0');
        }
    });
    $("#gratuito").on('change', function() {
        var isChecked = document.getElementById('gratuito').checked;
        if (isChecked) {
            $('#gratuito_hidden').val('1');
        } else {
            $('#gratuito_hidden').val('0');
        }
    });
</script>
<script>
    //  const tabs = document.querySelectorAll('.tabs li');
    // const tabContent = document.querySelectorAll('.tab-content');

    // tabs.forEach(clickedTab => {
    //   clickedTab.addEventListener('click', () => {
    //     tabs.forEach(tab => {
    //       tab.classList.remove('active');
    //     });
    //     clickedTab.classList.add('active');

    //     const clickedTabIndex = Array.from(tabs).indexOf(clickedTab);
    //     tabContent.forEach(content => {
    //       content.classList.remove('active');
    //     });
    //     tabContent[clickedTabIndex].classList.add('active');
    //   });
    // });
    const tabs = document.querySelectorAll('.tabs li');
    const tabContent = document.querySelectorAll('div[id^="tab"]');

    tabs.forEach(clickedTab => {
        clickedTab.addEventListener('click', e => {
            e.preventDefault();
            const objetivo = e.target.getAttribute('href');
            tabContent.forEach(content => {
                content.style.display = 'none';
            });
            document.querySelector(objetivo).style.display = 'block';
            tabs.forEach(tab => {
                tab.classList.remove('active');
            });
            clickedTab.classList.add('active');
        });
    });
</script>