//**************TRJ038 - ALEXANDER ROCA - 17/04/2019******************
//var metodoImpuestoGlob = [];
//var nombMetodoImpGlob = [];
//**************TRJ038 - ALEXANDER ROCA - 17/04/2019******************

document.addEventListener('DOMContentLoaded', (event) => {
    const numericInputs = document.querySelectorAll('.numeric-input');

    numericInputs.forEach(input => {
        input.addEventListener('input', () => {
            // Elimina todos los caracteres que no sean dígitos o un solo punto
            input.value = input.value.replace(/[^0-9.]/g, '');

            // Evita que el input comience con un punto
            if (input.value.startsWith('.')) {
                input.value = '';
            }

            // Permite solo un punto y limita a dos caracteres después del punto
            const parts = input.value.split('.');
            if (parts.length > 1) {
                input.value = parts[0] + '.' + parts.slice(1).join('').slice(0, 2);
            }
        });

        input.addEventListener('keydown', (event) => {
            const allowedKeys = ['Backspace', 'ArrowLeft', 'ArrowRight', 'Delete', 'Tab'];
            const ctrlKeyAllowed = ['a', 'c', 'v', 'x'];

            if (allowedKeys.includes(event.key) ||
                (event.ctrlKey && ctrlKeyAllowed.includes(event.key.toLowerCase()))) {
                return;
            }

            // Permitir un punto si no hay ya uno en el valor actual
            if (event.key === '.') {
                if (input.value.includes('.')) {
                    event.preventDefault();
                }
                return;
            }

            // Si no es un número, prevent default
            if (!/[0-9]/.test(event.key)) {
                event.preventDefault();
            }
        });
    });

    const textarea = document.getElementById('detalles_viaje');
    const label = document.getElementById('label_detalles_viaje');
    const helpBlock = document.getElementById('detalles_viaje_help');

    textarea.addEventListener('input', function () {
        if (textarea.value.trim() === '') {
            textarea.style.border = '1px solid #dc3545'; // Rojo
            label.style.color = '#dc3545'; // Rojo
            helpBlock.style.display = 'block'; // Mostrar ayuda
        } else {
            textarea.style.border = '1px solid #28a745'; // Verde
            label.style.color = '#28a745'; // Verde
            helpBlock.style.display = 'none'; // Ocultar ayuda
        }
    });

});

$(document).on("input change", "#detraccion input", function () {
    var valor = $(this).val().trim(); // Obtener el valor del campo y quitar espacios en blanco al inicio y al final

    // Seleccionar el label asociado al campo actual
    var label = $(this).siblings("label");

    // Seleccionar el <small> asociado al campo actual
    var small = $(this).siblings("small");

    // Verificar si el campo está completo
    if (valor !== "") {
        $(this).css({
            "border": "1px solid #28a745", // Verde
            "background-color": "transparent"
        });
        label.css({
            "color": "#28a745" // Verde
        });
        small.hide(); // Ocultar el <small>
    } else {
        $(this).css({
            "border": "1px solid #dc3545", // Rojo
        });
        label.css({
            "color": "#dc3545" // Rojo
        });
        small.show(); // Mostrar el <small>
    }
});

$(document).ready(function () {

    

    $('#date').blur(function () {
        var dateValue = $(this).val();
        if (dateValue === "") {
            if ($('#date').val() === "") {
                // Muestra el mensaje de advertencia


                // Desplaza la página hacia arriba para mostrar el mensaje
                $("html, body").animate({
                    scrollTop: 0
                }, "slow");

                // Rojo para el borde cuando no se ingresa valor
                $(this).css("border", "1px solid #dc3545");
                $('#issue_date_2').css('color', '#dc3545');
                $("#date_help").show();
            }
        } else {
            // Oculta el mensaje de advertencia y aplica el borde verde si hay valor
            $("#date_help").hide();
            $(this).css("border", "1px solid #28a745");
            $('#issue_date_2').css('color', '#28a745');
        }
    });

    function validateDocumentType() {
        var documentValue = $('#document_type').val();
        console.log("Valor seleccionado: ", documentValue);

        if (documentValue === "") {
            console.log("No se seleccionó ningún documento.");

            // Muestra el mensaje de advertencia
            $('#doctype_help').show();

            $("html, body").animate({
                scrollTop: 0
            }, "slow");

            $('#doctype_help').css('display', 'block');

            $('#document_type').next('.select2-container').css("border", "1px solid #dc3545");
            $('#doctype_label_012').css('color', '#dc3545');

            return false;
        } else {
            console.log("Documento seleccionado correctamente.");

            $('#doctype_help').hide();

            $('#document_type').next('.select2-container').css("border", "1px solid #28a745");
            $('#doctype_label_012').css('color', '#28a745');

            return true;
        }
    }

    function validarFormulario() {
        let camposFaltantes = [];

        function validateField(fieldId, fieldName, helpId, isSelect2 = true, additionalClass = "") {
            let fieldValue = $(fieldId).val().trim(); // Get the trimmed value of the field
            let helpElement = $(helpId); // The element that shows help/error messages
            let labelElement = $(`label[for='${fieldId.replace('#', '')}']`); // The label associated with the field

            if (fieldValue === "" || fieldValue === "0") {
                camposFaltantes.push(fieldName); // Add the field name to the missing fields list

                if (isSelect2) {
                    // Set the border color to red for Select2 fields
                    $(fieldId).siblings(".select2-container").find(".select2-selection").css("border-color", "#dc3545"); // Rojo
                } else {
                    $(fieldId).addClass(additionalClass); // Add additional class for non-Select2 fields
                }

                helpElement.css({
                    display: "block",
                    color: "#dc3545" // Rojo
                });



                labelElement.css({
                    color: "#dc3545" // Rojo
                });
            } else {

            }
        }

        if ($("#detraction_flag").val() == 1) { // DETRACCION HABILITADA

            // Validate select2 fields
            validateField("#tipo_operacion", "Tipo de operación", "#tipo_operacion_help");
            validateField("#medio_pago", "Medio de pago", "#medio_pago_help");
            validateField("#tipo_detraccion", "Tipo de detracción", "#tipo_detraccion_help");

            // Validate embarcacion fields if tipo_operacion is 1002
            if ($("#tipo_operacion").val() == 1002) {
                validateField("#matricula_embarcacion", "Matrícula de la Embarcación", "#matricula_embarcacion_help", false, "campo-incompleto-input");
                validateField("#nombre_embarcacion", "Nombre de la Embarcación", "#nombre_embarcacion_help", false, "campo-incompleto-input");
                validateField("#lugar_descarga", "Lugar de Descarga", "#lugar_descarga_help", false, "campo-incompleto-input");
                validateField("#cantidad_especie", "Cantidad de la Especie", "#cantidad_especie_help", false, "campo-incompleto-input");
                validateField("#descripcion_especie", "Descripción de la Especie", "#descripcion_especie_help", false, "campo-incompleto-input");
            }

            // Validate fields if tipo_operacion is 1004
            if ($("#tipo_operacion").val() == 1004) {
                validateField("#direc_origen", "Dirección de Origen", "#direc_origen_help", false, "campo-incompleto-input");

                validateField("#depart_origen", "Departamento de Origen", "#depart_origen_help");
                validateField("#provin_origen", "Provincia de Origen", "#provin_origen_help");
                validateField("#distri_origen", "Distrito de Origen", "#distri_origen_help");

                validateField("#direccion_destino", "Dirección del Destino", "#direccion_destino_help", false, "campo-incompleto-input");

                validateField("#depart_dest", "Departamento del Destino", "#depart_dest_help");
                validateField("#provin_dest", "Provincia del Destino", "#provin_dest_help");
                validateField("#distri_dest", "Distrito del Destino", "#distri_dest_help");

                validateField("#detalles_viaje", "Detalle del Viaje", "#detalles_viaje_help", false, "campo-incompleto-input");
                validateField("#vref_servicio_transporte", "V.Ref. Servicio de Transporte", "#vref_servicio_transporte_help", false, "campo-incompleto-input");
                validateField("#vref_carga_efectiva", "V.Ref. Carga Efectiva", "#vref_carga_efectiva_help", false, "campo-incompleto-input");
                validateField("#vref_carga_util", "V.Ref. Carga Útil", "#vref_carga_util_help", false, "campo-incompleto-input");
            }


        }
    }





    // function clearValidationStyles() {
    //     $(".select2-container .select2-selection").css("border-color", "");

    //     $("input").each(function () {
    //         $(this).css("border-color", "").removeClass("campo-incompleto-input");
    //     });

    //     $(".help").css({ display: "none", color: "" });

    //     $("label").css("color", "");

    //     $("small").hide();
    // }

    function clearValidationStyles(container) {
        // Limpiar el color del borde de los contenedores Select2 dentro del contenedor especificado
        $(container).find(".select2-container .select2-selection").css("border-color", "");

        // Limpiar el color del borde y remover la clase de elementos de entrada dentro del contenedor especificado
        $(container).find("input").each(function () {
            $(this).css("border-color", "").removeClass("campo-incompleto-input");
        });

        // Ocultar elementos de ayuda y restablecer el color dentro del contenedor especificado
        $(container).find(".help").css({ display: "none", color: "" });

        // Restablecer el color de las etiquetas dentro del contenedor especificado
        $(container).find("label").css("color", "");

        // Ocultar elementos pequeños dentro del contenedor especificado
        $(container).find("small").hide();
    }

    $("#detracion_interruptor").on("change", function () {
        if ($(this).is(":checked")) {
        } else {
            clearValidationStyles("#detraccion");

        }
    });

    $("#tipo_operacion").on("change", function () {
        $("#detracion_1002, #detracion_1004").each(function () {
            $(this).find(".select2-container .select2-selection").css("border-color", "");

            $(this).find("input").each(function () {
                $(this).css("border-color", "").removeClass("campo-incompleto-input");
            });

            $(this).find("textarea").css("border-color", "").val("").removeClass("campo-incompleto-input");


            $(this).find(".help").css({ display: "none", color: "" });

            $(this).find("label").css("color", "");

            $(this).find("small").hide();
        });
    });

    const selectIds = [
        '#medio_pago',
        '#tipo_operacion',
        '#tipo_detraccion',
        '#depart_origen',
        '#provin_origen',
        '#distri_origen',
        '#depart_dest',
        '#provin_dest',
        '#distri_dest',
    ];

    // Añadir un evento 'change' a cada select
    selectIds.forEach(id => {
        $(id).on('change', function () {
            // Cambia el borde y el color del label basado en el valor del select
            if ($(this).val() !== "" && $(this).val() !== null && $(this).val() !== "0" && $(this).val() !== 0) {
                // Si el valor es válido
                $(this).siblings(".select2-container").find(".select2-selection").css("border-color", "#28a745");

                let labelElement = $(`label[for='${id.replace('#', '')}']`);
                labelElement.css("color", "#28a745");

                // Oculta el <small> relacionado si es visible
                $(this).siblings("small").hide();
            } else {
                // Si el valor es inválido
                $(this).siblings(".select2-container").find(".select2-selection").css("border-color", "#dc3545");

                let labelElement = $(`label[for='${id.replace('#', '')}']`);
                labelElement.css("color", "#dc3545");

                // Muestra el <small> relacionado
                $(this).siblings("small").show();
            }
        });

        // Inicializar Select2
        $(id).select2();
    });

    if (get('spoitems')) {
        remove('spoitems');
    }

    if ($("#fflag").val() == 0) {
        loadItems();
    }

    // $("#date").inputmask("yyyy-mm-dd hh:mm", {"placeholder": "yyyy-mm-dd hh:mm"});
    $("#date").inputmask("yyyy-mm-dd", { "placeholder": "yyyy-mm-dd" });
    $("#expiration_date").inputmask("yyyy-mm-dd", { "placeholder": "yyyy-mm-dd" });

    $("#add_item").autocomplete({
        source: base_url + 'sales/suggestions',
        minLength: 1,
        autoFocus: false,
        delay: 200,
        response: function (event, ui) {

        },
        select: function (event, ui) {
            event.preventDefault();
            if (ui.item.id !== 0) {

                if ($('#customer').val() !== "") {
                    //var customer_selected = $("#customer").find(':selected');
                    //var customers_type_id = customer_selected.attr('data-customertype')
                    var customers_type_id = $("#customer_type").val() /*? $("#customer_type").val() : false;*/
                    $.ajax({
                        type: "GET",
                        url: base_url + 'products/getProducPrice',
                        data: { "customers_type_id": customers_type_id, "product_id": ui.item.row.productID },
                        dataType: "json",
                        async: false,
                        success: function (response) {
                            if (response.result == 'ok') {
                                ui.item.row.price = response.data.price;
                            }
                        }
                    });

                }
                add_order_item(ui.item);
                $(this).val('');
            } else {
                // bootbox.alert(lang.no_match_found);
            }
        }
    });

    function sumarCantidadItem(row) {
        arraycode = [];
        var repetidos = {};
        var code = row.code;
        for (var prop in spoitems) {
            arraycode.push(spoitems[prop]["row"]["code"])
        }
        arraycode.forEach(function (codigo) {
            repetidos[codigo] = (repetidos[codigo] || 0) + 1;
        });
        if (repetidos[code] > 1) {
            // console.log("invalido")
            first_code = Object.keys(spoitems).sort().pop();
            delete_order_item(first_code);
            var input = $(".rquantity");
            a = input.attr("data-item");
            var item_id_pos = [];
            for (var p in spoitems) {

                if (code == spoitems[p]["row"]["code"]) {

                    spoitems[spoitems[p]["item_id"]].row.qty = parseFloat(spoitems[spoitems[p]["item_id"]].row.qty) + 1;
                    store('spoitems', JSON.stringify(spoitems));
                    loadItems();

                }
            }
        } else {
            // console.log("valido")
        }
    }

    $('#add_item').bind('keypress', function (e) {
        if (e.keyCode == 13) {
            e.preventDefault();
        }
    });

    $('#reset').click(function (e) {
        bootbox.confirm(lang.r_u_sure, function (result) {
            if (result) {
                if (get('spoitems')) {
                    remove('spoitems');
                }

                window.location.reload();
            }
        });
    });

    $(document).on("change", '.rquantity', function () {
        var row = $(this).closest('tr');
        var val = 0;
        if (!$(this).val() || !isNaN($(this).val())) {
            val = $(this).val();
            if (val.trim() === "") {
                document.getElementById("warning_text").innerHTML = "La cantidad asignada no es válida.";
                displayOn('warning');
                val = 0;
            }
        } else {
            document.getElementById("warning_text").innerHTML = "La cantidad asignada no es válida.";
            displayOn('warning');
        }
        if (val < 0) {
            val = 0;
            document.getElementById("warning_text").innerHTML = "La cantidad no puede ser menor a 0.";
            displayOn('warning');
        }
        var new_qty = parseFloat(val);
        item_id = row.attr('data-item-id');
        spoitems[item_id].row.qty = new_qty;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();
    });

    $(document).on("change", '.rprice', function () {
        var row = $(this).closest('tr');
        var val = 0.00;
        if (!$(this).val() || !isNaN($(this).val())) {
            val = $(this).val();
            if (val.trim() === "") {
                val = 0.00;
            }
        }
        var new_price = parseFloat(val).toFixed(3);
        item_id = row.attr('data-item-id');
        spoitems[item_id].row.price = new_price;
        spoitems[item_id].row.edit = 1;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();
    });

    $(document).on("change", '.rPAffect', function () {
        var row = $(this).closest('tr');
        var val = 0.00;
        if (!$(this).val() || !isNaN($(this).val())) {
            val = $(this).val();
            if (val.trim() === "") {
                val = 0.00;
            }
        }
        var new_priceAf = parseFloat(val).toFixed(3);
        item_id = row.attr('data-item-id');
        spoitems[item_id].affect_priceJs = new_priceAf;
        spoitems[item_id].row.edit = 1;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();
    });

    $(document).on("change", '.rPNonAffected', function () {
        var row = $(this).closest('tr');
        var val = 0.00;
        if (!$(this).val() || !isNaN($(this).val())) {
            val = $(this).val();
            if (val.trim() === "") {
                val = 0.00;
            }
        }
        var new_priceNaf = parseFloat(val).toFixed(3);
        item_id = row.attr('data-item-id');
        spoitems[item_id].non_affected_priceJs = new_priceNaf;
        spoitems[item_id].row.edit = 1;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();
    });

    $(document).on("change", '.rPExonerated', function () {
        var row = $(this).closest('tr');
        var val = 0.00;
        if (!$(this).val() || !isNaN($(this).val())) {
            val = $(this).val();
            if (val.trim() === "") {
                val = 0.00;
            }
        }
        var new_priceE = parseFloat(val).toFixed(3);
        item_id = row.attr('data-item-id');

        spoitems[item_id].exonerated_priceJs = new_priceE;
        spoitems[item_id].row.edit = 1;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();
    });

    $(document).on("change", $("#gdiscount"), function () {
        $("#gdiscount").val(Number($("#gdiscount").val()).toFixed(2));
        loadItems();
    });
    // <!--********START TRJ143 - DANIEL PADILLA - 20/12/2022*****************-->
    // $("#customer").change(function (e) {
    //     e.preventDefault();
    //     showHideRetainer();
    //     console.log('soy el customer');
    // });
    // $("#customer").change(function (e) {
    //     e.preventDefault();
    //     // showHideRetainer();
    //     // console.log('soy el customer');
    // });

    // $(document).ready(function() {
    //     $('#lista li').on('click', function() {
    //         console.log('soy el customer');
    //     });
    // });
    var customerIsRetainerGlobal;
    var customerRetainerPercentageGlobal;
    $('#customer').on('change', function (e) {
        e.preventDefault();

    });
    $('#lista > li').on('click', function () {
        // console.log('soy el customer');
        var customerIsRetainer = $(this).data('isretainer');
        var customerRetainerPercentage = $(this).data('retainerpercentage');
        $('#customer_is_retainer').val(customerIsRetainer) /*? $('#customer_is_retainer').val(customerIsRetainer) : false*/;
        $('#customer_retainer_percentage').val(customerRetainerPercentage) /*? $('#customer_retainer_percentage').val(customerRetainerPercentage) : false*/;
        //console.log(customerIsRetainer+' - '+customerRetainerPercentage);
        //showHideRetainer(customerIsRetainer,customerRetainerPercentage);
        //valoresParaOperacionRetainer(customerIsRetainer,customerRetainerPercentage);
        // function getTotalWithRetention(total) {
        //     console.log('getTotal ' + customerIsRetainer + ' - ' + customerRetainerPercentage);
        //     if ($('#document_type').val() == '2' && customerIsRetainer === 1) {
        //         var percentage = customerRetainerPercentage / 100;
        //         var monto_porcentage = total * percentage
        //         total = total - monto_porcentage
        //     }
        //     return total;
        // }
        // // var total = 1;
        // // var totalWithRetention = getTotalWithRetention(total);
        // console.log(getTotalWithRetention(1));
        // Asignar los valores a las variables globales
        customerIsRetainerGlobal = customerIsRetainer;
        customerRetainerPercentageGlobal = customerRetainerPercentage;
        //getTotalWithRetention(1);
    });


    // <!--********END TRJ143 - DANIEL PADILLA - 20/12/2022*****************-->

    $('#close').click(function (e) {
        displayOff('warning');
    });


    function resetHelpMessage(helpId) {
        $(helpId).css({
            display: "none",
            color: ""
        });
    }




    $('#add_sale').click(function (e) {




        var hay_cuotas = $('.pm_cuotas').css('display'); // Si es "none", no esta la tabla de cuotas
        if (hay_cuotas != "none") {
            const arrayFechaCuota = [];
            var tiene_error = false;
            var msj_error = "";
            $('.pm_credit_totalcuota').each(function (k, v) {
                if ($(this).val() === "") {
                    tiene_error = true;
                    msj_error = 'Los datos de las cuotas deben estar completados correctamente.';
                }
                if (parseFloat($(this).val()) == 0) {
                    tiene_error = true;
                    msj_error = 'El monto de la cuota debe ser distinto de cero.';
                }
            });

            // Recorre cada elemento de fecha
            $('.pm_credit_date').each(function (index) {
                if (index === 0) {
                    // Omite el primer índice (índice 0)
                    return true; // Continúa con el siguiente elemento
                }

                const dateValue = $(this).val();

                console.log(`Índice ${index} - Cada fecha:`, dateValue); // Muestra cada fecha procesada con el índice del elemento

                if (!dateValue) {
                    tiene_error = true;
                    msj_error = 'La fecha de pago de las cuotas no puede ser vacía.\n';
                    return false; // Salir del ciclo si hay un error
                } else if (arrayFechaCuota.includes(dateValue)) {
                    tiene_error = true;
                    msj_error = 'Las fechas de pago de las cuotas deben ser diferentes.';
                    return false; // Salir del ciclo si hay un error
                }

                arrayFechaCuota.push(dateValue);
            });

            // Mostrar todas las fechas recolectadas en la consola
            console.log('Fechas de cuota:', arrayFechaCuota);

            // Si hay un error, muestra el mensaje y evita el comportamiento por defecto
            if (tiene_error) {
                e.preventDefault();
                if (msj_error !== "") {
                    bootbox.alert(msj_error);
                }
                return false;
            }

            var gimptotal = parseFloat($("#gimptotal").val());

            if ($('#detraction_flag').val() == 0) {

                gimptotal = getTotalWithRetention(gimptotal);

            }

            var pm_credit_subtotal = formatMoney($('#pm_credit_subtotal').val());

            if (formatMoney(gimptotal) != pm_credit_subtotal) {
                e.preventDefault();
                bootbox.alert('El total del monto de las cuotas, debe coincidir con el importe total de la venta.');
                return false;
            }
        }

        var afecto_validar = document.getElementsByClassName('rPAffect');
        var inafecto_validar = document.getElementsByClassName('rPNonAffected');
        var exonerado_validar = document.getElementsByClassName('rPExonerated');
        var gratuito_validar = document.getElementsByClassName('rPGratuito');

        var valorClase = document.getElementsByClassName('rprice');
        var sumaValores = 0;
        var sensorCero = 0;

        for (var i = 0; i < afecto_validar.length; i++) {
            sumaValores = 0;
            sumaValores = parseFloat(afecto_validar[i].value) + parseFloat(inafecto_validar[i].value) + parseFloat(exonerado_validar[i].value) + parseFloat(gratuito_validar[i].value);
            if (sumaValores <= 0) {
                sensorCero = 1;
                break;
            }


        }
        //*****************TRJ044 - ALEXANDER ROCA - 24/05/2019***************

        

        if (sensorCero == 0) {
            code = $("#customer_id").val();
            datec = $("#date").val();
            if (code == 0 || code == "") {

                // console.log("ESTOY AKI");
                validarFormulario();

                if (!validateDocumentType()) {
                    e.preventDefault(); // Previene el envío del formulario

                }

                if (!get('spoitems') || $("#poTable tbody").text() == "") {

                    e.preventDefault();
                    document.getElementById("warning_text").innerHTML = lang.products_not_found;
                    displayOn('warning');
                    // $('html,body').animate({ scrollTop: 0 }, 'slow');
                    document.body.scrollTop = document.documentElement.scrollTop = 0;
                }

                $("#customer").val("");

                $("#customer_help").show();

                // Desplaza la página hacia arriba para mostrar el mensaje
                document.body.scrollTop = document.documentElement.scrollTop = 0;


                $("#customer").css("border", "1px solid #dc3545");
                $('#customer_label').css('color', '#dc3545');

                // // $("#customerModal").modal("show");
                // document.body.scrollTop = document.documentElement.scrollTop = 0;
                e.preventDefault();

                // console.log("ENTRANDO A ALERTA POR CLIENTE INEXISTENTE")


            } else if (datec == 0 || datec == "") {

                $('#issue_date_2').css('color', '#dc3545');
                $("#date_help").show();
                $("#date").css("border", "1px solid #dc3545");

                document.body.scrollTop = document.documentElement.scrollTop = 0;

                if (!get('spoitems') || $("#poTable tbody").text() == "") {

                    e.preventDefault();
                    document.getElementById("warning_text").innerHTML = lang.products_not_found;
                    displayOn('warning');
                    // $('html,body').animate({ scrollTop: 0 }, 'slow');
                    document.body.scrollTop = document.documentElement.scrollTop = 0;
                }

                validarFormulario();

                if (!validateDocumentType()) {
                    e.preventDefault(); // Previene el envío del formulario
                }

                e.preventDefault();

            } else
                if ($('#document_type').val() == 2) {
                    code = $("#customer_id").val();//console.log("piero es: ",code);
                    e.preventDefault();
                    $.ajax({
                        type: "get",
                        url: base_url + 'customers/get_customers_byid/' + code,
                        dataType: "json",
                        success: function (data) {

                            //console.log(data);
                            $("#cdireccion").val(data.direccion);
                            $("#reference_address").val( data.reference_address);
                            $("#cf2").val(data.cf2);
                            $("#cf1").val(data.cf1);
                            $("#cphone").val(data.phone);
                            $("#cemail").val(data.email);
                            $("#name").val(data.name);
                            $('#customer_type').val(data.customers_type_id).trigger('change.select2');
                            $('#accion-cliente').val(2);
                            $('#cModalLabel').text('Cliente - ' + (data.person_type == 1 ? data.cf1 : data.cf2));
                            $("#idclienteedit").val(data.id);
                            $("#add_customer").text("Guardar cambios");


                            $("#input_hidden_person_type").val(data.person_type);
                            $("#input_hidden_document_type").val(data.document_type_id);

                            if (code !== null && code !== undefined && code.trim() !== '') {
                                $("#div-document_type *").prop("disabled", true);
                                $("#div-person_type *").prop("disabled", true);
                                $("#name").prop("readonly", true);
                                $("#cf1").prop("readonly", true);
                            } else {
                                $("#div-document_type *").prop("disabled", false);
                                $("#div-person_type *").prop("disabled", false);
                                $("#name").prop("readonly", false);
                                $("#cf1").prop("readonly", false);
                            }

                            if (data.person_type == 1) {
                                $('#nombre-persona').text('Nombre *');
                                // $('#div-document_type').show();
                                $('#div-cf1').show();
                                $('#div-cf2').show();
                                $('label[for="cf2"]').text('RUC');

                                $('#doctypejs').val('');
                                $("#document-type option").show();
                                // Muestra las opciones relevantes según la selección inicial (por defecto, Persona Jurídica)
                                $("#document-type option[value='6']").hide();
                                $('label[for="direccion"]').text('Dirección');

                                $('#person-natural').attr('checked', true)
                                $('#div-document_type').show();

                            }
                            if (data.person_type == 2 || data.document_type_id == 6) {
                                $('#nombre-persona').text('Razón social *');
                                // $('#div-document_type').hide();
                                // $('#cf1').val('');                    
                                // Muestra el mensaje para Persona Jurídica
                                $("#document-type option").hide();
                                // Muestra las opciones relevantes según la selección inicial (por defecto, Persona Jurídica)
                                $("#document-type option[value='6']").show();
                                $('#document-type').val(6).trigger('change.select2');
                                $('label[for="direccion"]').text('Dirección *');


                                $('#person-juridica').attr('checked', true)
                                $("#cf1").val(data.cf2);
                                $('#div-cf1').show();
                                $("#cf2").val("");
                                $('#div-cf2').hide();
                                $('#document-type').val(data.document_type_id).trigger('change.select2');
                            }
                            if (data.document_type_id != 6) {
                                $('#document-type').val(data.document_type_id).trigger('change.select2');
                            }
                            var dir = data.direccion;
                            var ruc = data.cf2;
                            if (ruc == null || ruc == "") {
                                mensaje_alerta(lang.verify_ruc);
                                $("#customerModal").modal("show");
                                document.body.scrollTop = document.documentElement.scrollTop = 0;
                            } else if (dir == null || dir == "") {
                                mensaje_alerta(lang.verify_address);
                                $("#customerModal").modal("show");
                                document.body.scrollTop = document.documentElement.scrollTop = 0;
                            } else {



                                if (!get('spoitems') || $("#poTable tbody").text() == "") {

                                    validarFormulario();

                                    if (!validateDocumentType()) {
                                        e.preventDefault();
                                    }

                                    e.preventDefault();
                                    document.getElementById("warning_text").innerHTML = lang.products_not_found;
                                    displayOn('warning');
                                    // $('html,body').animate({ scrollTop: 0 }, 'slow');
                                    document.body.scrollTop = document.documentElement.scrollTop = 0;
                                } else if ($("#gimptotal").val() < 0) {
                                    e.preventDefault();
                                    document.getElementById("warning_text").innerHTML = lang.sale_not_less;
                                    displayOn('warning');
                                    document.body.scrollTop = document.documentElement.scrollTop = 0;
                                } else if ($("#detraction_flag").val() == 1) { //DETRACCION HABILITADA

                                    let camposFaltantes = [];



                                    function validateField(fieldId, fieldName, helpId, isSelect2 = true, additionalClass = "") {
                                        let fieldValue = $(fieldId).val();
                                        let helpElement = $(helpId);
                                        let labelElement = $(`label[for='${fieldId.replace('#', '')}']`); // Asumiendo que los labels tienen el atributo "for" correspondiente al id del campo

                                        if (fieldValue === "" || fieldValue === "0") {
                                            camposFaltantes.push(fieldName);

                                            if (isSelect2) {
                                                $(fieldId).siblings(".select2-container").find(".select2-selection").css("border-color", "#dc3545");
                                            } else {
                                                $(fieldId).addClass(additionalClass);
                                            }

                                            helpElement.css({
                                                display: "block",
                                                color: "#dc3545"
                                            });

                                            labelElement.css({
                                                color: "#dc3545"
                                            });
                                        }
                                    }

                                    // Validate select2 fields
                                    validateField("#tipo_operacion", "Tipo de operación", "#tipo_operacion_help");
                                    validateField("#medio_pago", "Medio de pago", "#medio_pago_help");
                                    validateField("#tipo_detraccion", "Tipo de detracción", "#tipo_detraccion_help");

                                    // Validate embarcacion fields if tipo_operacion is 1002
                                    if ($("#tipo_operacion").val() == 1002) {
                                        validateField("#matricula_embarcacion", "Matrícula de la Embarcación", "#matricula_embarcacion_help", false, "campo-incompleto-input");
                                        validateField("#nombre_embarcacion", "Nombre de la Embarcación", "#nombre_embarcacion_help", false, "campo-incompleto-input");
                                        validateField("#lugar_descarga", "Lugar de Descarga", "#lugar_descarga_help", false, "campo-incompleto-input");
                                        validateField("#cantidad_especie", "Cantidad de la Especie", "#cantidad_especie_help", false, "campo-incompleto-input");
                                        validateField("#descripcion_especie", "Descripción de la Especie", "#descripcion_especie_help", false, "campo-incompleto-input");
                                    }

                                    // Validate fields if tipo_operacion is 1004
                                    if ($("#tipo_operacion").val() == 1004) {
                                        validateField("#direc_origen", "Dirección de Origen", "#direc_origen_help", false, "campo-incompleto-input");

                                        validateField("#depart_origen", "Departamento de Origen", "#depart_origen_help");
                                        validateField("#provin_origen", "Provincia de Origen", "#provin_origen_help");
                                        validateField("#distri_origen", "Distrito de Origen", "#distri_origen_help");

                                        validateField("#direccion_destino", "Dirección del Destino", "#direccion_destino_help", false, "campo-incompleto-input");

                                        validateField("#depart_dest", "Departamento del Destino", "#depart_dest_help");
                                        validateField("#provin_dest", "Provincia del Destino", "#provin_dest_help");
                                        validateField("#distri_dest", "Distrito del Destino", "#distri_dest_help");

                                        validateField("#detalles_viaje", "Detalle del Viaje", "#detalles_viaje_help", false, "campo-incompleto-input");
                                        validateField("#vref_servicio_transporte", "V.Ref. Servicio de Transporte", "#vref_servicio_transporte_help", false, "campo-incompleto-input");
                                        validateField("#vref_carga_efectiva", "V.Ref. Carga Efectiva", "#vref_carga_efectiva_help", false, "campo-incompleto-input");
                                        validateField("#vref_carga_util", "V.Ref. Carga Útil", "#vref_carga_util_help", false, "campo-incompleto-input");
                                    }

                                    if (camposFaltantes.length > 0) {

                                        e.preventDefault();
                                        // let mensaje = "Los siguientes campos están incompletos: " + camposFaltantes.join(", ") + ". Por favor complete los campos faltantes.";
                                        // document.getElementById("warning_text").innerHTML = mensaje;
                                        // displayOn('warning');
                                        // document.body.scrollTop = document.documentElement.scrollTop = 0;

                                        window.scrollTo({
                                            top: 500,
                                            behavior: 'smooth' // Opcional, para un desplazamiento suave
                                        });

                                    } else if ($("#tipo_operacion").val() == 1002) {

                                        if (camposFaltantes.length > 0) {

                                            e.preventDefault();

                                            // Crear el mensaje concatenando los nombres de los campos faltantes
                                            // let mensaje = "Los siguientes campos están incompletos: " + camposFaltantes.join(", ") + ". Por favor complete los campos faltantes.";

                                            // Actualizar el texto de advertencia
                                            // document.getElementById("warning_text").innerHTML = mensaje;

                                            // Mostrar la advertencia
                                            // displayOn('warning');

                                            // Desplazar la página hacia arriba
                                            // document.body.scrollTop = document.documentElement.scrollTop = 0;

                                            window.scrollTo({
                                                top: 500,
                                                behavior: 'smooth' // Opcional, para un desplazamiento suave
                                            });

                                        } else {
                                            displayOff('warning');
                                            $('#add_sale').submit();
                                        }

                                    } else if ($("#tipo_operacion").val() == 1004) {

                                        if (camposFaltantes.length > 0) {

                                            e.preventDefault();
                                            // let mensaje = "Los siguientes campos están incompletos: " + camposFaltantes.join(", ") + ". Por favor complete los campos faltantes.";
                                            // document.getElementById("warning_text").innerHTML = mensaje;
                                            // displayOn('warning');
                                            // document.body.scrollTop = document.documentElement.scrollTop = 0;

                                            window.scrollTo({
                                                top: 500,
                                                behavior: 'smooth' // Opcional, para un desplazamiento suave
                                            });

                                        } else {
                                            displayOff('warning');
                                            $('#add_sale').submit();
                                        }

                                    } else if ($("#tipo_operacion").val() == 1001) {

                                        if ($('#tipo_detraccion').val() == 27) {
                                            e.preventDefault();
                                            document.getElementById("warning_text").innerHTML = "El tipo de detraccion no puede ser '[027] Transporte de carga'.";
                                            displayOn('warning');
                                            document.body.scrollTop = document.documentElement.scrollTop = 0;
                                            $('#tipo_detraccion').val('').trigger('change');


                                        } else if ($('#tipo_detraccion').val() == 28) {
                                            e.preventDefault();
                                            document.getElementById("warning_text").innerHTML = "El tipo de detraccion no puede ser '[028] Servicio de transporte de personas'.";
                                            displayOn('warning');
                                            document.body.scrollTop = document.documentElement.scrollTop = 0;
                                            $('#tipo_detraccion').val('').trigger('change');

                                        } else if ($('#tipo_detraccion').val() == 4) {
                                            e.preventDefault();
                                            document.getElementById("warning_text").innerHTML = "El tipo de detraccion no puede ser '[004] Recursos Hidrobiologicos'.";
                                            displayOn('warning');
                                            document.body.scrollTop = document.documentElement.scrollTop = 0;
                                            $('#tipo_detraccion').val('').trigger('change');

                                        } else {
                                            displayOff('warning');
                                            $('#add_sale').submit();
                                        }


                                    } else {
                                        displayOff('warning');
                                        $('#add_sale').submit();
                                    }

                                    $("#tipo_operacion, #medio_pago, #tipo_detraccion, #depart_origen, #provin_origen, #distri_origen, #depart_dest, #provin_dest, #distri_dest, #detracion_interruptor, #detraction_flag, #account_bank_number, #porcentaje, #valor, #matricula_embarcacion, #nombre_embarcacion, #lugar_descarga, #cantidad_especie, #fecha_descarga, #descripcion_especie, #direc_origen, #direccion_destino, #detalles_viaje, #vref_servicio_transporte, #vref_carga_efectiva, #vref_carga_util").on("change", function () {
                                        let element = $(this);
                                        // resetBorderColor(element);
                                        resetHelpMessage(`#${element.attr('id')}_help`);

                                    });


                                } else {
                                    displayOff('warning');
                                    $('#add_sale').submit();
                                }
                            }



                        }


                    });
                } else if ($('#document_type').val() == 1) {
                    if ($("#gimptotal").val() > 700) {
                        code = $("#customer_id").val();
                        e.preventDefault();
                        $.ajax({
                            type: "get",
                            url: base_url + 'customers/get_customers_byid/' + code,
                            dataType: "json",
                            success: function (data) {
                                // console.log(data)
                                $("#cdireccion").val(data.direccion);
                                $("#reference_address").val( data.reference_address);
                            $("#cf2").val(data.cf2);
                                $("#cf1").val(data.cf1);
                                $("#cphone").val(data.phone);
                                $("#cemail").val(data.email);
                                $("#name").val(data.name);
                                var x = $("#customer_type").val(data.customers_type_id);

                                $('#accion-cliente').val(2);
                                $("#idclienteedit").val(data.id)
                                $("#add_customer").text("Guardar cambios");
                                if (data.person_type == 1) {
                                    $('#nombre-persona').text('Nombre *');
                                    // $('#div-document_type').show();
                                    $('#div-cf1').show();
                                    $('#div-cf2').show();
                                    $('label[for="cf2"]').text('RUC');
                                    $('#name').val(''); 
                                    $('#cdireccion').val('');
                                $('#reference_address').val('');

                                
                                    $('#doctypejs').val('');
                                    $("#document-type option").show();
                                    // Muestra las opciones relevantes según la selección inicial (por defecto, Persona Jurídica)
                                    $("#document-type option[value='6']").hide();
                                    $('label[for="direccion"]').text('Dirección');

                                    $('#person-natural').attr('checked', true)
                                    $('#div-document_type').show();

                                }
                                if (data.person_type == 2 || data.document_type_id == 6) {
                                    $('#nombre-persona').text('Razón social *');
                                    // $('#div-document_type').hide();
                                    // $('#cf1').val('');                    
                                    // Muestra el mensaje para Persona Jurídica
                                    $("#document-type option").hide();
                                    // Muestra las opciones relevantes según la selección inicial (por defecto, Persona Jurídica)
                                    $("#document-type option[value='6']").show();
                                    $('#document-type').val(6).trigger('change.select2');
                                    $('label[for="direccion"]').text('Dirección *');

                                    $('#person-juridica').attr('checked', true)
                                    $("#cf1").val(data.cf2);
                                    $('#div-cf1').show();
                                    $("#cf2").val("");
                                    $('#div-cf2').hide();
                                    $('#document-type').val(data.document_type_id).trigger('change.select2');
                                }
                                if (data.document_type_id != 6) {
                                    $('#document-type').val(data.document_type_id).trigger('change.select2');
                                }
                                var dni = data.cf1;
                                var ruc = data.cf2;
                                if (ruc == null || ruc == "") {
                                    if (dni == null || dni == "" || dni == "--") {
                                        $("#customerModal").modal("show");
                                        mensaje_alerta(lang.verify_dniRuc);
                                        displayOn('warning');
                                        document.body.scrollTop = document.documentElement.scrollTop = 0;
                                    } else {
                                        if (!get('spoitems') || $("#poTable tbody").text() == "") {
                                            e.preventDefault();
                                            document.getElementById("warning_text").innerHTML = lang.products_not_found;
                                            displayOn('warning');
                                            // $('html,body').animate({ scrollTop: 0 }, 'slow');
                                            document.body.scrollTop = document.documentElement.scrollTop = 0;
                                        } else if ($("#gimptotal").val() < 0) {
                                            e.preventDefault();
                                            document.getElementById("warning_text").innerHTML = lang.sale_not_less;
                                            displayOn('warning');
                                            document.body.scrollTop = document.documentElement.scrollTop = 0;
                                        } else {
                                            displayOff('warning');
                                            $('#add_sale').submit();
                                        }
                                    }
                                } else {
                                    if (!get('spoitems') || $("#poTable tbody").text() == "") {
                                        e.preventDefault();
                                        document.getElementById("warning_text").innerHTML = lang.products_not_found;
                                        displayOn('warning');
                                        // $('html,body').animate({ scrollTop: 0 }, 'slow');
                                        document.body.scrollTop = document.documentElement.scrollTop = 0;
                                    } else if ($("#gimptotal").val() < 0) {
                                        e.preventDefault();
                                        document.getElementById("warning_text").innerHTML = lang.sale_not_less;
                                        displayOn('warning');
                                        document.body.scrollTop = document.documentElement.scrollTop = 0;
                                    } else {
                                        displayOff('warning');
                                        $('#add_sale').submit();
                                    }

                                }
                            }
                        });

                    }
                    /*endifvalidar 700*/
                } else if (!get('spoitems') || $("#poTable tbody").text() == "") {
                    e.preventDefault();
                    document.getElementById("warning_text").innerHTML = lang.products_not_found;
                    displayOn('warning');
                    document.body.scrollTop = document.documentElement.scrollTop = 0;
                } else if ($("#gimptotal").val() < 0) {
                    e.preventDefault();
                    document.getElementById("warning_text").innerHTML = lang.sale_not_less;
                    displayOn('warning');
                    document.body.scrollTop = document.documentElement.scrollTop = 0;
                } else {
                    displayOff('warning');
                }


        } else {
            e.preventDefault();
            bootbox.alert("Todos los productos deben tener un precio unitario mayor a 0");
        }



    });


    function displayOn(Element) {
        var x = document.getElementById(Element);
        if (x.style.display == 'none') {
            x.style.display = '';
        }
        setTimeout(function () {
            x.style.display = 'none';
        }, 10000);
    }

    function displayOff(Element) {
        var x = document.getElementById(Element);
        if (x.style.display == '') {
            x.style.display = 'none';
        }
    }


    $('#depart_origen').change(function (e) {
        var departamentOrigen = $(this).val();
        loadProvinceOrigen(departamentOrigen);
    });

    // Event handler for when the origin province changes
    $('#provin_origen').change(function (e) {
        var departamentOrigen = $("#depart_origen").val();
        var provinceOrigen = $(this).val();
        loadDistritoOrigen(departamentOrigen, provinceOrigen);
    });

    $('#depart_dest').change(function (e) {
        var departamentDestino = $(this).val();
        loadProvinceDestino(departamentDestino);
    });

    // Event handler for when the destination province changes
    $('#provin_dest').change(function (e) {
        var departamentDestino = $("#depart_dest").val();
        var provinceDestino = $(this).val();
        loadDistritoDestino(departamentDestino, provinceDestino);
    });

    $('#depart_origen_tramo').change(function (e) {
        var departamentOrigen = $(this).val();
        loadProvinceOrigenTramo(departamentOrigen);
    });

    // Event handler for when the origin province changes
    $('#provin_origen_tramo').change(function (e) {
        var departamentOrigen = $("#depart_origen_tramo").val();
        var provinceOrigen = $(this).val();
        loadDistritoOrigenTramo(departamentOrigen, provinceOrigen);
    });

    $('#depart_destino_tramo').change(function (e) {
        var departamentDestinoTramo = $(this).val();
        loadProvinceDestinoTramo(departamentDestinoTramo);
    });

    // Event handler for when the destination province changes
    $('#provin_destino_tramo').change(function (e) {
        var departamentDestinoTramo = $("#depart_destino_tramo").val();
        var provinceDestinoTramo = $(this).val();
        loadDistritoDestinoTramo(departamentDestinoTramo, provinceDestinoTramo);
    });

    if ($('#document_type').val() != 3) {
        $.ajax({
            type: "GET",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            url: base_url + "general/tipoAfectacionIGV",
            success: function (response) {
                console.log('res:', response);
                tipoAfectacionData = response;
            },
            error: function (xhr, status, error) {
                console.error('Error al obtener los tipos de afectación IGV:', error);
            }
        });
    }



});

function getTotalWithRetention(total) {
    var is_retainer = $('#customer_is_retainer').val();
    var retainer_percentage = $('#customer_retainer_percentage').val();
    if ($('#document_type').val() == '2' && is_retainer === "1") {
        var percentage = retainer_percentage / 100;
        var monto_porcentage = total * percentage;
        total = total - monto_porcentage;
    }
    return total;
}

var tipoAfectacionData = [];
function construirSelectTipoAfectacion() {
    var selectTipoAfectacion = '<select class="form-control" name="metodo_impuesto[]" >';
    $.each(tipoAfectacionData, function (i, item) {
        var indicadorGratuito = '';
        if (item.tipo_afectacion == 4 || item.tipo_afectacion == 5) {
            indicadorGratuito = "[Gratuito]";
        }
        selectTipoAfectacion += '<option value="' + item.id + '" data-tipo-afectacion="' + item.tipo_afectacion + '">' + indicadorGratuito + item.descripcion + '</option>';
    });
    selectTipoAfectacion += '</select>';

    return selectTipoAfectacion;
}

function loadItems() {

    var selectTipoAfectacionHTML = construirSelectTipoAfectacion();

    if (get('spoitems')) {//Verifica si existe el objeto en el localstorage
        var avanzado = ""; //variable para ocultar columnas de la tabla si esta desactivado el modo avanzado
        var normal = ""; //variable para ocultar columnas de la tabla si esta desactivado el modo normal
        if (avdSale == 1) {
            normal = " display: none;";
        } else {
            avanzado = " display: none;";
        }
        //definimos variables de totales
        var total = 0;
        var affected = 0;
        var tax = 0;
        var taxICBPER = 0;
        var exonerated = 0;
        var exoneratedReal = 0;
        var gratuito = 0;

        count = 0;
        countt = 0;

        var discount = parseFloat($("#gdiscount").val()) ? parseFloat($("#gdiscount").val()) : 0;//obtener el descuento global
        var total_payable = parseFloat($("#gtotal").val());

        $("#poTable tbody").empty();// limpiamos el tbody de la tabla

        spoitems = JSON.parse(get('spoitems'));//obtenemos los items del localstorage

        $.each(spoitems, function (item_id, item) {//recorremos los items

            spoitems[item_id] = item;//asignamos el item al objeto

            var product_id = item.row.productID ?? "undefined";
            var item_currency = item.row.currency;
            var item_price = item.row.price;
            var item_qty = item.row.qty;
            var item_code = item.row.code;
            var item_tax_method = item.row.tax_method;
            var item_tax_ICBPER = item.tax_ICBPER;
            var item_name = item.row.name.replace(/"/g, "&#034;").replace(/'/g, "&#039;");//Escapar comillas simples y dobles
            var tipo_afectacion = item.row.tipo_afectacion;
            item_name = item_name.replace("<", "&lt;");
            item_name = item_name.replace(">", "&gt;");

            var real_unit_price = item.row.real_unit_price;

            if (item.row.edit != 1) {
                if (item_price > 0 && item_currency != $("#currency_code").val()) {
                    if (item_currency == "PEN") {
                        item_price = parseFloat(item_price / $("#exchange").val()).toFixed(2);
                        spoitems[item_id].row.price = item_price;
                    }
                    if (item_currency == "USD") {
                        item_price = parseFloat(item_price * $("#exchange").val()).toFixed(2);
                        spoitems[item_id].row.price = item_price;
                    }
                }
            }

            var precioSinIGVUnitario = 0;
            var igvUnitario = 0;
            var item_exon = 0;
            var free_items = 0;
            var affect_price = 0;
            var non_affected_price = 0;
            var exonerated_price = 0;
            var free_price = 0;
            var gratuito_price = 0;
            var bool_exonerado = false;
            var bool_afecto = false;
            var bool_exoneradoReal = false
            var bool_gratuito = false;
            var row_no = (new Date).getTime();
            if ($('#document_type').val() != 3) {
                if (tipo_afectacion == 0) { //Incluido

                    item_exon = 0;
                    bool_afecto = true;
                    if (item.affect_priceJs == null) {
                        affect_price = item_price;//guardamos el precio unitario como precio afecto incluido igv 
                        precioSinIGVUnitario = (parseFloat(affect_price) / (1 + (parseFloat(Settings.default_tax_rate) / 100))).toFixed(5);//quitamos el igv
                        igvUnitario = (parseFloat(affect_price) - precioSinIGVUnitario).toFixed(5);//calculamos el igv
                    }

                } else if (tipo_afectacion == 1) { //Excluido
                    if (item.row.edit != 1) {
                        item_price = parseFloat(parseFloat(item_price) * (1 + (parseFloat(Settings.default_tax_rate) / 100))).toFixed(2);
                        spoitems[item_id].row.price = item_price;
                    }

                    item_exon = 0;
                    bool_afecto = true;

                    if (item.affect_priceJs == null) {
                        affect_price = item_price;
                        precioSinIGVUnitario = parseFloat(item_price) / (1 + (parseFloat(Settings.default_tax_rate) / 100));
                        igvUnitario = parseFloat(item_price) - precioSinIGVUnitario;
                    }

                } else if (tipo_afectacion == 2) { //Inafecto
                    item_exon = parseFloat(item_price);

                    bool_exonerado = true;
                    if (item.non_affected_priceJs == null) {
                        non_affected_price = item_price;
                    }

                } else if (tipo_afectacion == 3) { //Exonerado
                    item_exon = parseFloat(item_price);
                    bool_exoneradoReal = true;
                    if (item.exonerated_priceJs == null) {
                        exonerated_price = item_price;
                    }
                } else if (tipo_afectacion == 4 || tipo_afectacion == 5) { //Gratuito con afecto al igv
                    item_gratuito = parseFloat(item_price);
                    bool_gratuito = true;
                    gratuito_price = item_price;
                }
            } else {
                item_exon = parseFloat(item_price);
                igvUnitario = 0;
                bool_exonerado = true;

                if (item.non_affected_priceJs == null) {
                    non_affected_price = item_price;
                }
                affect_price = 0;
                precioSinIGVUnitario = 0;
                exonerated_price = 0;

            }
            spoitems[item_id].row.edit = 1;
            store('spoitems', JSON.stringify(spoitems));

            //total += (parseFloat(item_price) * parseFloat(item_qty));
            total += (parseFloat((parseFloat(affect_price) + parseFloat(non_affected_price) + parseFloat(exonerated_price))) * parseFloat(item_qty));
            var igv_desc = 0,
                gvd_desc = 0,
                porcentaje = 0,
                prr_discount = 0
            subtotal = (parseFloat(item_price) * parseFloat(item_qty));
            if (discount > 0) {

                if ($('#document_type').val() != 3) {

                    porcentaje = (parseFloat(subtotal) / parseFloat(total_payable));
                    prr_discount = parseFloat(discount) * parseFloat(porcentaje);

                    if (bool_afecto) {
                        gvd_desc = (parseFloat(prr_discount) / (1 + ((parseFloat(Settings.default_tax_rate) / 100))));
                        igv_desc = prr_discount - gvd_desc;
                    }

                } else {
                    gvd_desc = parseFloat(discount);
                    prr_discount = 0;
                    igv_desc = 0;
                }

            } else {
                gvd_desc = 0;
                prr_discount = 0;
                igv_desc = 0;
            }


            affected += (parseFloat(precioSinIGVUnitario) * parseFloat(item_qty)); //precio
            tax += ((parseFloat(igvUnitario) * parseFloat(item_qty))); //- parseFloat(igv_desc));

            if (parseFloat(non_affected_price) > 0) {
                exonerated += (parseFloat(non_affected_price) * parseFloat(item_qty)); // - parseFloat(prr_discount));
            } else {
                exonerated += ((parseFloat(non_affected_price) * parseFloat(item_qty)));
            }

            if (parseFloat(exonerated_price) > 0) {
                exoneratedReal += (parseFloat(exonerated_price) * parseFloat(item_qty)); //- parseFloat(prr_discount));
            } else {
                exoneratedReal += ((parseFloat(exonerated_price) * parseFloat(item_qty)));
            }
            if (parseFloat(gratuito_price) > 0) {
                gratuito += (parseFloat(gratuito_price) * parseFloat(item_qty));
            } else {
                gratuito += (parseFloat(gratuito_price) * parseFloat(item_qty));
            }

            // var selectTipoAfectacion = '';
            // if ($('#document_type').val() != 3) {


            //     $.ajax({
            //         type: "GET",
            //         contentType: "application/json; charset=utf-8",
            //         dataType: "json",
            //         url: base_url + "general/tipoAfectacionIGV",
            //         async: false,
            //         success: function (response) {
            //             console.log('res:', response);
            //             selectTipoAfectacion += '<select class="form-control" name="metodo_impuesto[]" >';
            //             $.each(response, function (i, item) {
            //                 var indicadorGratuito = '';
            //                 if (item.tipo_afectacion == 4 || item.tipo_afectacion == 5) {
            //                     indicadorGratuito = "[Gratuito]";
            //                 }
            //                 selectTipoAfectacion += '<option value="' + item.id + '" data-tipo-afectacion="' + item.tipo_afectacion + '">' + indicadorGratuito + item.descripcion + '</option>';
            //             });
            //             selectTipoAfectacion += '</select>';
            //         }
            //     });
            // }
            //creamos una nueva fila para el para la tabla
            var newTr = $('<tr id="' + row_no + '" class="' + item_id + '" data-item-id="' + item_id + '"></tr>');
            //añadimos la columna nombre a la fila
            let CeldaProducto = $('<td style="min-width:100px;"></td>');//celda que contiene la informacion del producto
            //Creamos el input de tipo hidden para guardar el id del producto y agregamos a la celda
            let productoIdInputHidden = $('<input name="product_id[]" type="hidden" class="rid">').val(product_id);
            CeldaProducto.append(productoIdInputHidden);
            //Creamos el input de tipo hidden para alamacenar el metodo de impuesto y agregamos a la celda
            let metodoImpuestoIputHidden = $('<input name="tax_method[]" type="hidden" class="rid"  id="tax_method_' + row_no + '">').val(item_tax_method);
            CeldaProducto.append(metodoImpuestoIputHidden);
            //Creamos el input de tipo hidden para almacenar el precio unitario y agregamos a la celda
            let precioRealUnitarioInputText = $('<input name="real_unit_price[]" type="hidden" class="rid" >').val(real_unit_price);
            CeldaProducto.append(precioRealUnitarioInputText);
            //Creamos el input de tipo hidden para alamacenar el codigo de moneda y agregamos a la celda
            let monedaInputHidden = $('<input name="currency_cost[]" type="hidden" class="rid">').val(item_currency);
            CeldaProducto.append(monedaInputHidden);
            //Creamos el input de tipo hidden para almacenar el costo y agregamos a la celda
            let costoInputHidden = $('<input name="cost[]" type="hidden" class="rid">').val(item.row.cost);
            CeldaProducto.append(costoInputHidden);
            //Creamos el imput de tipo hidden para alamacenar el nombre del producto y agregamos a la celda
            let nombreImputhidden = $('<input name="name[]" type="hidden" class="rid">').val(item_name);
            CeldaProducto.append(nombreImputhidden);
            //Creamos el input de tipo hidden para almacenar el codigo del producto y agregamos a la celda
            let codigoInputHidden = $('<input name="code[]" type="hidden" class="rid">').val(item_code);
            CeldaProducto.append(codigoInputHidden);
            //creamos un input de tipo hidden para alamacenar el tipo de afectacion y agregamos a la celda
            let tipoAfectacionInputHidden = $('<input name="tipo_afectacion[]" type="hidden" class="rid" id="tipo_afectacion_' + row_no + '">').val(tipo_afectacion);
            //agregamos el input a la celda
            CeldaProducto.append(tipoAfectacionInputHidden);
            //creamos un span para mostrar el nombre del producto y agregamos a la celda
            let descripcionSpan = $('<span class="sname" id="name_' + row_no + '"> </span>').text(item_name + ' (' + item_code + ')');
            CeldaProducto.append(descripcionSpan);
            //agregamos la celda a la fila
            newTr.append(CeldaProducto);

            if ($('#document_type').val() != 3) {
                //creamos una nueva celda para el select de methodos de impuestos
                let CeldaMetodoImpuesto = $('<td style="min-width:100px;"></td>');
                //Creamos el select de los metodos de impuestos
                let metodoImpuestoSelect = $(selectTipoAfectacionHTML);
                //agregamos valor al select
                metodoImpuestoSelect.val(item_tax_method);
                //añadimos el evento change=>cambio
                metodoImpuestoSelect.on('change', function () {
                    tipoAfectacion = $(this).find('option:selected').data('tipo-afectacion');
                    modif_tax_met(item_id, $(this).val(), tipoAfectacion)
                });
                //agregamos el select a la celda
                CeldaMetodoImpuesto.append(metodoImpuestoSelect);
                //agregamos la celda a la fila
                newTr.append(CeldaMetodoImpuesto);
            } else {
                let CeldaMetodoImpuesto = $('<td style="min-width:100px;"></td>');
                let MetodoImpuestoSpan = $('<span class="tipoAfectacionSpan" ></span>').text('No aplica');
                CeldaMetodoImpuesto.append(MetodoImpuestoSpan);
                //agregamos la celda a la fila
                newTr.append(CeldaMetodoImpuesto);
            }
            //creamos una nueva celda para el input de cantidad
            let CeldaCantidad = $('<td style="padding:2px; min-width:80px;"></td>');
            //Creamos el input de de tipo text para la cantidad 
            let cantidadInputText = $('<input class="form-control input-sm kb-pad text-center rquantity" name="quantity[]" type="text"  data-id="' + row_no + '" data-item="' + item_id + '" id="quantity_' + row_no + '" >').val(item_qty);
            //agregamos el input a la celda
            CeldaCantidad.append(cantidadInputText);
            //agregamos la celda a la fila
            newTr.append(CeldaCantidad);
            //creamos una nueva celda para el input de precio unitario
            let CeldaPrecioUnitario = $('<td style="padding:2px; min-width:80px;"></td>');
            //Creamos el input de de tipo text para el precio unitario
            let precioUnitarioInputText = $('<input class="form-control input-sm kb-pad text-center rprice" name="price[]" type="text"  data-id="' + row_no + '" data-item="' + item_id + '" id="price_' + row_no + '" onClick="this.select();">').val(item_price);
            //agregamos el input a la celda
            CeldaPrecioUnitario.append(precioUnitarioInputText);
            //agregamos la celda a la fila
            newTr.append(CeldaPrecioUnitario);
            //creamos nueva celda para el input de precio afectado
            let CeldaPrecioAfectado = $('<td style="padding:2px; min-width:80px;' + avanzado + '"></td>');
            //Creamos el input de de tipo text para el precio afectado <input class="form-control input-sm kb-pad text-center rPAffect" name="affect_price[]" type="text" value="' + affect_price + '" data-id="' + row_no + '" data-item="' + item_id + '" id="price_' + row_no + '" onClick="this.select();">
            let precioAfectadoInputText = $('<input class="form-control input-sm kb-pad text-center rPAffect" name="affect_price[]" type="text"  data-id="' + row_no + '" data-item="' + item_id + '" id="price_' + row_no + '" onClick="this.select();">').val(affect_price);
            //agregamos el input a la celda
            CeldaPrecioAfectado.append(precioAfectadoInputText);
            //agregamos la celda a la fila
            newTr.append(CeldaPrecioAfectado);
            //creamos nueva celda para el input de precio inafectado
            let CeldaPrecioInafectado = $('<td style="padding:2px; min-width:80px;' + avanzado + '"></td>');
            //Creamos el input de de tipo text para el precio inafectado 
            let precioInafectadoInputText = $('<input class="form-control input-sm kb-pad text-center rPNonAffected" name="non_affected_price[]" type="text"  data-id="' + row_no + '" data-item="' + item_id + '" id="price_' + row_no + '" onClick="this.select();">').val(non_affected_price);
            //agregamos el input a la celda
            CeldaPrecioInafectado.append(precioInafectadoInputText);
            //agregamos la celda a la fila
            newTr.append(CeldaPrecioInafectado);
            //creamos nueva celda para el input de precio exonerado
            let CeldaPrecioExonerado = $('<td style="padding:2px; min-width:80px;' + avanzado + '"></td>');
            //Creamos el input de de tipo text para el precio exonerado <input class="form-control input-sm kb-pad text-center rPExonerated" name="exonerated_price[]" type="text" value="' + exonerated_price + '" data-id="' + row_no + '" data-item="' + item_id + '" id="price_' + row_no + '" onClick="this.select();">
            let precioExoneradoInputText = $('<input class="form-control input-sm kb-pad text-center rPExonerated" name="exonerated_price[]" type="text"  data-id="' + row_no + '" data-item="' + item_id + '" id="price_' + row_no + '" onClick="this.select();">').val(exonerated_price);
            //agregamos el input a la celda
            CeldaPrecioExonerado.append(precioExoneradoInputText);
            //agregamos la celda a la fila
            newTr.append(CeldaPrecioExonerado);
            //creamos nueva celda para el input de precio gratuito
            let CeldaPrecioGratuito = $('<td style="padding:2px; min-width:80px;' + avanzado + '"></td>');
            //Creamos el input de de tipo text para el precio gratuito <input class="form-control input-sm kb-pad text-center rPGratuito" name="gratuito_price[]" type="text" value="' + gratuito_price + '" data-id="' + row_no + '" data-item="' + item_id + '" id="price_' + row_no + '" onClick="this.select();">
            let precioGratuitoInputText = $('<input class="form-control input-sm kb-pad text-center rPGratuito" name="gratuito_price[]" type="text"  data-id="' + row_no + '" data-item="' + item_id + '" id="price_' + row_no + '" onClick="this.select();">').val(gratuito_price);
            //agregamos el input a la celda
            CeldaPrecioGratuito.append(precioGratuitoInputText);
            //agregamos la celda a la fila
            newTr.append(CeldaPrecioGratuito);
            //creamos nueva celda para el input de precio total

            var importe = 0;
            importe = parseFloat(affect_price) + parseFloat(non_affected_price) + parseFloat(exonerated_price) + parseFloat(gratuito_price);
            //tr_html += '<td class="text-right"><span class="text-right ssubtotal" id="subtotal_' + row_no + '">' + formatMoney(parseFloat(item_price) * parseFloat(item_qty)) + '</span></td>';
            //***********TRJ068 - ALEXADER ROCA - 02/08/2019************

            var subTotal_ICBPER = 0;
            var check_ICBPER = '',
                input_text_ICBPER = '0';

            if (plastic_bags > 0) {
                ocultar_ICBPER = '';

                if (item_tax_ICBPER == 0) {
                    check_ICBPER = '';
                    input_text_ICBPER = '0';
                    subTotal_ICBPER = 0;
                } else {
                    check_ICBPER = 'checked';
                    input_text_ICBPER = '1';
                    subTotal_ICBPER = (plastic_bags * Math.round(parseFloat(item_qty)));
                    taxICBPER += (0.10 * Math.round(parseFloat(item_qty)));
                }

            } else {
                ocultar_ICBPER = ' display:none; ';
            }

            //creamos una nueva celda para el input de impuesto ICBPER
            let CeldaImpuestoICBPER = $('<td class="text-center" style="padding:1px; ' + ocultar_ICBPER + '" data-ul=' + row_no + '></td>');
            //Creamos el input de de tipo text para el impuesto ICBPER
            let impuestoICBPERInputText = $('<input onclick="chececkTaxBP();" class="" name="tax_ICBPER[]" type="checkbox" data-id="' + row_no + '" data-item="' + item_id + '" id="tax_ICBPER_' + row_no + '" ' + check_ICBPER + '>').val(item_qty);
            //agregamos el input a la celda
            CeldaImpuestoICBPER.append(impuestoICBPERInputText);
            //creamos un input de tipo hidden para el valor del impuesto ICBPER
            let impuestoICBPERInputHidden = $('<input  class="" name="value_ICBPER[]" type="hidden" id="value_ICBPER_' + row_no + '">').val(input_text_ICBPER);
            //agregamos el input a la celda
            CeldaImpuestoICBPER.append(impuestoICBPERInputHidden);
            //agregamos la celda a la fila
            newTr.append(CeldaImpuestoICBPER);
            //creamos nueva celda para el input de precio total
            let CeldaPrecioTotal = $(' <td class="text-right"></td>');
            //creamos el span para el precio total
            let precioTotalSpan = $('<span class="text-right ssubtotal" id="subtotal_' + row_no + '">').text(formatMoney((parseFloat(importe) * parseFloat(item_qty)) + subTotal_ICBPER));
            //agregamos el span a la celda
            CeldaPrecioTotal.append(precioTotalSpan);
            //agregamos la celda a la fila
            newTr.append(CeldaPrecioTotal);
            //creamos nueva celda para el boton de eliminar
            let CeldaEliminar = $('<td class="text-center"></td>');
            //creamos el boton de eliminar
            let eliminarButton = $('<i class="fa fa-trash-o tip pointer spodel" id="' + row_no + '" onclick="javascript:delete_order_item(' + item_id + ')" title="Remove"></i>');
            //agregamos el boton a la celda
            CeldaEliminar.append(eliminarButton);
            //agregamos la celda a la fila
            newTr.append(CeldaEliminar);
            //agregamos la fila a la tabla
            $("#poTable tbody").append(newTr);

            count = count + 1;
            countt += parseFloat(item_qty);

        });

        // $("#gdiscount").val(formatMoney(discount));

        item_count = count + ' (' + formatMoney(countt) + ')'
        $("#tart").text(item_count);

        importe_total = affected + exonerated + tax + exoneratedReal + taxICBPER - discount; //***********TRJ068 - ALEXADER ROCA - 02/08/2019************



        grand_affected = parseFloat(affected).toFixed(3);
        grand_tax = formatMoney(tax);

        if (discount > 0) {
            if (affected < discount) {
                alert('El descuento global debe ser menor al importe gravado (productos con impuesto).');
                $('#gdiscount').val(formatMoney(0));
                loadItems();
            } else {
                grand_affected = parseFloat((affected - parseFloat(discount))).toFixed(3);
                grand_tax = grand_affected * ((parseFloat(Settings.default_tax_rate) / 100));

                importe_total = parseFloat(parseFloat(grand_affected) + parseFloat(grand_tax) + parseFloat(exonerated) + parseFloat(exoneratedReal) + (taxICBPER));
                total = affected + tax + exonerated + exoneratedReal + taxICBPER;
                tax = grand_tax;
            }

        }
        $("#gaffected").text(formatMoney(grand_affected));
        $("#opgra").val(affected);


        $("#gtax").text(formatMoney(grand_tax));
        $("#imigv").val(tax);
        grand_taxICBPER = formatMoney(taxICBPER);
        $("#gtaxICBPER").text(grand_taxICBPER);
        grand_exonerated = formatMoney(exonerated);
        $("#gexonerated").text(grand_exonerated);
        $("#opexo").val(exonerated);

        grand_exonerated = formatMoney(exoneratedReal);
        $("#gexoneratedReal").text(grand_exonerated);
        $("#opexoReal").val(exoneratedReal);

        grand_gratuito = formatMoney(gratuito);
        $("#ggratuita").text(grand_gratuito);
        $("#opegratuita").val(gratuito);
        imp_total = formatMoney(importe_total);
        $("#gimptotal").text(imp_total);
        $("#gimptotal").val(importe_total);
        grand_total = formatMoney(total + taxICBPER);
        if (discount > 0) {

            $("#gtot").text(formatMoney(importe_total));
        } else {

            $("#gtot").text(formatMoney((total + taxICBPER) - discount));
        }
        $("#gtotal").val(total);

        // $("#total_pay").val(total - discount);
        $("#total_pay").val(total);

        // <!--********START TRJ143 - DANIEL PADILLA - 23/12/2022*****************-->

        //var customer_selected = $("#customer").find(':selected');
        $("#lbl_retainer_total").html("-");
        $("#retainer_total").val("-");
        //if (customer_selected) {
        //var retainer_percentage = customer_selected.attr('data-retainerpercentage')
        var retainer_percentage = $("#customer_retainer_percentage").val() ? $("#customer_retainer_percentage").val() : false;
        var typeOfCurrency = getTypeOfCurrency($("#currency_code").val());
        var percentage = retainer_percentage / 100;
        var monto_porcentage = parseFloat(total * percentage).toFixed(2);

        if ($("#detraction_flag").val() == 1) {
            
            $("#lbl_retainer_total").html('S/0.00');

        }else{

            $("#lbl_retainer_total").html(typeOfCurrency + monto_porcentage);

        }



        // $("#lbl_retainer_total").html(typeOfCurrency + monto_porcentage);
        
        
        $("#retainer_total").val(monto_porcentage);

        //}

        // <!--********END TRJ143 - DANIEL PADILLA - 23/12/2022*****************-->


        $("#gtotal").text(formatMoney(parseFloat(total + taxICBPER) + parseFloat(gratuito)));
        if (affected == 0 && discount > 0) {
            alert('Descuento global solo aplica para operaciones gravadas.');
            $('#gdiscount').val(formatMoney(0));
            loadItems();
        }
        //$('#add_item').focus();
    }
}

function add_order_item(item) {//funcion para añadir un producto al objeto del localstorage
    var item_id = Settings.item_addition == 1 ? item.item_id : item.id;



    if (spoitems[item_id]) {
        spoitems[item_id].row.qty = parseFloat(spoitems[item_id].row.qty) + 1;
    } else {
        spoitems[item_id] = item;
        if (item.row.tax_method == 0 || item.row.tax_method == 1) {//afecto al igv=incluido y excluido
            spoitems[item_id].row.tipo_afectacion = item.row.tax_method;
            spoitems[item_id].row.tax_method = 1;
        } else if (item.row.tax_method == 2) {//inafecto
            spoitems[item_id].row.tipo_afectacion = item.row.tax_method;
            spoitems[item_id].row.tax_method = 11;
        }
        else if (item.row.tax_method == 3) {//exonerado
            spoitems[item_id].row.tipo_afectacion = item.row.tax_method;
            spoitems[item_id].row.tax_method = 9;
        }
        else if (item.row.tax_method == 4) {//gratuito con afecto
            spoitems[item_id].row.tipo_afectacion = item.row.tax_method;
            spoitems[item_id].row.tax_method = 1;
        }
        else if (item.row.tax_method == 5) {//gratuito con inafecto
            spoitems[item_id].row.tipo_afectacion = item.row.tax_method;
            spoitems[item_id].row.tax_method = 10;
        }
    }

    spoitems[item_id].row.real_unit_price = spoitems[item_id].row.price;


    store('spoitems', JSON.stringify(spoitems));
    loadItems();
    return true;
}

function delete_order_item(itemb) {
    console.log(spoitems, itemb);
    console.log(spoitems[itemb]);
    delete spoitems[itemb];
    console.log(spoitems[itemb]);
    store('spoitems', JSON.stringify(spoitems));
    loadItems();
}


function modif_tax_met(item_id, metodoImpuesto, tipo_afectacion) {
    spoitems[item_id].row.tax_method = metodoImpuesto;
    spoitems[item_id].row.tipo_afectacion = tipo_afectacion;
    spoitems[item_id].row.edit = 1;
    store('spoitems', JSON.stringify(spoitems));
    loadItems();
}

function chececkTaxBP() {

    $('body').on('click', 'td', function () {
        //$( this ).attr( 'checked', true);
        //this.checked = true;
        //alert("click");
        var row = $(this).closest('tr');
        var item_id = row.attr('data-item-id');
        producto = $(this).attr('data-ul');

        var idBoton = "tax_ICBPER_" + producto;

        document.getElementById(idBoton).checked = true;

        if (spoitems[item_id].tax_ICBPER == 0) {
            spoitems[item_id].tax_ICBPER = 1;
            alert("Se va realizar el cobro del impuesto a las bolsas por la cantidad de productos de este Item (cantidad redondeada, si la cantidad es menor a 0.5 el monto del impuesto a las bolsas de este item sera 0)");
            //break;
        } else {
            spoitems[item_id].tax_ICBPER = 0;
            //alert("desactivado");
            //break;
        }
        spoitems[item_id].edit = 1;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();


    });

}
// <!--********START TRJ143 - DANIEL PADILLA - 23/12/2022*****************-->
function checkIfIsRetainer(customerIsRetainer, customerRetainerPercentage) {
    // var is_retainer = $("#customer_is_retainer").val() ? $("#customer_is_retainer").val() : false;
    //console.log('check '+customerIsRetainer+' - '+customerRetainerPercentage);
    if ($('#document_type').val() == 2 && customerIsRetainer == 1) { // Si documento es factura y es cliente retenedor
        $("#lbl_retainer_percentage").html(customerRetainerPercentage + "%");
        $("#retainer_percentage").val(customerRetainerPercentage);
        // }

        loadItems();

        return {
            customerIsRetainer: customerIsRetainer,
            customerRetainerPercentage: customerRetainerPercentage
        }
    }
    else if (typeof customerIsRetainer === 'undefined') {
        //$("#customer").val('');
    }
}


function showHideRetainer(customerIsRetainer, customerRetainerPercentage) {
    $("#customer-retainer").hide(600);
    $("#retainer_percentage").val("0.00");

    var retencion_flag = document.getElementById('retencion_flag').value;



    $("#lbl_retainer_percentage").html("-");
    var customer_retainer = checkIfIsRetainer(customerIsRetainer, customerRetainerPercentage);//console.log('show')  //console.log(customer_retainer);



    if (customer_retainer) {

        // console.log("sdsd", retencion_flag);
        if (retencion_flag == 1) {
            $("#customer-retainer").show(600);

        }

    }


    var originalColor = $("#customer-retainer").css('color');
    var $label = $("#info-retencion-label");


    $('#detracion_interruptor').change(function () {
        if ($(this).prop('checked')) {
            if (customer_retainer) {
                $("#customer-retainer").css('color', 'darkgray');  // Change text color to dark gray
                if (!$('#detraccion-text').length) {
                    $label.append(' <span id="detraccion-text"> - Si la detracción está habilitada, entonces no se aplica la retención.</span>');  // Add text next to the label
                }
            }
        } else {
            if (customer_retainer) {
                $("#customer-retainer").css('color', originalColor);  // Reset text color to original
                $("#detraccion-text").remove();  // Remove additional text
            }
        }
    });

    // Initial check based on #detraction_flag value
    if ($("#detraction_flag").val() == 1) {
        if (customer_retainer) {
            $("#customer-retainer").css('color', 'darkgray');  // Change text color to dark gray
            if (!$('#detraccion-text').length) {
                $label.append(' <span id="detraccion-text"> - Si la detracción está habilitada, entonces no se aplica la retención.</span>');  // Add text next to the label
            }
        }
    } else {
        if (customer_retainer) {
            $("#customer-retainer").css('color', originalColor);  // Reset text color to original
            $("#detraccion-text").remove();  // Remove additional text
        }
    }

    $('#document_type').change(function () {

        var selectedValue = $(this).val();
        var detvalue = $("#detraction_flag").val();

        // console.log("Docvalue", selectedValue);
        // console.log("det flag value: ", detvalue);



        if (selectedValue !== '2') {
            if (customer_retainer) {


                $("#customer-retainer").css('color', originalColor);  // Restablecer el color del texto al original
                $("#detraccion-text").remove();  // Eliminar el texto adicional
                // console.log('Dentro de condicional');

                if ($("#detraccion-text").length) {  // Verificar si el elemento existe
                    $("#detraccion-text").remove();  // Eliminar el texto adicional
                    // console.log('Eliminando el texto de detracción');
                }

            }
        }


    });


}


// function valoresParaOperacionRetainer(customerIsRetainer,customerRetainerPercentage){
//     return {
//         customerIsRetainer: customerIsRetainer,
//         customerRetainerPercentage: customerRetainerPercentage
//     }
// }

// function getTotalWithRetention(total) {
//     //var customer_selected = $("#customer").find(':selected');
//     //var is_retainer = customer_selected.attr('data-isretainer')
//     // var is_retainer = $("#customer_is_retainer").val() ? $("#customer_is_retainer").val() : false;
//     //var retainer_percentage = customer_selected.attr('data-retainerpercentage')
//     // var retainer_percentage = $("#customer_retainer_percentage").val() ? $("#customer_retainer_percentage").val() : false;
//     var customerIsRetainer = parseFloat(valorCustomerIsRetainer);
//     var customerRetainerPercentage = parseFloat(valorCustomerRetainerPercentage);

//     console.log('getTotal ' + customerIsRetainer + ' - ' + customerRetainerPercentage);
//     if ($('#document_type').val() == '2' && customerIsRetainer === 1) {
//         var percentage = customerRetainerPercentage / 100;
//         var monto_porcentage = total * percentage
//         total = total - monto_porcentage
//     }
//     return total;
// }

function getTypeOfCurrency(typeOfCurrency) {
    if (typeOfCurrency == "PEN") return "S/"
    else if (typeOfCurrency == "USD") return "$"
}

// <!--********END TRJ143 - DANIEL PADILLA - 23/12/2022*****************-->

// Función para cargar provincias basado en el departamento seleccionado

function loadProvinceOrigen(departamentOrigen) {
    $.ajax({
        type: "get",
        url: base_url + 'sales/search_provincia/' + departamentOrigen,
        dataType: "json",
        success: function (response) {

            if (departamentOrigen == "0" || departamentOrigen == "" || departamentOrigen == null) {

                $('#provin_origen').prop('disabled', true).val('0').trigger('change');
                $('#distri_origen').prop('disabled', true).val('0').trigger('change');


            } else if (response && response.data) {

                $("#provin_origen").prop('disabled', false);
                $("#distri_origen").prop('disabled', true);

                $('#provin_origen').val('0').trigger('change');
                $('#distri_origen').val('0').trigger('change');

                $('#provin_origen').empty().append('<option value="0">Seleccionar</option>');
                $('#distri_origen').empty().append('<option value="0">Seleccionar</option>');
                $.each(response.data, function (key, registro) {
                    $("#provin_origen").append('<option value="' + registro.codProv + '">' + registro.provincia + '</option>');
                });
            }

        },
    });
}

function loadDistritoOrigen(departamentOrigen, provinceOrigen) {
    $.ajax({
        type: "get",
        url: base_url + 'sales/search_Distrito/' + provinceOrigen + '/' + departamentOrigen,
        dataType: "json",
        success: function (response) {

            if (provinceOrigen == "0" || provinceOrigen == "" || provinceOrigen == null) {

                $('#distri_origen').prop('disabled', true).val('0').trigger('change');

            } else if (response && response.data) {

                $("#distri_origen").prop('disabled', false);

                $('#distri_origen').val('0').trigger('change');

                $('#distri_origen').empty().append('<option value="0">Seleccionar</option>');
                $.each(response.data, function (key, registro) {
                    $("#distri_origen").append('<option value="' + registro.ubigeo + '">' + registro.distrito + '</option>');
                });

            }
        },
    });
}

function loadProvinceDestino(departamentDestino) {
    $.ajax({
        type: "get",
        url: base_url + 'sales/search_provincia/' + departamentDestino,
        dataType: "json",
        success: function (response) {
            if (departamentDestino == "0" || departamentDestino == "" || departamentDestino == null) {

                $('#provin_dest').prop('disabled', true).val('0').trigger('change');
                $('#distri_dest').prop('disabled', true).val('0').trigger('change');

            } else if (response && response.data) {

                $("#provin_dest").prop('disabled', false);
                $("#distri_dest").prop('disabled', true);

                $('#provin_dest').val('0').trigger('change');
                $('#distri_dest').val('0').trigger('change');

                $('#provin_dest').empty().append('<option value="0">Seleccionar</option>');  // Cambio aquí
                $('#distri_dest').empty().append('<option value="0">Seleccionar</option>');  // Cambio aquí
                $.each(response.data, function (key, registro) {
                    $("#provin_dest").append('<option value="' + registro.codProv + '">' + registro.provincia + '</option>');
                });
            }
        },
    });
}

function loadDistritoDestino(departamentDestino, provinceDestino) {
    $.ajax({
        type: "get",
        url: base_url + 'sales/search_Distrito/' + provinceDestino + '/' + departamentDestino,
        dataType: "json",
        success: function (response) {

            if (provinceDestino == "0" || provinceDestino == "" || provinceDestino == null) {

                $('#distri_dest').prop('disabled', true).val('0').trigger('change');

            } else if (response && response.data) {
                $("#distri_dest").prop('disabled', false);

                $('#distri_dest').val('0').trigger('change');

                $('#distri_dest').empty().append('<option value="0">Seleccionar</option>');  // Cambio aquí
                $.each(response.data, function (key, registro) {
                    $("#distri_dest").append('<option value="' + registro.ubigeo + '">' + registro.distrito + '</option>');
                });
            }
        },
    });
}
