<?php (defined('BASEPATH')) or exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title><?= $page_title . ' | ' . $Settings->site_name; ?></title>
    <link rel="shortcut icon" href="<?= $assets ?>img/iconoFSFT.png" />
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/font-awesome/css/font-awesome.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/iCheck/square/yellow.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/select2/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/bootstrap-datetimepicker/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/redactor/redactor.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/jquery-ui.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/custom.css" rel="stylesheet" type="text/css" />

    <script src="<?= $assets ?>plugins/jQuery/jQuery-2.1.4.min.js" type="text/javascript"></script>
    <style>
        /**************Navbar******************** */
        .navbar-custom-menu li a,
        .logo-lg {
            color: white;
        }

        .logo-lg {
            font-weight: bolder;
        }

        .logo-lg img {
            padding-right: 30px;
        }

        .nav>li>a:hover,
        .nav>li>a:active,
        .nav>li>a:focus,
        .navbar-static-top .sidebar-toggle:hover {
            color: #ffffff;
            background: #1b609c;
        }

        .sidebar-menu li a {
            color: #004785;
            border-bottom: 2px solid #d4d6db;
        }

        .main-header .sidebar-toggle {
            color: white;
            font-size: 20px;
            float: left;
            background-color: transparent;
            background-image: none;
            padding: 9px 9px;
            font-family: fontAwesome;
        }

        @media (max-width: 991px) {

            .main-header .navbar-custom-menu a,
            .main-header .navbar-right a {
                color: #ffffff;
                background: transparent;
            }
        }

        .user-footer a {
            color: black;
        }

        @media (max-width: 767px) {
            .main-header .logo {
                display: none;
            }
        }

        .navbar-nav>.user-menu>.dropdown-menu>li.user-header>p {
            z-index: 5;
            color: #666;
            font-size: 17px;
            margin-top: 10px;
        }

        .nav .open>a,
        .nav .open>a:focus,
        .nav .open>a:hover {
            background-color: #1b609c;
            border-color: #1b609c;
        }

        @media (max-width: 767px) {

            .fixed .content-wrapper,
            .fixed .right-side {
                padding-top: 37px;
            }

            .nav.navbar-nav li a i {
                color: white !important;
            }
        }

        /***********************Fin navbar************ */
        /**************Sidebar******************** */

        .sidebar-menu .active {
            background-color: #9fc10b;
        }

        .sidebar-menu li:hover {
            background-color: #9fc10b;
        }

        .treeview-menu {
            background-color: #D0D6D6 !important;
        }

        .treeview-menu.menu-open a {
            border-bottom: 1px solid #D0D6D6;
        }

        .treeview-menu.menu-open li:hover {
            background-color: #b9cc67;
        }

        .treeview-menu .divider {
            border-top: 1px solid #BBC0C0;
            border-bottom: 1px solid #BBC0C0;
            margin: 4px 0 4px -5px !important;
            display: block;
        }

        .sidebar-menu>li>a {
            padding: 8px 5px 12px 15px;
            display: block;
        }

        @media (max-width: 767px) {

            .main-sidebar,
            .left-side {
                padding-top: 50px !important;
            }
        }

        /***********************Fin Sidebar************ */
        /*******************loading ball************* */

        #ajaxCall {
            display: none;
            color: #004785;
            background: #dadadad1;
            border-radius: 0px;
            top: 40%;
            right: 35%;
            position: fixed;
            width: 30%;
            height: 23%;
            z-index: 1000;
            text-align: center;
            font-size: 100%;
        }

        #ajaxCall i {
            font-size: 100px;
        }

        /*******************fin loading ball************* */
        /*******************datatable************* */
        .dataTables_processing {
            display: none;
        }

        .table-responsive .dataTables_wrapper tbody {
            font-size: 13.5px !important;
        }

        .table-responsive .dataTables_wrapper .select2-selection.select2-selection--single,
        .table-responsive .dataTables_wrapper .form-control.input-xs {
            border-radius: 0px;
            margin: 0px;
            height: 30px;
        }

        .select2-results__option {
            padding: 3px 12px !important;
        }

        .table-responsive {
            border: 0px;
            overflow-x: auto !important;
        }

        /*******************datatable************* */
        /*******************Colores primary & success************* */
        .btn-primary {
            border-color: #17A2B8 !important;
            border-radius: 0px !important;
            background-color: #17A2B8 !important;
            color: white !important;
        }

        .btn-success {
            border-color: #28A745 !important;
            border-radius: 0px !important;
            background-color: #28A745 !important;
            color: white !important;
        }

        .btn-danger {
            border-color: #DC3545 !important;
            border-radius: 0px !important;
            background-color: #DC3545 !important;
            color: white !important;
        }

        #suss:hover {
            border-color: #28A745 !important;
            border-radius: 0px !important;
            background-color: #28A745 !important;
            color: white !important;
        }

        #tick:hover {
           
            background-color: #28A745 !important;
            color: white !important;
        }

        #dan:hover {
            border-color: #DC3545 !important;
            border-radius: 0px !important;
            background-color: #DC3545 !important;
            color: white !important;
        }

        #suss {
            background-color: #fff !important;
            color: #28A745 !important;
            display: flex;
            align-items: center;
        }

        #tick {
            background-color: #fff !important;
            color: #28A745 !important;
            display: flex;
            align-items: center;
        }

        #dan {
           
            background-color: #fff !important;
            color: #DC3545 !important;
            display: flex;
            align-items: center;
        }

        .text-success {
            color: #28A745 !important;
        }

        .text-primary {
            color: #17A2B8 !important;
        }

        .alert.alert-success {
            background-color: #fff !important;
        }

        .alert-danger {
            background-color: #fff !important;
            color: #dd4b39 !important;
        }

        .alert.alert-warning {
            background-color: #ffff !important;
        }

        /*******************Colores primary & success************* */
        .btn-app {
            border-radius: 3px;
            position: relative;
            padding: 15px 5px;
            margin: 0 0 10px 10px;
            min-width: 80px;
            height: 65px;
            text-align: center;
            color: #004785;
            border: 1px solid #ddd;
            background-color: #f4f4f4;
            font-size: 12px;
        }

        .box {
            border-radius: .35rem !important;
            box-shadow: 0 0 1px rgba(0, 0, 0, .125), 0 1px 3px rgba(0, 0, 0, .2) !important;
            margin-bottom: 1rem !important;
        }

        .btn-app:hover {
            color: #9fc10b;
            border: 1px solid #9fc10b;
        }

        label {
            display: inline-block;
            max-width: 100%;
            margin-bottom: 5px;
            font-weight: 600;
        }

        .botones {
            padding-top: 26px !important;
            padding-left: 0px !important;
        }

        @media (max-width: 992px) {
            .botones {
                padding-top: 0px !important;
                padding-left: 15px !important;
            }
        }

        .navbar-nav .tooltip.bottom .tooltip-arrow {
            top: 0;
            left: 50%;
            margin-left: -5px;
            border-width: 0 5px 5px;
            border-bottom-color: #004785;
        }

        .navbar-nav .tooltip-inner {
            max-width: 200px;
            padding: 4px 8px;
            color: #fff;
            text-align: center;
            background-color: #004785;
            border-radius: 4px;
        }

        thead {
            color: #547da0 !important;
            background-color: #f4f4f4 !important;
        }

        tbody {
            color: #6b6c6d !important;
        }

        .label-danger {
            background-color: #F50606 !important;
        }

        .deuda__view {
            margin: 7px 7px 0 7px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
            border: 1.7px solid rgb(255, 125, 129);
            color: rgb(88, 21, 28);
            background: rgba(248, 215, 218, .9);
            gap: 1rem;
            border-radius: 20px;
            font-weight: 600;
            font-size: 16px;
        }

       
        .sidebar-menu a.desactivado {
            color: #7f8c8d !important; /* Color plomo para el texto */
            background-color: #E3E8EB !important; /* Fondo de los elementos desactivados */
            text-decoration: none !important;
            cursor: not-allowed;
        }

        /* Hover en elementos desactivados */
        .sidebar-menu a.desactivado:hover {
            color: #FFFFFF !important; /* Letras blancas */
            background-color: #7f8c8d !important; /* Fondo plomo al pasar el mouse */
        }
    </style>
</head>

<body class="fixed sidebar-mini">
    <div class="wrapper">
        <!-- -----------------------------INICIO DEL HEADER------------------------>
        <header class="main-header" style="background-color: #004785;">
            <a href="<?= site_url(); ?>" class="logo">
                <span class="logo-mini"><img src="<?= $assets ?>img/iconoFSFT.png" alt="'.$Settings->site_name.'" width='30px' /></span>
                <span class="logo-lg"><img src="<?= $assets ?>img/iconoFSFT.png" alt="'.$Settings->site_name.'" width='60px' /><span>FacsiSoft</span></span>
            </a>
            <nav class="navbar navbar-static-top" role="navigation">
                <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
                    <span class="sr-only">Navegación</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </a>
                <!--ul class="nav navbar-nav pull-left">
                    <li class="dropdown hidden-xs">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown"><img src="<?= $assets; ?>images/<?= $Settings->language; ?>.png" alt="<?= $Settings->language; ?>"></a>
                        <ul class="dropdown-menu">
                            <?php $scanned_lang_dir = array_map(function ($path) {
                                return basename($path);
                            }, glob(APPPATH . 'language/*', GLOB_ONLYDIR));
                            foreach ($scanned_lang_dir as $entry) { ?>
                                <li><a href="<?= site_url('pos/language/' . $entry); ?>"><img
                                            src="<?= $assets; ?>images/<?= $entry; ?>.png"
                                            class="language-img"> &nbsp;&nbsp;<?= ucwords($entry); ?></a></li>
                            <?php } ?>
                        </ul>
                    </li>
                </ul-->
                <div class="navbar-custom-menu">
                    <ul class="nav navbar-nav">
                        <li class="hidden-xs"><a href="#"><?= $Local; ?></a></li>
                        <li class="hidden-xs hidden-sm"><a href="#" class="clock"></a></li>
                        <li class="hidden-xs"><a href="#"><?= lang('exchange') . ": " . $Exchange->sell; ?></a></li>
                        <li class="hidden-xs" data-toggle="tooltip" data-placement="bottom" title="Menú"><a href="<?= site_url(); ?>"><i class="fa fa-dashboard"></i></a></li>
                        <?php if ($Admin) { ?>
                            <li class="hidden-xs" data-toggle="tooltip" data-placement="bottom" title="Ajustes"><a href="<?= site_url('settings'); ?>"><i class="fa fa-cogs"></i></a></li>
                        <?php } ?>
                        <li data-toggle="tooltip" data-placement="bottom" title="Presupuesto"><a href="<?= site_url('pos/view_bill'); ?>" target="_blank"><i class="fa fa-file-text-o"></i></a></li>
                        <li data-toggle="tooltip" data-placement="bottom" title="TPV"><a href="<?= site_url('pos'); ?>"><i class="fa fa-th"></i></a></li>
                        <?php if ($Admin && $qty_alert_num) { ?>
                            <li data-toggle="tooltip" data-placement="bottom" title="Alerta de stock">
                                <a href="<?= site_url('reports/alerts'); ?>">
                                    <i class="fa fa-bullhorn"></i>
                                    <span class="label label-danger"><?= $qty_alert_num; ?></span>
                                </a>
                            </li>
                        <?php } ?>
                        <?php if ($suspended_sales) { ?>
                            <li class="dropdown notifications-menu">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-bell-o"></i>
                                    <span class="label label-danger"><?= sizeof($suspended_sales); ?></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li class="header"><?= lang('recent_suspended_sales'); ?></li>
                                    <li>
                                        <ul class="menu">
                                            <li>
                                                <?php
                                                foreach ($suspended_sales as $ss) {
                                                    echo '<a href="' . site_url('pos/?hold=' . $ss->id) . '" class="load_suspended">' . $this->tec->hrld($ss->date) . ' (' . $ss->customer_name . ')<br><strong>' . $ss->hold_ref . '</strong></a>';
                                                }
                                                ?>
                                            </li>
                                        </ul>
                                    </li>
                                    <li class="footer"><a href="<?= site_url('sales/opened'); ?>"><?= lang('view_all'); ?></a></li>
                                </ul>
                            </li>
                        <?php } ?>
                        <li class="dropdown user user-menu" style="padding-right:5px;">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                <img src="<?= base_url('uploads/avatars/thumbs/' . ($this->session->userdata('avatar') ? $this->session->userdata('avatar') : $this->session->userdata('gender') . '.png')) ?>" class="user-image" alt="Avatar" />
                                <span class="hidden-xs"><?= $this->session->userdata('first_name') . ' ' . $this->session->userdata('last_name'); ?></span>
                            </a>
                            <ul class="dropdown-menu" style="padding-right:3px;">
                                <li class="user-header">
                                <h style="font-weight: bold;">Cuenta</h>
                                 <div style="display: flex; align-items: center;">
                                    <img src="<?= base_url('uploads/avatars/' . ($this->session->userdata('avatar') ? $this->session->userdata('avatar') : $this->session->userdata('gender') . '.png')) ?>" class="img-circle" alt="Avatar" style="width: 50px; height: 50px; margin-right: 10px;" />
                                    <div style="flex-grow: 1;">
                                        <p style="margin-bottom: 5px;"><?= $this->session->userdata('email'); ?></p>
                                        <p style="margin-bottom: 0;"><small><?= lang('member_since') . ' ' . $this->session->userdata('created_on'); ?></small></p>
                                    </div>
                                </div>
                                    <a href="<?= site_url('users/profile/' . $this->session->userdata('user_id')); ?>" id="suss" class="btn btn-flat"><?= lang('profile'); ?></a>
                                    <!--<a href="<?= site_url('tickets/index/');?>" id="tick" class="btn btn-flat"><?= lang('view_tickets_pay'); ?></a>-->
                                    <a href="<?= site_url('logout'); ?>" id="dan" class="btn btn-flat"><?= lang('logout'); ?></a>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>
        <!-- -----------------------------FIN DEL HEADER------------------------>
        <!-- -----------------------------INICIO DEL MENU------------------------>
        <aside class="main-sidebar" style="background-color: #E3E8EB;">
            <section class="sidebar" style="padding-top: 8px;">
                <ul class="sidebar-menu">
                    <?php
                    // Determina el perfil del usuario basado en su rol
                    if ($Admin) {
                        $perfilUsuario = 1; // Admin
                    } elseif ($Staff) {
                        $perfilUsuario = 2; // Staff
                    } elseif ($Caja) {
                        $perfilUsuario = 3; // Caja
                    } 

                    // Ahora puedes utilizar $perfilUsuario en tu lógica de visualización del menú
                    ?>
                     <?php foreach ($menuItems as $item): ?>
                        <?php if (in_array($perfilUsuario, $item['permiso_perfil'])): ?>
                            <li class="<?= $item['class'] ?>" id="<?= $item['id'] ?>">
                                <a href="<?= base_url($item['url']) ?>" class="<?=($item['active']!=1)?'desactivado':''?>" 
                                <?php if ($item['venta_emergente'] == 1): ?>
                                    onclick="window.open('<?= base_url($item['url']) ?>', '_blank', 'width=800,height=600'); return false;"
                                <?php endif; ?>>
                                    <i class="<?= $item['icono'] ?>"></i><span><?= $item['nombre'] ?></span>
                                    <?php if (!empty($item['submenu'])): ?>
                                        <i class="fa fa-angle-left pull-right"></i>
                                    <?php endif; ?>
                                </a>
                                <?php if (!empty($item['submenu'])): ?>
                                    <ul class="treeview-menu">
                                        <?php foreach ($item['submenu'] as $submenuItem): ?>
                                            <?php if (in_array($perfilUsuario, $submenuItem['permiso_perfil'])): ?>
                                                <li class="<?= $submenuItem['class'] ?>" id="<?= $submenuItem['id'] ?>">
                                                    <a href="<?= base_url($submenuItem['url']) ?>" class="<?=($submenuItem['active']!=1)?'desactivado':''?>"
                                                    <?php if ($submenuItem['venta_emergente'] == 1): ?>
                                                        onclick="window.open('<?= base_url($submenuItem['url']) ?>', '_blank', 'width=800,height=600'); return false;"
                                                    <?php endif; ?>>
                                                        <i class="<?= $submenuItem['icono'] ?>"></i><?= $submenuItem['nombre'] ?>
                                                    </a>
                                                </li>
                                                <?php if($submenuItem['separador']): ?>
                                                    <li class="divider"></li>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ul>
            </section>
        </aside>


        <div class="content-wrapper">
            <?php
            $deudaPendiente = $this->session->userdata('deuda_pendiente');
            if (isset($deudaPendiente)) { ?>
                <div class="deuda__view" id="deuda__view__mensaje">
                    <span><?= $deudaPendiente ?></span>
                    <button aria-hidden="true" data-dismiss="alert" class="close close__btn button" type="button" id="cerrar_notificacion_deuda">×</button>
                </div>
            <?php } ?>
            <section class="content-header">
                <span style="font-size: 22px;"><?= $page_title; ?></span>
                <ol class="breadcrumb">
                    <li><a href="<?= site_url(); ?>"><i class="fa fa-dashboard"></i> <?= lang('home'); ?></a></li>
                    <?php
                    foreach ($bc as $b) {
                        if ($b['link'] === '#') {
                            echo '<li class="active">' . $b['page'] . '</li>';
                        } else {
                            echo '<li><a href="' . $b['link'] . '">' . $b['page'] . '</a></li>';
                        }
                    }
                    ?>
                </ol>
            </section>

            <div class="col-lg-12 alerts">
                <div id="custom-alerts" style="display:none;">
                    <div class="alert alert-dismissable">
                        <div class="custom-msg"></div>
                    </div>
                </div>
                <?php if ($error) { ?>
                    <div class="alert alert-danger alert-dismissable message-error" style="border: 1px solid #ffff;border-radius: 2.25rem;">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        <span style="color: red!important;">
                            <center>
                                <strong style="font-size: 17px;"><i class="icon fa fa-ban"></i> <?= lang('error'); ?></strong>&nbsp;&nbsp;
                                <span style="color:#6c757d;"><?php $error = str_replace(".", "", $error); ?><?= $error; ?></span>
                            </center>
                        </span>
                    </div>
                <?php }
                if ($warning) { ?>
                    <div class="alert alert-warning alert-dismissable message-warning" style="border: 1px solid #FFC107;border-radius: 2.25rem;">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        <span style="color: #FFC107!important;">
                            <center>
                                <strong style="font-size: 17px;"><i class="icon fa fa-warning"></i> <?= lang('warning'); ?></strong>&nbsp;&nbsp;
                                <span style="color:#6c757d;"> <?= $warning; ?></span>
                            </center>
                        </span>
                    </div>
                <?php }
                if ($message) { ?>
                    <div class="alert alert-success alert-dismissable message-success" style="border: 1px solid #28A745;border-radius: 2.25rem;">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        <span style="color: #28a745!important;text-align: center;">
                            <center>
                                <strong style="font-size: 17px;"><i class="icon fa fa-check"></i><?= lang('Success'); ?></strong>&nbsp;&nbsp;
                                <span style="color:#6c757d;"> <?= $message; ?></span>
                            </center>
                        </span>
                    </div>
                <?php } ?>
            </div>