<?php defined('BASEPATH') or exit('No direct script access allowed');

class Purchase_orders extends MY_Controller
{

	function __construct()
	{
		parent::__construct();

		if (!$this->loggedIn) {
			redirect('login');
		}

		$this->load->library('form_validation');

		$this->load->model('pos_model');
		$this->load->model('suppliers_model');
		//$this->load->model('traders_model');f
	}

	function index()
	{

		$this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
		$this->data['page_title'] = lang('purchase_orders');

		$bc = array(array('link' => '#', 'page' => lang('purchase_orders')));
		$meta = array('page_title' => lang('purchase_orders'), 'bc' => $bc);
		$this->page_construct('purchase_orders/index', $this->data, $meta);
	}

	function get_purchase_orders()
	{

		$rows = array();
		$temporal = array();

		$columnas = array(
			0 => 'issuance_date',
			1 => 'num_purchase_order',
			2 => 'supplier_name',
			3 => 'supplier_ruc',
			4 => 'currency',
			5 => 'exchange',
			6 => 'affected',
			7 => 'non_affected',
			8 => 'exonerated',
			9 => 'total',
			10 => 'product_discount',
			11 => 'order_discount_percentage',
			12 => 'order_discount_percentage_value',
			13 => 'order_discount_no_percentage_value',
			14 => 'total_discount',
			15 => 'product_tax',
			16 => 'order_tax_id',
			17 => 'order_tax',
			18 => 'total_tax',
			19 => 'tax_ICBPER',
			20 => 'mult_ICBPER',
			21 => 'subtotal',
			22 => 'grand_total',
			23 => 'total_items',
			24 => 'total_quantity',
			25 => 'note',
			26 => 'rounding',
			27 => 'attachment',
			28 => 'expiration_date',
			29 => 'canal_id',
			30 => 'payment_method_id',
			31 => 'num_quotation',
			32 => 'destination_address',
			33 => 'destination_ubigeo',
			34 => 'supplier_address',
			35 => 'supplier_contact_name',
			36 => 'supplier_contact_phone',
			37 => 'supplier_contact_email',
			38 => 'estado',
			39 => 'action'
		);

		$data = $_GET;
		$filtro = $_GET["search"]['value'];
		$orderby = $columnas[$data['order'][0]['column']];
		$orderdir = $_GET['order'][0]['dir'];
		$start = $_GET['start'];
		$length = $_GET['length'];
		$draw = $_GET["draw"];
		$start_date = $_GET["start_date"];
		$end_date = $_GET["end_date"];
		$estado = $_GET["estado"];

		$filtro = str_replace(' ', '%', $filtro);

		$urlModels = "purchase_order";
		$values = "?orderby=" . $orderby . "&orderdir=" . $orderdir . "&start=" . $start . "&length=" . $length;
		if ($filtro != "") {
			$values = $values . "&search=" . $filtro;
		}
		$urlModels = $urlModels . $values;



		$business_information = array(
			"ruc_number" => (string) ($this->session->userdata('ruc'))
		);
		$context_data["business_information"] = $business_information;
		$context_data["filters"] = array(
			"start_date" => $start_date,
			"end_date" => $end_date,
			"estado" => $estado,
		);

		$context = stream_context_create(
			array(
				'http' => array(
					'method' => 'GET',
					'header' => "Authorization: application/json\r\n" . "Content-Type: application/json\r\n",
					'content' => json_encode($context_data)
				)
			)
		);
		$url = $this->config->item('api_compras');
		$response = file_get_contents($url . $urlModels, false, $context);
		$response = json_decode($response, true);



		if ($response['result'] == 'ok') {

			$contador_total = $response['data']['total'];
			$rows['recordsFiltered'] = $contador_total;

			foreach ($response['data']['list'] as $purchase_order) {
				$issuance_date = $purchase_order['issuance_date'];
				$issuance_date_formatted = date("d/m/Y", strtotime($issuance_date));
				$num_purchase_order = $purchase_order['num_purchase_order'];
				$supplier_name = $purchase_order['supplier_name'];
				$supplier_ruc = $purchase_order['supplier_ruc'];
				$currency = $purchase_order['currency'];
				$exchange = $purchase_order['exchange'];
				$affected = $purchase_order['affected'];
				$non_affected = $purchase_order['non_affected'];
				$exonerated = $purchase_order['exonerated'];
				$total = $purchase_order['total'];
				$product_discount = $purchase_order['product_discount'];
				$order_discount_percentage = $purchase_order['order_discount_percentage'];
				$order_discount_percentage_value = $purchase_order['order_discount_percentage_value'];
				$order_discount_no_percentage_value = $purchase_order['order_discount_no_percentage_value'];
				$total_discount = $purchase_order['total_discount'];
				$product_tax = $purchase_order['product_tax'];
				$order_tax_id = $purchase_order['order_tax_id'];
				$order_tax = $purchase_order['order_tax'];
				$total_tax = $purchase_order['total_tax'];
				$tax_ICBPER = $purchase_order['tax_ICBPER'];
				$mult_ICBPER = $purchase_order['mult_ICBPER'];
				$subtotal = $purchase_order['subtotal'];
				$grand_total = $purchase_order['grand_total'];
				$total_items = $purchase_order['total_items'];
				$total_quantity = $purchase_order['total_quantity'];
				$note = $purchase_order['note'];
				$rounding = $purchase_order['rounding'];
				$attachment = $purchase_order['attachment'];
				$expiration_date = $purchase_order['expiration_date'];
				$canal_id = $purchase_order['canal_id'];
				$payment_method_id = $purchase_order['payment_method_id'];
				$num_quotation = $purchase_order['num_quotation'];
				$destination_address = $purchase_order['destination_address'];
				$destination_ubigeo = $purchase_order['destination_ubigeo'];
				$supplier_address = $purchase_order['supplier_address'];
				$supplier_contact_name = $purchase_order['supplier_contact_name'];
				$supplier_contact_phone = $purchase_order['supplier_contact_phone'];
				$supplier_contact_email = $purchase_order['supplier_contact_email'];

				if ($purchase_order['estado'] == "1") {
					$estado = lang('finished');
				}
				if ($purchase_order['estado'] == "2") {
					$estado = lang('in_progress');
				}


				$items = array();
				foreach ($purchase_order['items'] as $item) {
					$item_data = array(
						"id" => $item['id'],
						"purchase_order_header_id" => $item['purchase_order_header_id'],
						"product_id" => $item['product_id'],
						"code" => $item['code'],
						"name" => $item['name'],
						"quantity" => $item['quantity'],
						"unit_price" => $item['unit_price'],
						"affect_price" => $item['affect_price'],
						"non_affected_price" => $item['non_affected_price'],
						"exonerated_price" => $item['exonerated_price'],
						"gratuito_price" => $item['gratuito_price'],
						"price_affected_item" => $item['price_affected_item'],
						"price_no_affected_item" => $item['price_no_affected_item'],
						"price_exonerated_item" => $item['price_exonerated_item'],
						"price_gratuito_item" => $item['price_gratuito_item'],
						"discount" => $item['discount'],
						"item_discount" => $item['item_discount'],
						"prr_discount" => $item['prr_discount'],
						"tax" => $item['tax'],
						"item_tax" => $item['item_tax'],
						"tax_gratuito" => $item['tax_gratuito'],
						"item_tax_gratuito" => $item['item_tax_gratuito'],
						"igv" => $item['igv'],
						"tax_ICBPER" => $item['tax_ICBPER'],
						"quantity_ICBPER" => $item['quantity_ICBPER'],
						"subtotal" => $item['subtotal'],
						"real_unit_price" => $item['real_unit_price'],
						"cost" => $item['cost'],
						"tax_method" => $item['tax_method'],
						"type_of_affectation" => $item['type_of_affectation'],
						"created_at" => $item['created_at'],
						"created_by" => $item['created_by'],
						"updated_by" => $item['updated_by'],
						"updated_at" => $item['updated_at'],
						"status" => $item['status'],
					);
					array_push($items, $item_data);
				}
				if ($purchase_order['estado'] == 2) {
					$accion = "
				
				<div class='text-center'>
				
					<div class='btn-group'>
					
						<a href='#' onClick=\"MyWindow=window.open('" . site_url('purchase_orders/view_order/' . $purchase_order['id']) . "', 'MyWindow','toolbar=no,location=no,directories=no,status=no,menubar=yes,scrollbars=yes,resizable=yes,width=1000,height=1000'); return false;\" title='" . lang("see_order") . "' class='tip btn btn-primary btn-xs'><i class='fa fa-list'></i></a>
						<a href='" . site_url('purchase_orders/downloadPDF/' . $purchase_order['id']) . "' title='" . lang("download_pdf") . "' class='tip btn btn-danger btn-xs' ><i class='fa fa-file-pdf-o'></i></a>
						<a href='" . site_url('purchase_orders/supplier/' . $purchase_order['id']) . "' title='" . lang("inf_supplier") . "' class='tip btn btn-success btn-xs' data-toggle='ajax'><i class='fa fa-truck'></i></a>
						<a href='" . site_url('purchase_orders/edit/' . $purchase_order['id']) . "' title='" . lang("edit_order") . "' class='tip btn btn-primary btn-xs'><i class='fa fa-edit'></i></a>
					</div>

					<div class='btn-group'>
				
						<a href='" . site_url('purchase_orders/change_estado/' . $purchase_order['id']) . "' onClick=\"return confirm('" . lang('finish_order_q') . "')\" title='" . lang("finish_order") . "' class='tip btn btn-warning btn-xs' ><i class='fa fa-check'></i></a>
						<a href='" . site_url('purchase_orders/recreate_pdf/' . $purchase_order['id']) . "' title='" . lang("recreate_pdf") . "' class='tip btn btn-info btn-xs' ><i class='fa fa-refresh'></i></a>
						<a href='" . site_url('purchase_orders/delete/' . $purchase_order['id']) . "' onClick=\"return confirm('" . lang('remove_order_Q') . "')\" title='" . lang("remove_order") . "' class='tip btn btn-danger btn-xs' ><i class='fa fa-trash-o'></i></a>
					</div>
					
					
					
				
				
				
				</div>";
				} else {
					$accion = "
				
				
				<div class='btn-group'>
					<div class='btn-group'>
					
						<a href='#' onClick=\"MyWindow=window.open('" . site_url('purchase_orders/view_order/' . $purchase_order['id']) . "', 'MyWindow','toolbar=no,location=no,directories=no,status=no,menubar=yes,scrollbars=yes,resizable=yes,width=1000,height=1000'); return false;\" title='" . lang("see_order") . "' class='tip btn btn-primary btn-xs'><i class='fa fa-list'></i></a>
						<a href='" . site_url('purchase_orders/recreate_pdf/' . $purchase_order['id']) . "' title='" . lang("recreate_pdf") . "' class='tip btn btn-info btn-xs' ><i class='fa fa-refresh'></i></a>
						<a href='" . site_url('purchase_orders/downloadPDF/' . $purchase_order['id']) . "' title='" . lang("download_pdf") . "' class='tip btn btn-danger btn-xs' ><i class='fa fa-file-pdf-o'></i></a>
						
					</div>		
						
					<div class='btn-group'>

						<a href='" . site_url('purchase_orders/supplier/' . $purchase_order['id']) . "' title='" . lang("inf_supplier") . "' class='tip btn btn-success btn-xs' data-toggle='ajax'><i class='fa fa-truck'></i></a>
						<a href='" . site_url('purchase_orders/delete/' . $purchase_order['id']) . "' onClick=\"return confirm('" . lang('remove_order_Q') . "')\" title='" . lang("remove_order") . "' class='tip btn btn-danger btn-xs' ><i class='fa fa-trash-o'></i></a>
				    
					</div>	         
					<div class='btn-group'>
				";
				}



				$datos = array(
					"issuance_date" => $issuance_date_formatted,
					"num_purchase_order" => $num_purchase_order,
					"supplier_name" => $supplier_name,
					"supplier_ruc" => $supplier_ruc,
					"currency" => $currency,
					"exchange" => $exchange,
					"affected" => $affected,
					"non_affected" => $non_affected,
					"exonerated" => $exonerated,
					"total" => $total,
					"product_discount" => $product_discount,
					"order_discount_percentage" => $order_discount_percentage,
					"order_discount_percentage_value" => $order_discount_percentage_value,
					"order_discount_no_percentage_value" => $order_discount_no_percentage_value,
					"total_discount" => $total_discount,
					"product_tax" => $product_tax,
					"order_tax_id" => $order_tax_id,
					"order_tax" => $order_tax,
					"total_tax" => $total_tax,
					"tax_ICBPER" => $tax_ICBPER,
					"mult_ICBPER" => $mult_ICBPER,
					"subtotal" => $subtotal,
					"grand_total" => $grand_total,
					"total_items" => $total_items,
					"total_quantity" => $total_quantity,
					"note" => $note,
					"rounding" => $rounding,
					"attachment" => $attachment,
					"expiration_date" => $expiration_date,
					"canal_id" => $canal_id,
					"payment_method_id" => $payment_method_id,
					"num_quotation" => $num_quotation,
					"destination_address" => $destination_address,
					"destination_ubigeo" => $destination_ubigeo,
					"supplier_address" => $supplier_address,
					"supplier_contact_name" => $supplier_contact_name,
					"supplier_contact_phone" => $supplier_contact_phone,
					"supplier_contact_email" => $supplier_contact_email,
					"estado" => $estado,
					"items" => $items,
					"action" => $accion,
				);

				array_push($temporal, $datos);
			} //foreach_final

		} else {
			$contador_total = 0;
			$rows['draw'] = $draw;
			$rows['recordsFiltered'] = $contador_total;
		}
		$rows['data'] = $temporal;
		echo json_encode($rows);
	}

	function get_last_id()
	{
		$last_id = 0; // Inicializa la variable $last_id

		$urlModels = "purchase_order";

		$business_information = array(
			"ruc_number" => (string) $this->session->userdata('ruc')
		);
		$context_data["business_information"] = $business_information;
		$context = stream_context_create(array(
			'http' => array(
				'method' => 'GET',
				'header' => "Authorization: application/json\r\n" . "Content-Type: application/json\r\n",
				'content' => json_encode($context_data)
			)
		));

		$url = $this->config->item('api_compras');
		$response = file_get_contents($url . $urlModels, false, $context);

		if ($response === false) {
			// Manejar errores de solicitud HTTP
			die("Error al realizar la solicitud HTTP");
		}

		$response = json_decode($response, true);

		if ($response === null) {
			// Manejar errores de decodificación JSON
			die("Error al decodificar la respuesta JSON");
		}

		// Procesar la respuesta JSON para obtener el último ID
		foreach ($response['data']['list'] as $order) {
			$order_id = $order['id'];
			// Comprobar si el ID actual es mayor que el último ID conocido
			if ($order_id > $last_id) {
				// Actualizar el último ID conocido
				$last_id = $order_id;
			}
		}

		log_message('error', json_encode($response));
		return $last_id + 1;
	}

	function get_purchase_orders_byid($id = null)
	{

		$business_information = array(
			"ruc_number" => (string) ($this->session->userdata('ruc'))
		);
		$context_data["business_information"] = $business_information;


		$context = stream_context_create(array(
			'http' => array(
				'method' => 'GET',
				'header' => "Authorization: application/json\r\n" . "Content-Type: application/json\r\n",
				'content' => json_encode($context_data)
			)
		));

		$url = $this->config->item('api_compras');

		$urlModels = "purchase_order/" . $id;

		$response = file_get_contents($url . $urlModels, false, $context);
		$purchase_order = json_decode($response, true);

		if ($purchase_order['result'] == 'ok') {
			$purchase_order = $purchase_order['data'];
		} else {
			$purchase_order = [];
		}

		// if ($this->input->is_ajax_request()) {
		// 	echo json_encode($purchase_order);
		// }

		return $purchase_order;
	}

	function add()
	{

		$this->form_validation->set_rules('date', lang('date'), 'required');

		if ($this->form_validation->run() == true) {

			$total = 0;
			$affected = 0;
			$bruto_affecto_igv = 0;
			$tax = 0;
			$exonerated = 0;
			$exoneradoReal = 0;
			$gratuito = 0;
			$tax_gratuito_total = 0;
			$unit_price = "price";
			$discount = $this->input->post('gdiscount');
			$total_pay = $this->input->post('total_pay');

			$estado = $this->input->post('estado');

			$sub_total = 0;
			$total_item_affect = 0;
			$total_item_non_affected = 0;
			$total_item_exonerated = 0;

			$i = isset($_POST['product_id']) ? sizeof($_POST['product_id']) : 0;
			$settings_tax = $this->Settings->default_tax_rate;
			$count = 0;
			$countt = 0;

			//Ultimo id
			$last_id = $this->get_last_id();
			//


			$ICBPER = (array)$this->pos_model->user_mail();


			if ($ICBPER["tax_icbper"] == 0) {
				$mult_ICBPER = 0;
			} else {
				$mult_ICBPER = (array)$this->pos_model->tax_ICBPER_amount($ICBPER["tax_icbper"]);
			}

			$total_ICBPER = 0;

			for ($r = 0; $r < $i; $r++) {

				$item_id = $_POST['product_id'][$r];
				$item_qty = $_POST['quantity'][$r];
				$unit_price_item = $_POST['price'][$r];
				$item_affect_price = 0;
				$item_non_affected_price = 0;
				$item_exonerated_price = 0;
				$item_gratuito_price = 0;

				$item_affect_price = $_POST['affect_price'][$r];
				$item_non_affected_price = $_POST['non_affected_price'][$r];
				$item_exonerated_price = $_POST['exonerated_price'][$r];
				$item_gratuito_price = $_POST['gratuito_price'][$r];


				$tax_method = $_POST['tax_method'][$r];

				$tipo_afectacion = $_POST['tipo_afectacion'][$r];

				$real_unit_price = $_POST['real_unit_price'][$r];
				$cost = $_POST['cost'][$r];
				$name = $_POST['name'][$r];
				$code = $_POST['code'][$r];



				//Operaciones
				if ($ICBPER["tax_icbper"] > 0) {
					$tax_ICBPER = $_POST['value_ICBPER'][$r];

					if ($tax_ICBPER == 1) {

						if ($mult_ICBPER['amount'] > 0) {
							$quantity_ICBPER = (int)(round($item_qty));
						} else {

							$quantity_ICBPER = 0;
						}

						if ($quantity_ICBPER > 0) {
							$unit_price_ICBPER = $mult_ICBPER['amount'];
							$valor_item_ICBPER = $mult_ICBPER['amount'] * round($item_qty);
						} else {
							$unit_price_ICBPER = 0;
							$valor_item_ICBPER = 0;
						}
					} else {
						$unit_price_ICBPER = 0;
						$valor_item_ICBPER = 0;
						$quantity_ICBPER = 0;
					}
				} else {
					$unit_price_ICBPER = 0;
					$valor_item_ICBPER = 0;
					$quantity_ICBPER = 0;
				}

				$total_ICBPER = $total_ICBPER + $valor_item_ICBPER;

				if ($item_id && $item_qty && $unit_price) {



					$pr_item_tax = 0;
					$item_afec = 0;
					$item_tax = 0;
					$tax_gratuito = 0;
					$item_tax_gratuito = 0;
					$item_exon = 0;
					$item_exoReal = 0;
					$item_gratuito = 0;
					$p_igv = $settings_tax;

					if (isset($settings_tax) && $settings_tax != 0) {

						$item_afec = $item_affect_price / (1 + ($settings_tax / 100));
						$item_tax = $item_affect_price - $item_afec;
						$item_exoReal = $item_exonerated_price;
						$item_exon = $item_non_affected_price;
						$item_gratuito = $item_gratuito_price;
						if ($tipo_afectacion == 0 || $tipo_afectacion == 1) { //AFECTO
							$p_igv = $settings_tax;
							$bool_afecto = true;
						} else if ($tipo_afectacion == 2 || $tipo_afectacion == 3 || $tipo_afectacion == 5) { // 2=INAFECTO 3= exonerado 4=Gratuito
							$p_igv = 0;
						} else if ($tipo_afectacion == 4) {
							$item_gratuito = $item_gratuito_price;
							$tax_gratuito = $item_gratuito * ($settings_tax / 100);
							$p_igv = $settings_tax;
						}
						$pr_item_tax = round($item_tax, 4) * $item_qty;
						$item_tax_gratuito = round($tax_gratuito, 4) * $item_qty;
					}


					$subtotal = (($item_affect_price + $item_exoReal + $item_exon) * $item_qty) + $valor_item_ICBPER; //$item_price * $item_qty;
					$prr_discount = 0;

					if ($code == "") {
						$item_id = null;
					}

					$unit_price_item = (float)$item_affect_price + (float)$item_non_affected_price + (float)$item_exonerated_price + (float)$item_gratuito_price;

					$products[] = array(
						'product_id' => $item_id,
						'code' => $code,
						'name' => $name,
						'quantity' => $item_qty,
						'unit_price' => $unit_price_item,
						'affect_price' => round($item_affect_price - $item_tax, 4),
						'non_affected_price' => round($item_non_affected_price, 4),
						'exonerated_price' => round($item_exonerated_price, 4),
						'gratuito_price' => round($item_gratuito_price, 4),

						'price_affected_item' => round((round($item_affect_price - $item_tax, 4)) * $item_qty, 4),
						'price_no_affected_item' => round($item_non_affected_price * $item_qty, 4),
						'price_exonerated_item' => round($item_exonerated_price * $item_qty, 4),
						'price_gratuito_item' => round($item_gratuito_price * $item_qty, 4),

						'discount' => "",
						'item_discount' => 0.00,
						'prr_discount' => round($prr_discount, 4),
						'tax' => round($item_tax, 4),
						'item_tax' => round($pr_item_tax, 4),
						'tax_gratuito' => round($tax_gratuito, 4),
						'item_tax_gratuito' => round($item_tax_gratuito, 4),
						'igv' => $p_igv,
						'tax_ICBPER' => $valor_item_ICBPER,
						'quantity_ICBPER' => $quantity_ICBPER,
						'subtotal' => $subtotal,
						'real_unit_price' => $this->tec->formatDecimal($real_unit_price),
						'cost' => $this->tec->formatDecimal($cost),
						'tax_method' => (int)$tax_method,
						'type_of_affectation' => (int)$tipo_afectacion
					);


					$total += (((float)$item_affect_price + (float)$item_non_affected_price + (float)$item_exonerated_price) * $item_qty);


					$total_item_affect += (float)$item_affect_price * $item_qty;
					$total_item_non_affected += (float)$item_non_affected_price * $item_qty;
					$total_item_exonerated += (float)$item_exonerated_price * $item_qty;

					log_message("error", $subtotal);

					$sub_total += $subtotal;

					$bruto_affecto_igv +=  (($item_afec + $item_tax) * $item_qty);


					$affected += (round($item_afec, 4) * $item_qty);
					$tax += $pr_item_tax;

					//
					$totalaffect = $affected;
					$totaltax = $tax;



					if ($item_exon > 0) {
						$exonerated += ($item_exon * $item_qty);
					} else {
						$exonerated += ($item_exon * $item_qty);
					}

					if ($item_exoReal > 0) {
						$exoneradoReal += ($item_exoReal * $item_qty);
					} else {
						$exoneradoReal += ($item_exoReal * $item_qty);
					}

					$gratuito += $item_gratuito * $item_qty;
					$tax_gratuito_total += $item_tax_gratuito;

					$count = $count + 1;
					$countt += $item_qty;
				}
			}

			if (!isset($products) || empty($products)) {
				$this->form_validation->set_rules('product', lang("order_items"), 'required');
			}

			if ($this->form_validation->run() == true) {

				// $sub_total = $affected + $exonerated + $tax + $exoneradoReal + $total_ICBPER;
				$grand_subtotal = $total + $total_ICBPER; //$total - $discount;

				$supplier_values = (array)$this->suppliers_model->getSupplierByID($this->input->post('supplier'));

				if ($discount > 0) {
					$p_igv = $settings_tax;
					$totalaffect = $totalaffect - $discount;
					$totaltax = $totalaffect * ($p_igv / 100);
					log_message('error', "Total afecto:" . $totalaffect);
					log_message('error', "igv:" . $p_igv);

					$total = $totalaffect + $total_item_non_affected + $total_item_exonerated + $totaltax;
					$grand_subtotal = $total + $total_ICBPER;
				}



				$data = array(
					"business_information" => array(
						"ruc_number" => $this->session->userdata('ruc')
					),
					'issuance_date' => $this->input->post('date'), //fecha de amision
					'num_purchase_order' => $last_id,
					'supplier_id' => $this->input->post('supplier'),
					'supplier_name' => $supplier_values['name'],
					'supplier_ruc' => $supplier_values['cf1'],
					'currency' => $this->input->post('currency_code'), // codigo de moneda
					'exchange' => 0, //tipo de cambio
					'affected' => round($totalaffect, 4), //monto afecto a igv
					'non_affected' => round($exonerated, 4), // monto inafecto
					'gratuito' => round($gratuito, 4), //monto exonerado 
					'tax_gratuito' => round($tax_gratuito_total, 4), //monto exonerado 
					'exonerated' => round($exoneradoReal, 4), //monto exonerado 
					'product_discount' => 0,
					'order_discount_percentage' => 0,
					'order_discount_percentage_value' => 0,
					'order_discount_no_percentage_value' => $discount,
					'total_discount' => $discount,
					'product_tax' => round($totaltax, 4),
					'order_tax_id' => "",
					'order_tax' => 0,
					'total_tax' => round($totaltax, 4),
					'tax_ICBPER' => $total_ICBPER,
					'mult_ICBPER' => $mult_ICBPER['amount'],
					'total_quantity' => $countt,
					'total_items' => $count,
					'subtotal' => round($sub_total, 4),
					'total' => $total + $total_ICBPER,
					'grand_total' => round($grand_subtotal, 4),
					'note' => $this->input->post('note', true),
					'rounding' => 0,
					'attachment' => "",
					'expiration_date' => $this->input->post('expiration_date') ? $this->input->post('expiration_date') : null, // fecha de experacion
					'canal_id' => 2,
					'payment_method_id' => 1, // identificacion del metodo de pago 1= contado 2= credito
					'num_quotation' => 0,
					'supplier_contact_name' => "",
					'destination_address' => "",
					'destination_ubigeo' => "",
					'supplier_address' => $supplier_values['cf2'],
					'supplier_contact_phone' => $supplier_values['phone'],
					'supplier_contact_email' => $supplier_values['email'],
					'estado' => $estado,
					'items' => $products,

				);

				$url = $this->config->item('api_compras');
				$url = $url . "purchase_order";

				$headers = array(
					'Content-Type:application/json',
					'Accept: application/json'
				);
				$curl = curl_init($url);
				curl_setopt($curl, CURLOPT_POST, true);
				curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
				$response = curl_exec($curl);
				$res = json_decode($response, true);

				// ksort($data);
				log_message("error", json_encode($data));
			}
		}

		if (($this->form_validation->run() == true) && isset($res)) {


			if (empty($res)) {
				if ($this->input->is_ajax_request()) {
					echo json_encode(array('status' => 'failed', 'msg' => 'No se pudo agregar la orden de compra,', 'data' => $res));

					die();
				}
				$this->session->set_flashdata('form_data', $_POST);
				$this->session->set_flashdata('error', 'No se pudo agregar la orden de compra.');
				redirect("purchase_orders/add");
			} else {
				if ($res['result'] == 'ok') {
					$this->session->set_flashdata('message', $res['message']);


					$this->generar_pdf($last_id);

					redirect("purchase_orders");
				} else {
					$dataError = [];
					if (is_array($res['message'])) {
						foreach ($res['message'] as $key => $value) {
							for ($i = 0; $i < count($res['message'][$key]); $i++) {
								array_push($dataError, $res['message'][$key][$i]);
							}
						}
					} else {
						array_push($dataError, $res['message']);
					}

					$this->session->set_flashdata('error', str_replace(',', '<br/>', implode(',', $dataError)));
					$this->session->set_flashdata('form_data', $_POST);
					redirect("purchase_orders/add");
				}
			}
		} else {

			$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

			$advSale = (array)$this->site->getAdvanced_sale();
			$this->data['advance_sale'] = $advSale['advanced_sale'];

			$seting_bags = $this->pos_model->consult_plastic_bags();


			if ($seting_bags->tax_icbper == 0) {
				$this->data['plastic_bags'] = 0;
			} else {
				$consul_bags = $this->pos_model->consult_plastic_bags_type($seting_bags->tax_icbper);
				$this->data['plastic_bags'] = $consul_bags->amount;
			}

			if ($this->input->is_ajax_request()) {
				echo json_encode(array('status' => 'failed', 'msg' => validation_errors()));

				die();
			}

			$this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
			$this->data['form_data'] = $this->session->flashdata('form_data');
			$this->data['suppliers'] = $this->site->getAllSuppliers();
			$this->data['page_title'] = lang('new_purchase_order');
			$bc = array(array('link' => site_url('purchase_order'), 'page' => lang('purchase_order')), array('link' => '#', 'page' => lang('new_purchase_order')));
			$meta = array('page_title' => lang('new_purchase_order'), 'bc' => $bc);
			$this->page_construct('purchase_orders/add', $this->data, $meta);
		}
	}

	function edit($id = NULL)
	{

		$this->form_validation->set_rules('date', lang('date'), 'required');

		if ($this->form_validation->run() == true) {

			$total = 0;
			$affected = 0;
			$bruto_affecto_igv = 0;
			$tax = 0;
			$exonerated = 0;
			$exoneradoReal = 0;
			$gratuito = 0;
			$tax_gratuito_total = 0;
			$unit_price = "price";
			$discount = $this->input->post('gdiscount');
			$total_pay = $this->input->post('total_pay');

			$estado = $this->input->post('estado');

			$sub_total = 0;
			$total_item_affect = 0;
			$total_item_non_affected = 0;
			$total_item_exonerated = 0;

			$i = isset($_POST['product_id']) ? sizeof($_POST['product_id']) : 0;
			$settings_tax = $this->Settings->default_tax_rate;
			$count = 0;
			$countt = 0;



			$ICBPER = (array)$this->pos_model->user_mail();


			if ($ICBPER["tax_icbper"] == 0) {
				$mult_ICBPER = 0;
			} else {
				$mult_ICBPER = (array)$this->pos_model->tax_ICBPER_amount($ICBPER["tax_icbper"]);
			}

			$total_ICBPER = 0;

			for ($r = 0; $r < $i; $r++) {

				$item_id = $_POST['product_id'][$r];
				$item_qty = $_POST['quantity'][$r];
				$unit_price_item = $_POST['price'][$r];
				$item_affect_price = 0;
				$item_non_affected_price = 0;
				$item_exonerated_price = 0;
				$item_gratuito_price = 0;

				$item_affect_price = $_POST['affect_price'][$r];
				$item_non_affected_price = $_POST['non_affected_price'][$r];
				$item_exonerated_price = $_POST['exonerated_price'][$r];
				$item_gratuito_price = $_POST['gratuito_price'][$r];


				$tax_method = $_POST['tax_method'][$r];

				$tipo_afectacion = $_POST['tipo_afectacion'][$r];

				$real_unit_price = $_POST['real_unit_price'][$r];
				$cost = $_POST['cost'][$r];
				$name = $_POST['name'][$r];
				$code = $_POST['code'][$r];



				//Operaciones
				if ($ICBPER["tax_icbper"] > 0) {
					$tax_ICBPER = $_POST['value_ICBPER'][$r];

					if ($tax_ICBPER == 1) {

						if ($mult_ICBPER['amount'] > 0) {
							$quantity_ICBPER = (int)(round($item_qty));
						} else {

							$quantity_ICBPER = 0;
						}

						if ($quantity_ICBPER > 0) {
							$unit_price_ICBPER = $mult_ICBPER['amount'];
							$valor_item_ICBPER = $mult_ICBPER['amount'] * round($item_qty);
						} else {
							$unit_price_ICBPER = 0;
							$valor_item_ICBPER = 0;
						}
					} else {
						$unit_price_ICBPER = 0;
						$valor_item_ICBPER = 0;
						$quantity_ICBPER = 0;
					}
				} else {
					$unit_price_ICBPER = 0;
					$valor_item_ICBPER = 0;
					$quantity_ICBPER = 0;
				}

				$total_ICBPER = $total_ICBPER + $valor_item_ICBPER;

				if ($item_id && $item_qty && $unit_price) {



					$pr_item_tax = 0;
					$item_afec = 0;
					$item_tax = 0;
					$tax_gratuito = 0;
					$item_tax_gratuito = 0;
					$item_exon = 0;
					$item_exoReal = 0;
					$item_gratuito = 0;
					$p_igv = $settings_tax;

					if (isset($settings_tax) && $settings_tax != 0) {

						$item_afec = $item_affect_price / (1 + ($settings_tax / 100));
						$item_tax = $item_affect_price - $item_afec;
						$item_exoReal = $item_exonerated_price;
						$item_exon = $item_non_affected_price;
						$item_gratuito = $item_gratuito_price;
						if ($tipo_afectacion == 0 || $tipo_afectacion == 1) { //AFECTO
							$p_igv = $settings_tax;
							$bool_afecto = true;
						} else if ($tipo_afectacion == 2 || $tipo_afectacion == 3 || $tipo_afectacion == 5) { // 2=INAFECTO 3= exonerado 4=Gratuito
							$p_igv = 0;
						} else if ($tipo_afectacion == 4) {
							$item_gratuito = $item_gratuito_price;
							$tax_gratuito = $item_gratuito * ($settings_tax / 100);
							$p_igv = $settings_tax;
						}
						$pr_item_tax = round($item_tax, 4) * $item_qty;
						$item_tax_gratuito = round($tax_gratuito, 4) * $item_qty;
					}


					$subtotal = (($item_affect_price + $item_exoReal + $item_exon) * $item_qty) + $valor_item_ICBPER; //$item_price * $item_qty;
					$prr_discount = 0;

					if ($code == "") {
						$item_id = null;
					}

					$unit_price_item = (float)$item_affect_price + (float)$item_non_affected_price + (float)$item_exonerated_price + (float)$item_gratuito_price;

					$products[] = array(
						'product_id' => $item_id,
						'code' => $code,
						'name' => $name,
						'quantity' => $item_qty,
						'unit_price' => $unit_price_item,
						'affect_price' => round($item_affect_price - $item_tax, 4),
						'non_affected_price' => round($item_non_affected_price, 4),
						'exonerated_price' => round($item_exonerated_price, 4),
						'gratuito_price' => round($item_gratuito_price, 4),

						'price_affected_item' => round((round($item_affect_price - $item_tax, 4)) * $item_qty, 4),
						'price_no_affected_item' => round($item_non_affected_price * $item_qty, 4),
						'price_exonerated_item' => round($item_exonerated_price * $item_qty, 4),
						'price_gratuito_item' => round($item_gratuito_price * $item_qty, 4),

						'discount' => "",
						'item_discount' => 0.00,
						'prr_discount' => round($prr_discount, 4),
						'tax' => round($item_tax, 4),
						'item_tax' => round($pr_item_tax, 4),
						'tax_gratuito' => round($tax_gratuito, 4),
						'item_tax_gratuito' => round($item_tax_gratuito, 4),
						'igv' => $p_igv,
						'tax_ICBPER' => $valor_item_ICBPER,
						'quantity_ICBPER' => $quantity_ICBPER,
						'subtotal' => $subtotal,
						'real_unit_price' => $this->tec->formatDecimal($real_unit_price),
						'cost' => $this->tec->formatDecimal($cost),
						'tax_method' => (int)$tax_method,
						'type_of_affectation' => (int)$tipo_afectacion
					);


					$total += (((float)$item_affect_price + (float)$item_non_affected_price + (float)$item_exonerated_price) * $item_qty);


					$total_item_affect += (float)$item_affect_price * $item_qty;
					$total_item_non_affected += (float)$item_non_affected_price * $item_qty;
					$total_item_exonerated += (float)$item_exonerated_price * $item_qty;

					log_message("error", $subtotal);

					$sub_total += $subtotal;

					$bruto_affecto_igv +=  (($item_afec + $item_tax) * $item_qty);


					$affected += (round($item_afec, 4) * $item_qty);
					$tax += $pr_item_tax;

					//
					$totalaffect = $affected;
					$totaltax = $tax;



					if ($item_exon > 0) {
						$exonerated += ($item_exon * $item_qty);
					} else {
						$exonerated += ($item_exon * $item_qty);
					}

					if ($item_exoReal > 0) {
						$exoneradoReal += ($item_exoReal * $item_qty);
					} else {
						$exoneradoReal += ($item_exoReal * $item_qty);
					}

					$gratuito += $item_gratuito * $item_qty;
					$tax_gratuito_total += $item_tax_gratuito;

					$count = $count + 1;
					$countt += $item_qty;
				}
			}

			if (!isset($products) || empty($products)) {
				$this->form_validation->set_rules('product', lang("order_items"), 'required');
			}

			if ($this->form_validation->run() == true) {

				// $sub_total = $affected + $exonerated + $tax + $exoneradoReal + $total_ICBPER;
				$grand_subtotal = $total + $total_ICBPER; //$total - $discount;

				$supplier_values = (array)$this->suppliers_model->getSupplierByID($this->input->post('supplier'));

				if ($discount > 0) {
					$p_igv = $settings_tax;
					$totalaffect = $totalaffect - $discount;
					$totaltax = $totalaffect * ($p_igv / 100);


					$total = $totalaffect + $total_item_non_affected + $total_item_exonerated + $totaltax;
					$grand_subtotal = $total + $total_ICBPER;
				}

				$data = array(
					"business_information" => array(
						"ruc_number" => $this->session->userdata('ruc')
					),
					'issuance_date' => $this->input->post('date'), //fecha de amision
					'num_purchase_order' => $id,
					'supplier_id' => $this->input->post('supplier'),
					'supplier_name' => $supplier_values['name'],
					'supplier_ruc' => $supplier_values['cf1'],
					'currency' => $this->input->post('currency_code'), // codigo de moneda
					'exchange' => 0, //tipo de cambio
					'affected' => round($totalaffect, 4), //monto afecto a igv
					'non_affected' => round($exonerated, 4), // monto inafecto
					'gratuito' => round($gratuito, 4), //monto exonerado 
					'tax_gratuito' => round($tax_gratuito_total, 4), //monto exonerado 
					'exonerated' => round($exoneradoReal, 4), //monto exonerado 
					'product_discount' => 0,
					'order_discount_percentage' => 0,
					'order_discount_percentage_value' => 0,
					'order_discount_no_percentage_value' => $discount,
					'total_discount' => $discount,
					'product_tax' => round($totaltax, 4),
					'order_tax_id' => "",
					'order_tax' => 0,
					'total_tax' => round($totaltax, 4),
					'tax_ICBPER' => $total_ICBPER,
					'mult_ICBPER' => $mult_ICBPER['amount'],
					'total_quantity' => $countt,
					'total_items' => $count,
					'subtotal' => round($sub_total, 4),
					'total' => $total + $total_ICBPER,
					'grand_total' => round($grand_subtotal, 4),
					'note' => $this->input->post('note', true),
					'rounding' => 0,
					'attachment' => "",
					'expiration_date' => $this->input->post('expiration_date') ? $this->input->post('expiration_date') : null, // fecha de experacion
					'canal_id' => 2,
					'payment_method_id' => 1, // identificacion del metodo de pago 1= contado 2= credito
					'num_quotation' => 0,
					'supplier_contact_name' => "",
					'destination_address' => "",
					'destination_ubigeo' => "",
					'supplier_address' => $supplier_values['cf2'],
					'supplier_contact_phone' => $supplier_values['phone'],
					'supplier_contact_email' => $supplier_values['email'],
					'estado' => $estado,
					'items' => $products,

				);



				$url = $this->config->item('api_compras');
				$url = $url . "purchase_order/" . $id;



				$curl = curl_init();

				curl_setopt_array(
					$curl,
					array(
						CURLOPT_URL => $url,
						CURLOPT_RETURNTRANSFER => true,
						CURLOPT_ENCODING => '',
						CURLOPT_MAXREDIRS => 10,
						CURLOPT_TIMEOUT => 0,
						CURLOPT_FOLLOWLOCATION => true,
						CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						CURLOPT_CUSTOMREQUEST => 'PUT',
						CURLOPT_POSTFIELDS => json_encode($data),
						CURLOPT_HTTPHEADER => array(
							'Content-Type: application/json'
						),
					)
				);
			}

			$response = curl_exec($curl);
			curl_close($curl);
			$res = json_decode($response, true);

			log_message("error", json_encode($data));
		}

		if ($this->form_validation->run() && isset($res)) {


			if (empty($res)) {

				if ($this->input->is_ajax_request()) {
					echo json_encode(array('status' => 'failed', 'msg' => 'No se pudo agregar la orden de compra,', 'data' => $res));

					die();
				}

				$this->session->set_flashdata('form_data', $_POST);
				$this->session->set_flashdata('error', 'No se pudo agregar la orden de compra.');
				redirect("purchase_orders/edit/$id");
			} else {

				if ($res['result'] == 'ok') {
					$this->session->set_flashdata('message', $res['message']);

					$this->recreate_pdf($id);
					redirect("purchase_orders");
				} else {

					$dataError = [];
					if (is_array($res['message'])) {
						foreach ($res['message'] as $key => $value) {
							for ($i = 0; $i < count($res['message'][$key]); $i++) {
								array_push($dataError, $res['message'][$key][$i]);
							}
						}
					} else {
						array_push($dataError, $res['message']);
					}

					$this->session->set_flashdata('error', str_replace(',', '<br/>', implode(',', $dataError)));
					$this->session->set_flashdata('form_data', $_POST);
					redirect("purchase_orders/edit/$id");
				}
			}
		} else {

			$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

			$advSale = (array)$this->site->getAdvanced_sale();
			$this->data['advance_sale'] = $advSale['advanced_sale'];

			$seting_bags = $this->pos_model->consult_plastic_bags();


			if ($seting_bags->tax_icbper == 0) {
				$this->data['plastic_bags'] = 0;
			} else {
				$consul_bags = $this->pos_model->consult_plastic_bags_type($seting_bags->tax_icbper);
				$this->data['plastic_bags'] = $consul_bags->amount;
			}

			if ($this->input->is_ajax_request()) {
				echo json_encode(array('status' => 'failed', 'msg' => validation_errors()));

				die();
			}

			$this->data['purchase_orders'] = $this->get_purchase_orders_byid($id);

			$purchase_orders = $this->get_purchase_orders_byid($id);
			$data['purchase_orders'] = $purchase_orders;

			$c = rand(100000, 9999999);

			foreach ($purchase_orders['items'] as $item) {
				$row = $this->site->getProductByID($item['product_id']);
				$row->productID = $item['product_id'];
				$row->price = $item['unit_price'];
				$row->qty = intval($item['quantity']);
				$row->code = $item['code'];
				$row->tax_ICBPER = $item['quantity_ICBPER'];
				$row->name = $item['name'];
				$row->tax_method = $item['tax_method'];
				$row->subtotal = $item['subtotal'];
				$row->affect_price = $item['affect_price'];
				$row->non_affected_price = $item['non_affected_price'];
				$row->exonerated_price = $item['exonerated_price'];
				$row->gratuito_price = $item['gratuito_price'];
				$row->tipo_afectacion = $item['type_of_affectation'];;
				$row->price_affected_item = $item['price_affected_item'];
				$row->price_no_affected_item = $item['price_no_affected_item'];
				$row->price_exonerated_item = $item['price_exonerated_item'];
				$row->price_gratuito_item = $item['price_gratuito_item'];
				$row->discount = $purchase_orders['order_discount_no_percentage_value'];

				$ri = $this->Settings->item_addition ? $row->id : $c;
				$pr[$ri] = array('id' => $ri, 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row);
				$c++;
			}

			$this->data['items'] = $pr;

			$this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
			$this->data['form_data'] = $this->session->flashdata('form_data');
			$this->data['suppliers'] = $this->site->getAllSuppliers();
			$this->data['page_title'] = lang('edit_purchase_order');
			$bc = array(array('link' => site_url('purchase_order'), 'page' => lang('purchase_order')), array('link' => '#', 'page' => lang('edit_purchase_order')));
			$meta = array('page_title' => lang('edit_purchase_order') . " - N°" . $id, 'bc' => $bc);
			$this->page_construct('purchase_orders/edit', $this->data, $meta);
		}
	}

	function delete($id = NULL)
	{
		if ($this->input->get('id')) {
			$id = $this->input->get('id', TRUE);
		}
		//obtener el numero el registro a editar
		$data = array(
			"business_information" => array(
				"ruc_number" => $this->session->userdata('ruc')
			)
		);
		$context = stream_context_create(
			array(
				'http' => array(
					'method' => 'DELETE',
					'header' => "Authorization: application/json\r\n" .
						"Content-Type: application/json\r\n",
					"content" => json_encode($data)
				)
			)
		);
		$url = $this->config->item('api_compras');
		$url = $url . "purchase_order/" . $id;
		$response = file_get_contents($url, false, $context);
		$res = json_decode($response, true);

		if ($res['result'] == 'ok') {
			$this->session->set_flashdata('message', $res['message']);
			redirect("purchase_orders");
		}
	}


	function supplier($id = null)
	{

		$purchase_orders = $this->get_purchase_orders_byid($id);
		$data['purchase_orders'] = $purchase_orders;

		$this->load->view($this->theme . 'purchase_orders/supplier', $data);
	}

	function change_estado($id = null)
	{
		if ($this->input->get('id')) {
			$id = $this->input->get('id', TRUE);
		}
		//obtener el numero el registro a editar
		$data = array(
			"business_information" => array(
				"ruc_number" => $this->session->userdata('ruc')
			)
		);
		$context = stream_context_create(
			array(
				'http' => array(
					'method' => 'DELETE',
					'header' => "Authorization: application/json\r\n" .
						"Content-Type: application/json\r\n",
					"content" => json_encode($data)
				)
			)
		);
		$url = $this->config->item('api_compras');
		$url = $url . "purchase_order/change_estado/" . $id;
		$response = file_get_contents($url, false, $context);
		$res = json_decode($response, true);

		if ($res['result'] == 'ok') {
			$this->session->set_flashdata('message', $res['message']);
			redirect("purchase_orders");
		}
	}

	function view_order($id = null)
	{

		$purchase_orders = $this->get_purchase_orders_byid($id);
		$this->data['purchase_orders'] = $purchase_orders;


		$this->load->view($this->theme . 'purchase_orders/view_order', $this->data);
	}

	function downloadPDF($id = null)
	{
		$ruta = '/uploads/pdf/ordenes_de_compra/';
		$rutaArchivo = $ruta . $id . ".pdf";

		// Directorio raíz de tu proyecto
		$raiz = dirname(__DIR__);

		// Encontrar la posición de '/app' en la ruta raíz
		$pos = strripos($raiz, '\app');

		// Obtener la ruta raíz del proyecto
		$file_raiz = substr($raiz, 0, $pos);

		// Construir la ruta completa del archivo
		$filePath = $file_raiz . $rutaArchivo;

		if (file_exists($filePath)) {
			header("Cache-Control: public");
			header("Content-Description: File Transfer");
			header("Content-Disposition: attachment; filename=$id.pdf"); // Modified line
			header("Content-Type: application/PDF");
			header("Content-Transfer-Encoding: binary");

			readfile($filePath);
			exit;
		} else {
			$this->session->set_flashdata('error', "No se encontró el archivo PDF.");
			redirect('purchase_orders');
		}
	}

	function deletePDF($id = null)
	{

		$ruta = '/uploads/pdf/ordenes_de_compra/';
		$rutaArchivo = $ruta . $id . ".pdf";

		// Directorio raíz de tu proyecto
		$raiz = dirname(__DIR__);

		// Encontrar la posición de '/app' en la ruta raíz
		$pos = strripos($raiz, '\app');

		// Obtener la ruta raíz del proyecto
		$file_raiz = substr($raiz, 0, $pos);

		// Construir la ruta completa del archivo
		$filePath = $file_raiz . $rutaArchivo;

		if (file_exists($filePath)) {
			// Eliminar el archivo
			unlink($filePath);
			return true; // Retorna verdadero si se eliminó con éxito
		} else {
			return false; // Retorna falso si el archivo no existe
		}
	}

	function recreate_pdf($id = null)
	{

		if ($this->generar_pdf($id)) {

			redirect('purchase_orders');
		} else {

			redirect('purchase_orders');
		}
	}

	function generar_pdf1($id = null)
	{

		$purchase_orders = $this->get_purchase_orders_byid($id);


		$quantity1 = "";
		$code1 = "";
		$nombreProducto1 = "";
		$icbper1 = "";
		$uprice1 = "";
		$subt1 = "";

		foreach ($purchase_orders['items'] as $item) {
			$quantity = $this->tec->formatNumber($item['quantity']);
			$uprice = $this->tec->formatMoney($item['unit_price']);
			$icbper = $this->tec->formatMoney($item['tax_ICBPER']);
			$subt = $this->tec->formatMoney($item['subtotal']);
			$nombreProducto = str_replace("<", "&lt;", $item['name']);
			$nombreProducto = str_replace(">", "&gt;", $nombreProducto);
			$code = $item['code'];

			$quantity1 .= $quantity . '<br><br>'; //acumulador de la lista de cantidades
			$code1 .= $code . '<br><br>'; //acumulador de la lista de codigos de los productos
			$nombreProducto1 .= $nombreProducto . '<br><br>'; //nombre del producto
			$icbper1 .= $icbper . '<br><br>'; //precio unitario
			$uprice1 .= $uprice . '<br><br>'; //precio unitario
			$subt1 .= $subt . '<br><br>'; //sub total                 
		}

		$row_items_html = '    
        <td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $quantity1 . '</td>
        <td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $code1 . '</td>
        <td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $nombreProducto1 . '</td>
		<td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $icbper1 . '</td>
        <td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $uprice1 . '</td>
		<td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $subt1 . '</td>';

		$fecha_emision = $purchase_orders['issuance_date'];
		$fecha_fin = $purchase_orders['expiration_date'];

		$supplier_name = $purchase_orders['supplier_name'];
		$supplier_ruc = $purchase_orders['supplier_ruc'];
		$supplier_phone = $purchase_orders['supplier_contact_phone'];
		$supplier_email = $purchase_orders['supplier_contact_email'];
		$supplier_address = $purchase_orders['supplier_address'];
		$currency = $purchase_orders['currency'];

		$impRuc = '<br>
		<table border="1" width="100%" cellspacing="0" cellpadding="" >
		<tr>
    	<td bgcolor="#1B3752" align="center" width="100%" style="font-size:10px;color: #fefeff; vertical-align: middle;">
        <strong style="font-size:7px;color: #fefeff">' . strtoupper(lang('applicant_dates')) . '</strong>
    	</td>
		</tr>

		<tr>
			<td align="left" width="10%" style="font-size:8px"> ' . lang('name') . ':</td>
			<td align="left" width="40%" style="font-size:8px"> ' . $this->Settings->site_name . '</td>
			<td align="left" width="10%" style="font-size:8px"> ' . lang('ruc') . ':</td>
			<td align="left" width="40%" style="font-size:8px"> ' . $this->Settings->ruc . '</td>
		</tr>
		<tr>
			<td align="left" width="10%" style="font-size:8px"> ' . lang('phone') . ':</td>
			<td align="left" width="40%" style="font-size:8px"> ' . $this->Settings->tel . '</td>
			<td align="left" width="10%" style="font-size:8px"> ' . lang('email') . ':</td>
			<td align="left" width="40%" style="font-size:8px"> ' . $this->Settings->mail_incidents . '</td>
		</tr>
		<tr>
			<td align="left" width="50%" style="font-size:8px">' . lang('direcc_entr') . ':</td>
			<td align="left" width="50%" style="font-size:8px"> ' . $this->Settings->direccion . '</td>
		</tr>

		</table>

	<table border="1" width="100%" cellspacing="0" cellpadding="" >
		<tr>
    	<td bgcolor="#1B3752" align="center" width="100%" style="font-size:10px;color: #fefeff; vertical-align: middle;">
        <strong style="font-size:7px;color: #fefeff">' . strtoupper(lang('supplier_info')) . '</strong>
    	</td>
		</tr>

		<tr style="font-size:10px;color:>
			<td align="left" width="10%" style="font-size:8px"> ' . lang('supplier') . ':</td>
			<td align="left" width="40%" style="font-size:8px"> ' . $supplier_name . '</td>
			<td align="left" width="10%" style="font-size:8px"> ' . lang('ruc') . ':</td>
			<td align="left" width="40%" style="font-size:8px"> ' . $supplier_ruc . '</td>
		</tr>
		<tr>
			<td align="left" width="10%" style="font-size:8px"> ' . lang('phone') . ':</td>
			<td align="left" width="40%" style="font-size:8px"> ' . $supplier_phone . '</td>
			<td align="left" width="10%" style="font-size:8px"> ' . lang('email') . ':</td>
			<td align="left" width="40%" style="font-size:8px"> ' . $supplier_email . '</td>
		</tr>
		<tr>
			<td align="left" width="50%" style="font-size:8px">' . lang('direcc_sali') . ':</td>
			<td align="left" width="50%" style="font-size:8px"> ' . $supplier_address . '</td>
		</tr>

	</table>

	
	<br>
						<br>';

		$sub = $this->tec->formatMoney($purchase_orders['subtotal']);
		$desc = $this->tec->formatMoney($purchase_orders['order_discount']); //(-$inv['rounding']) +
		$afc = $this->tec->formatMoney($purchase_orders['affected']);
		$exo = $this->tec->formatMoney($purchase_orders['non_affected']);
		$tax_ICBPER = $this->tec->formatMoney($purchase_orders['tax_ICBPER']); //***************TRJ068 - ALEXANDER ROCA - 13/08/2019********************
		$exoReal = $this->tec->formatMoney($purchase_orders['exonerated']); //****************TRJ008 - ALEXANDER ROCA  - 11/04/2019**********
		$igv = $this->tec->formatMoney($purchase_orders['total_tax']);
		$grat = $this->tec->formatMoney(0);
		$tot1 = $this->tec->formatMoney($purchase_orders['amount']);
		$round = $this->tec->formatMoney($purchase_orders['rounding']);
		$tot2 = $this->tec->formatMoney($purchase_orders['grand_total']);
		$ICBPER = $this->tec->formatMoney($purchase_orders['tax_ICBPER']);
		$descuento = $this->tec->formatMoney($purchase_orders['total_discount']);

		$totLetras = strtoupper($purchase_orders['grand_total'] . " " . $currency);
		$tipo_doc = lang('purchase_order') . " N°" . $id;

		$this->load->library('Pdf');

		$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
		$pdf->SetTitle($tipo_doc);
		$pdf->SetHeaderMargin(30);
		$pdf->SetTopMargin(20);
		$pdf->setFooterMargin(20);
		$pdf->SetAutoPageBreak(true);
		$pdf->SetAuthor('Author');
		$pdf->SetDisplayMode('real', 'default');

		$pdf->AddPage();

		$ivPorc = $this->Settings->default_tax_rate;


		//traducciones
		$l_subtotal = strtoupper(lang('subtotal')) . ':';
		$l_opgravada = lang('opgrav') . ':';
		$l_inafecto = lang('opexon') . ':';
		$l_exonerada = lang('opexonReal') . ':';
		$l_gratuita = lang('opfree') . ':';
		$l_importe_total = strtoupper(lang('importe') . " " . lang('total') . ':');
		$l_descuento = strtoupper(lang('total_discount'));

		$ruc = $this->session->userdata('ruc');
		$direccion = $this->session->userdata('direccion');
		$region = $this->session->userdata('region');
		$pais = $this->session->userdata('pais');
		$region_pais = strtoupper($region . " - " . $pais);
		$imagen = $this->session->userdata('logo');
		$pos_logo = $this->session->userdata('pos_logo');
		//****************TRJ030 - RENATO GAMONAL*******************
		$imagen2 = $this->session->userdata('logo_pdf');
		$type_imagen_pdf = $this->session->userdata('type_imagen_pdf');
		//****************TRJ030 - RENATO GAMONAL*******************

		$width = 334;
		$height = 102;

		if ($pos_logo == 2) {
			$width = 334;
			$height = 102;
		} else if ($pos_logo == 1) {
			$width = 84;
			$height = 102;
		}

		$_ruc = "RUC" . ". " . $ruc;

		$cabecera = '<img class="aligncenter" src="' . base_url('uploads/' . $imagen2) . '" width="' . $width . '" height="' . $height . '">';


		$rowspan = 9;

		$tbl1 = <<<EOD
	<table  width="100%" cellspacing="0" cellpadding="2" >
		<tr>
			<td width="70%" align="center" style="font-size:10px">
			$cabecera
			</td>
			<td width="30%" valign="middle"><br><br><br>
				<table border="0.5" width="100%" cellspacing="0" cellpadding="8" >
					<tr>
						<td align="center"  style="font-size:10px"><h2 style="font-size:8px">$_ruc</h2></td>
					</tr>
					<tr>
						<td align="center" bgcolor="#E4E4E4" style="font-size:10px"><h2 style="font-size:8px">$tipo_doc</h2></td>
					</tr>
				</table><br>
			</td>
		</tr>
	</table>
	<br>
	<table border="1" width="100%" cellspacing="0" cellpadding="" >
	<tr>
    <td bgcolor="#1B3752" align="center" width="50%" style="font-size:10px;color: #fefeff; vertical-align: middle;">
        <strong style="font-size:7px;color: #fefeff">FECHA DE EMISION</strong>
    </td>
    <td bgcolor="#1B3752" align="center" width="50%" style="font-size:10px;color: #fefeff; vertical-align: middle;">
        <strong style="font-size:7px;color: #fefeff">FECHA DE VENCIMIENTO</strong>
    </td>
	</tr>


		<tr>
			<td align="center" style="font-size:8px">$fecha_emision</td>
			<td align="center" style="font-size:8px">$fecha_fin</td>
		</tr>

	</table><br>

	$impRuc
	
	<br>
	
	<table width="100%" cellspacing="0" style="vertical-align: middle;" >
	<tr height="30">

		<td bgcolor="#1B3752" align="center" width="8%" style="font-size:7px;color: #fefeff;border: 1px solid #000000;"><strong>CANTIDAD</strong></td>
		<td bgcolor="#1B3752" align="center" width="11%" style="font-size:7px;color: #fefeff;border: 1px solid #000000;"><strong>CODIGO</strong></td>
		<td bgcolor="#1B3752" align="center" width="51%" style="font-size:7px;color: #fefeff;border: 1px solid #000000;"><strong>DESCRIPCION</strong></td>
		<td bgcolor="#1B3752" align="center" width="9.5%" style="font-size:7px;color: #fefeff;border: 1px solid #000000;"><strong>OP. ICBPER</strong></td>
		<td bgcolor="#1B3752" align="center" width="11.5%" style="font-size:7px;color: #fefeff;border: 1px solid #000000;"><strong>PRECIO UNITARIO</strong></td>
		<td bgcolor="#1B3752" align="center" width="9%" style="font-size:7px;color: #fefeff;border: 1px solid #000000;"><strong>IMPORTE</strong></td>
	
	</tr>
	
    <tr>
    $row_items_html
    </tr>
		<tr>
			<td colspan="4" rowspan="$rowspan" style="font-size:9px;"><br>SON: $totLetras</td>
			<td colspan="1" align="left" style="font-size:6px;border: 1px solid #000000">$l_subtotal</td>
			<td colspan="1" align="right"  style="font-size:8px;border: 1px solid #000000">$sub</td>
		</tr>
		<tr>
			<td colspan="1" align="left"  style="font-size:6px;border: 1px solid #000000">TOT.DESC</td>
			<td colspan="1" align="right"  style="font-size:8px;border: 1px solid #000000">$descuento</td>
		</tr>
		<tr>
			<td colspan="1" align="left"  style="font-size:6px;border: 1px solid #000000">$l_opgravada</td>
			<td colspan="1" align="right"  style="font-size:8px;border: 1px solid #000000">$afc</td>
		</tr>
		<tr>
			<td colspan="1" align="left"  style="font-size:6px;border: 1px solid #000000">$l_inafecto</td>
			<td colspan="1" align="right"  style="font-size:8px;border: 1px solid #000000">$exo</td>
		</tr>
		<tr>
			<td colspan="1" align="left" style="font-size:6px;border: 1px solid #000000">$l_exonerada</td>
			<td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">$exoReal</td>
		</tr>
		<tr>
			<td colspan="1"  align="left" style="font-size:6px;border: 1px solid #000000">$l_gratuita</td>
			<td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">$grat</td>
		</tr>
		<tr>
			<td colspan="1"  align="left" style="font-size:6px;border: 1px solid #000000">OP. ICBPER</td>
			<td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">$ICBPER</td>
		</tr>
		<tr>
			<td colspan="1"  align="left" style="font-size:6px;border: 1px solid #000000">I.G.V-$ivPorc %</td>
			<td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">$igv</td>
    	</tr>

		<tr>
			<td colspan="1"  align="left" style="font-size:6px;border: 1px solid #000000">$l_importe_total</td>
			<td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">$tot2</td>
		</tr>
	</table>    
	
	<br>
    <br>
	<br>
    <!-- Espacio para firma -->
    <table width="100%" cellspacing="0" cellpadding="2">
        <tr>
            <td colspan="2" align="center" style="font-size:10px;">__________________________</td>
        </tr>
        <tr>
            <td colspan="2" align="center" style="font-size:10px;">Autorizado por:</td>
        </tr>
    </table>

EOD;


		$pdf->writeHTML($tbl1, true, false, false, false, '');

		$pdf->Output(FCPATH . 'uploads/pdf/ordenes_de_compra'  . '/' . $id . '.pdf', 'F');

		$file_path = FCPATH . 'uploads/pdf/ordenes_de_compra'  . '/' . $id . '.pdf';

		$success = $pdf->Output($file_path, 'F');

		if ($success === true) {

			return false;
		} else {

			return true;
		}
	}

	function generar_pdf($id = null)
	{

		$purchase_orders = $this->get_purchase_orders_byid($id);
		//Idioma ---------------
		$region = $this->session->userdata('region');
		$l_ruc = lang("ccf2");
		$arrMes = lang("months");
		$l_qty = lang("qty");
		$l_description = lang("description");
		$l_importe = lang("importe");
		$l_currency = lang("currency_name");
		$op_free = lang("op_free");
		$op_ICBPER = lang('product_tax_ICBPER') . ' (' . lang('tax_ICBPER') . ')';
		$l_forma_pago = lang("forma_pago");
		$l_subtotal = strtoupper(lang('subtotal')) . ':';
		$l_opgravada = lang('opgrav') . ':';
		$l_inafecto = lang('opexon') . ':';
		$l_exonerada = lang('opexonReal') . ':';
		$l_gratuita = lang('opfree') . ':';
		$l_importe_total = strtoupper(lang('importe') . " " . lang('total') . ':');

		$this->load->library('Pdf');



		$fecha_emision = $purchase_orders['issuance_date'];
		$fecha_fin = $purchase_orders['expiration_date'];

		$symbol = "";
		$currency = "";

		$fecha_actual = date("Y-m-d"); // Obtiene la fecha actual en formato Año-Mes-Día

		// Separa la fecha en componentes de día, mes y año
		$arrFecha = explode("-", $fecha_actual);
		$año_actual = $arrFecha[0];
		$mes_actual = $arrFecha[1];
		$dia_actual = $arrFecha[2];

		$ano = $año_actual;
		$dia = $dia_actual;
		$mes = $mes_actual;

		$row_items_html = "";
		$row_items_html_names = "";
		foreach ($purchase_orders['items'] as $item) {

			$item = (array)$item;

			$quantity = $this->tec->formatNumber($item['quantity']);
			$uprice = $this->tec->formatMoney($item['unit_price']);
			$subt = $this->tec->formatMoney($item['subtotal']);
			$icbper = $this->tec->formatMoney($item['tax_ICBPER']);
			$nombreProducto = str_replace("<", "&lt;", $item['name']);
			$nombreProducto = str_replace(">", "&gt;", $nombreProducto);
			$code = $item['code'];

			if ($icbper > 0) {
				// Si es mayor que 0, mostramos el bloque HTML con $icbper
				$row_items_html .= '<tr>
									<td align="center" style="font-size:10px">' . $quantity . '</td>
									<td align="center" style="font-size:10px">' . $code . '</td>
									<td align="left" style="font-size:10px">' . $nombreProducto . '</td>
									<td align="center" style="font-size:10px">' . $icbper . '</td>
									<td align="right" style="font-size:10px">' . $uprice . '</td>
									<td align="right" style="font-size:10px">' . $subt . '</td>
								</tr>';
			} else {
				// Si no es mayor que 0, mostramos el bloque HTML sin $icbper
				$row_items_html .= '<tr>
									<td align="center" style="font-size:10px">' . $quantity . '</td>
									<td align="center" style="font-size:10px">' . $code . '</td>
									<td align="left" style="font-size:10px">' . $nombreProducto . '</td>
									<td align="right" style="font-size:10px">' . $uprice . '</td>
									<td align="right" style="font-size:10px">' . $subt . '</td>
									</tr>';
			
			}

		}
		if ($icbper > 0) {
			// Si es mayor que 0, mostramos el bloque HTML con $icbper

			$row_items_html_names .= '  <td bgcolor="#E4E4E4" align="center" width="8%" style="font-size:7px; vertical-align: middle;"><strong>CANTIDAD</strong></td>
										<td bgcolor="#E4E4E4" align="center" width="11%" style="font-size:7px; vertical-align: middle;"><strong>CODIGO</strong></td>
										<td bgcolor="#E4E4E4" align="center" width="51%" style="font-size:7px; vertical-align: middle;"><strong>DESCRIPCION</strong></td>
										<td bgcolor="#E4E4E4" align="center" width="11.5%" style="font-size:7px; vertical-align: middle;"><strong>OP. ICBPER</strong></td>
										<td bgcolor="#E4E4E4" align="center" width="9.5%" style="font-size:7px; vertical-align: middle;"><strong>PRECIO UNITARIO</strong></td>
										<td bgcolor="#E4E4E4" align="center" width="9%" style="font-size:7px; vertical-align: middle;"><strong>IMPORTE</strong></td>';
		} else {

			$row_items_html_names .= '  <td bgcolor="#E4E4E4" align="center" width="10%" style="font-size:7px; vertical-align: middle;"><strong>CANTIDAD</strong></td>
										<td bgcolor="#E4E4E4" align="center" width="15%" style="font-size:7px; vertical-align: middle;"><strong>CODIGO</strong></td>
										<td bgcolor="#E4E4E4" align="center" width="45%" style="font-size:7px; vertical-align: middle;"><strong>DESCRIPCION</strong></td>
										<td bgcolor="#E4E4E4" align="center" width="15%" style="font-size:7px; vertical-align: middle;"><strong>PRECIO UNITARIO</strong></td>
										<td bgcolor="#E4E4E4" align="center" width="15%" style="font-size:7px; vertical-align: middle;"><strong>IMPORTE</strong></td>
			';				
		}

		$impRuc = '<table border="1" width="100%" cellspacing="0" cellpadding="2" align="left">
                        <tr>
                            <td bgcolor="#E4E4E4" align="left" width="50%"  style="font-size:10px"><strong> FECHA DE EMISION </strong></td>
                            <td align="left" width="50%"  style="font-size:10px"> ' . $fecha_emision . '</td>
                        </tr>
						<tr>
                                <td bgcolor="#E4E4E4" align="left" width="50%"  style="font-size:10px"><strong> FECHA DE VENCIMIENTO </strong></td>
                                <td align="left" width="50%"  style="font-size:10px"> ' . $fecha_fin . '</td>
                        </tr>
                    </table>';


		$supplier_name = $purchase_orders['supplier_name'];
		$supplier_ruc = $purchase_orders['supplier_ruc'];
		$supplier_phone = $purchase_orders['supplier_contact_phone'];
		$supplier_email = $purchase_orders['supplier_contact_email'];
		$supplier_address = $purchase_orders['supplier_address'];

		$applicantdates = '<table border="1" width="100%" cellspacing="0" cellpadding="2">
		<tr>
			<td bgcolor="#E4E4E4" align="center" width="100%"  style="font-size:10px"><strong>' . strtoupper(lang('applicant_dates')) . '</strong></td>
		</tr>
		<tr>
			<td align="left" width="10%" style="font-size:7px"> ' . strtoupper(lang('name')) . ':</td>
			<td align="left" width="40%" style="font-size:7px"> ' . $this->Settings->site_name . '</td>
			<td align="left" width="10%" style="font-size:7px"> ' . strtoupper(lang('ruc')) . ':</td>
			<td align="left" width="40%" style="font-size:7px"> ' . $this->Settings->ruc . '</td>
		</tr>
		<tr>
			<td align="left" width="10%" style="font-size:7px"> ' . strtoupper(lang('phone')) . ':</td>
			<td align="left" width="40%" style="font-size:7px"> ' . $this->Settings->tel . '</td>
			<td align="left" width="10%" style="font-size:7px"> ' . strtoupper(lang('email')) . ':</td>
			<td align="left" width="40%" style="font-size:7px"> ' . $this->Settings->mail_incidents . '</td>
		</tr>
		<tr>
			<td align="left" width="50%" style="font-size:7px">' . strtoupper(lang('direcc_entr')) . ':</td>
			<td align="left" width="50%" style="font-size:7px"> ' . $this->Settings->direccion . '</td>
		</tr>
		</table>';

		$supplierdates = '<table border="1" width="100%" cellspacing="0" cellpadding="2">
		<tr>
			<td bgcolor="#E4E4E4" align="center" width="100%"  style="font-size:10px"><strong>' . strtoupper(lang('supplier_info')) . '</strong></td>
		</tr>
		<tr>
			<td align="left" width="10%" style="font-size:7px"> ' . strtoupper(lang('supplier')) . ':</td>
			<td align="left" width="40%" style="font-size:7px"> ' . $supplier_name . '</td>
			<td align="left" width="10%" style="font-size:7px"> ' . strtoupper(lang('ruc')) . ':</td>
			<td align="left" width="40%" style="font-size:7px"> ' . $supplier_ruc . '</td>
		</tr>
		<tr>
			<td align="left" width="10%" style="font-size:7px"> ' . strtoupper(lang('phone')) . ':</td>
			<td align="left" width="40%" style="font-size:7px"> ' . $supplier_phone . '</td>
			<td align="left" width="10%" style="font-size:7px"> ' . strtoupper(lang('email')) . ':</td>
			<td align="left" width="40%" style="font-size:7px"> ' . $supplier_email . '</td>
		</tr>
		<tr>
			<td align="left" width="50%" style="font-size:7px">' . strtoupper(lang('direcc_entr')) . ':</td>
			<td align="left" width="50%" style="font-size:7px"> ' . $supplier_address . '</td>
		</tr>
		</table>
		';


		$sub = $this->tec->formatMoney($purchase_orders['subtotal']);
		$afc = $this->tec->formatMoney($purchase_orders['affected']);
		$exo = $this->tec->formatMoney($purchase_orders['non_affected']);
		$exoReal = $this->tec->formatMoney($purchase_orders['exonerated']); //****************TRJ008 - ALEXANDER ROCA  - 11/04/2019**********
		$igv = $this->tec->formatMoney($purchase_orders['total_tax']);
		$grat = $this->tec->formatMoney(0);
		$ICBPER = $this->tec->formatMoney($purchase_orders['tax_ICBPER']);
		$descuento = $this->tec->formatMoney($purchase_orders['total_discount']);
		$currency = $purchase_orders['currency'];
		$tot2 = $this->tec->formatMoney($purchase_orders['grand_total']);
		$totLetras = strtoupper($purchase_orders['grand_total'] . " " . $currency);
		$tipo_doc = lang('purchase_order') . " N°" . $id;

		$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
		$pdf->SetTitle($tipo_doc . " - " . $numComp);
		$pdf->SetAutoPageBreak(true, 20);
		$pdf->SetHeaderMargin(30);
		$pdf->SetTopMargin(20);
		$pdf->setFooterMargin(40);
		$pdf->SetAutoPageBreak(true, 30);
		$pdf->SetAuthor('Author');
		$pdf->SetDisplayMode('real', 'default');

		$pdf->AddPage();

		$ivPorc = $this->Settings->default_tax_rate;

		$razon_social = $this->session->userdata('razon_social');
		$ruc = $this->session->userdata('ruc');
		$direccion = $this->session->userdata('direccion');
		$region = $this->session->userdata('region');
		$pais = $this->session->userdata('pais');
		$region_pais = strtoupper($region . " - " . $pais);
		$imagen = $this->session->userdata('logo');
		$pos_logo = $this->session->userdata('pos_logo');

		$imagen2 = $this->session->userdata('logo_pdf');
		$type_imagen_pdf = $this->session->userdata('type_imagen_pdf');


		$informacion = $purchase_orders['note'];


		if (!empty($informacion)) {
			$tableInfo = '<br><br>
        <table border="1" width="100%">
          <tr>
              <td bgcolor="#E4E4E4" align="center"  width="100%" style="font-size:8px"><strong>Información</strong></td>
          </tr>
          <tr>
              <td tyle="font-size:8px">' . ' ' . $informacion . '</td>
          </tr>
        </table>';
		} else {
			$tableInfo = "";
		}

		$width = 334;
		$height = 102;

		if ($pos_logo == 2) {
			$width = 334;
			$height = 102;
		} else if ($pos_logo == 1) {
			$width = 84;
			$height = 102;
		}

		$_ruc = $l_ruc . ". " . $ruc;

		if ($type_imagen_pdf == 1) {
			$cabecera = '<img class="aligncenter" src="' . base_url('uploads/' . $imagen) . '" width="' . $width . '" height="' . $height . '">';
			$cabecera2 = '<div><br>' . $razon_social . '<br>' . $direccion . '<br>' . $region_pais . '<br>' . $_ruc . ' </div>';
		} else if ($type_imagen_pdf == 2) {
			$width2 = 370;
			$height2 = 150;
			$cabecera = '<img class="aligncenter" src="' . base_url('uploads/' . $imagen2) . '" width="' . $width2 . '" height="' . $height2 . '">';
			$cabecera2 = "";
		}

		$tbl = <<<EOD
            <table border="0" width="100%" cellspacing="0" cellpadding="2" >
                <tr>
                    <td width="65%" align="center" style="font-size:10px">
                        $cabecera
						$cabecera2
                    </td>
                    <td width="35%" valign="middle"><br><br><br><br>
                        <table border="1" width="100%" cellspacing="0" cellpadding="2" >
                            <tr>
                                <td align="center"  style="font-size:10px"><h2>$_ruc</h2></td>
                            </tr>
                            <tr>
                                <td align="center" bgcolor="#E4E4E4" style="font-size:10px"><h2>$tipo_doc</h2></td>
                            </tr>
                        </table>
                    </td>
                </tr>

                <tr>
                    <td width="65%" align="left">

                        $impRuc

                    </td>

                    <td width="35%">

                        <table border="1" width="100%" cellspacing="0" cellpadding="2" >
                            <tr>
                                <td align="left" style="font-size:10px"> <u>$region</u> ,  <u>     $dia     </u>   de   <u>   $mes   </u>   del   <u>     $ano     </u> </td>
                            </tr>
                            <tr>
                                <td align="left"  style="font-size:10px"> $l_currency: $currency</td>
                            </tr>
                        
                        </table>	

                    </td>
                
					

				</tr>

				<tr>
				
				<td width="100%">

                    $applicantdates

                </td>

				</tr>

				<tr>
				
				<td width="100%">

                    $supplierdates

                </td>

				</tr>


            </table>

			
			
		
            <br><br>
    
                <br><br>

                <table border="1" width="100%" cellspacing="0" cellpadding="2">
    <tr>
		
	$row_items_html_names

    </tr> 
    $row_items_html
</table>

                <table border="0" width="100%" cellspacing="0" cellpadding="2" >
                    <tr>
                        <td align="left" style="font-size:10px">SON: $totLetras</td>
                    </tr>
                </table>
					
                	<table border="0" width="100%" cellspacing="0" cellpadding="2" >
                    <tr>
                        <td  width="70%" align="center">
						<br>
						<br>
						<br>
						<br>
						<br>
						<br>
						<br>
						<br>
						<table width="100%" cellspacing="0" cellpadding="2">
						
						<tr>
							<td colspan="2" align="center" style="font-size:10px;">__________________________</td>
						</tr>
						<tr>
							<td colspan="2" align="center" style="font-size:10px;">Autorizado por:</td>
						</tr>
					</table>
                        </td>

                        <td align="center" width="30%">

                        <br><br>

                        <table border="1" width="100%" cellspacing="0" cellpadding="2" >
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:8px"><strong>$l_subtotal</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$sub</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:8px"><strong>DESCUENTO</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$descuento</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:8px"><strong>$l_opgravada</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$afc</td>
                            </tr>
							<tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:8px"><strong>$l_inafecto</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$exo</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:8px"><strong>$l_exonerada</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$exoReal</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:8px"><strong>$l_gratuita</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$grat</td>
                            </tr>                  
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:8px"><strong>IGV - $ivPorc %</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$igv</td>
                            </tr>
							<tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:8px"><strong>OP. ICBPER</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$ICBPER</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:8px"><strong>$l_importe_total</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$tot2</td>
                            </tr>
                        </table>

                        </td>
                    </tr>
                </table>
                $tableInfo
                <br>
				
				
EOD;

		$pdf->writeHTML($tbl, true, false, false, false, '');

		$pdf->Output(FCPATH . 'uploads/pdf/ordenes_de_compra'  . '/' . $id . '.pdf', 'F');

		$file_path = FCPATH . 'uploads/pdf/ordenes_de_compra'  . '/' . $id . '.pdf';

		$success = $pdf->Output($file_path, 'F');

		if ($success === true) {

			return false;
		} else {

			return true;
		}
	}
}
