/*!
 * FormValidation (http://formvalidation.io)
 * The best jQuery plugin to validate form fields. Support Bootstrap, Foundation, Pure, SemanticUI, UIKit and custom frameworks
 * 
 * This is a custom build that does NOT consist of all validators. Only popular validators are included:
 * - between
 * - callback
 * - choice
 * - color
 * - creditCard
 * - date
 * - different
 * - digits
 * - emailAddress
 * - file
 * - greaterThan
 * - identical
 * - integer
 * - lessThan
 * - notEmpty
 * - numeric
 * - promise
 * - regexp
 * - remote
 * - stringLength
 * - uri
 *
 * Use formValidation(.min).js file if you want to have all validators.
 *
 * @version     v0.6.3, built on 2015-05-31 10:06:42 PM
 * @author      https://twitter.com/formvalidation
 * @copyright   (c) 2013 - 2015 Nguyen Huu Phuoc
 * @license     http://formvalidation.io/license/
 */
if (window.FormValidation = {
        AddOn: {},
        Framework: {},
        I18n: {},
        Validator: {}
    }, "undefined" == typeof jQuery) throw new Error("FormValidation requires jQuery");
! function (a) {
    var b = a.fn.jquery.split(" ")[0].split(".");
    if (+b[0] < 2 && +b[1] < 9 || 1 === +b[0] && 9 === +b[1] && +b[2] < 1) throw new Error("FormValidation requires jQuery version 1.9.1 or higher")
}(jQuery),
function (a) {
    FormValidation.Base = function (b, c, d) {
        this.$form = a(b), this.options = a.extend({}, a.fn.formValidation.DEFAULT_OPTIONS, c), this._namespace = d || "fv", this.$invalidFields = a([]), this.$submitButton = null, this.$hiddenButton = null, this.STATUS_NOT_VALIDATED = "NOT_VALIDATED", this.STATUS_VALIDATING = "VALIDATING", this.STATUS_INVALID = "INVALID", this.STATUS_VALID = "VALID", this.STATUS_IGNORED = "IGNORED", this._ieVersion = function () {
            for (var a = 3, b = document.createElement("div"), c = b.all || []; b.innerHTML = "<!--[if gt IE " + ++a + "]><br><![endif]-->", c[0];);
            return a > 4 ? a : !a
        }();
        var e = document.createElement("div");
        this._changeEvent = 9 !== this._ieVersion && "oninput" in e ? "input" : "keyup", this._submitIfValid = null, this._cacheFields = {}, this._init()
    }, FormValidation.Base.prototype = {
        constructor: FormValidation.Base,
        _exceedThreshold: function (b) {
            var c = this._namespace,
                d = b.attr("data-" + c + "-field"),
                e = this.options.fields[d].threshold || this.options.threshold;
            if (!e) return !0;
            var f = -1 !== a.inArray(b.attr("type"), ["button", "checkbox", "file", "hidden", "image", "radio", "reset", "submit"]);
            return f || b.val().length >= e
        },
        _init: function () {
            var b = this,
                c = this._namespace,
                d = {
                    addOns: {},
                    autoFocus: this.$form.attr("data-" + c + "-autofocus"),
                    button: {
                        selector: this.$form.attr("data-" + c + "-button-selector") || this.$form.attr("data-" + c + "-submitbuttons"),
                        disabled: this.$form.attr("data-" + c + "-button-disabled")
                    },
                    control: {
                        valid: this.$form.attr("data-" + c + "-control-valid"),
                        invalid: this.$form.attr("data-" + c + "-control-invalid")
                    },
                    err: {
                        clazz: this.$form.attr("data-" + c + "-err-clazz"),
                        container: this.$form.attr("data-" + c + "-err-container") || this.$form.attr("data-" + c + "-container"),
                        parent: this.$form.attr("data-" + c + "-err-parent")
                    },
                    events: {
                        formInit: this.$form.attr("data-" + c + "-events-form-init"),
                        formPreValidate: this.$form.attr("data-" + c + "-events-form-prevalidate"),
                        formError: this.$form.attr("data-" + c + "-events-form-error"),
                        formSuccess: this.$form.attr("data-" + c + "-events-form-success"),
                        fieldAdded: this.$form.attr("data-" + c + "-events-field-added"),
                        fieldRemoved: this.$form.attr("data-" + c + "-events-field-removed"),
                        fieldInit: this.$form.attr("data-" + c + "-events-field-init"),
                        fieldError: this.$form.attr("data-" + c + "-events-field-error"),
                        fieldSuccess: this.$form.attr("data-" + c + "-events-field-success"),
                        fieldStatus: this.$form.attr("data-" + c + "-events-field-status"),
                        localeChanged: this.$form.attr("data-" + c + "-events-locale-changed"),
                        validatorError: this.$form.attr("data-" + c + "-events-validator-error"),
                        validatorSuccess: this.$form.attr("data-" + c + "-events-validator-success"),
                        validatorIgnored: this.$form.attr("data-" + c + "-events-validator-ignored")
                    },
                    excluded: this.$form.attr("data-" + c + "-excluded"),
                    icon: {
                        valid: this.$form.attr("data-" + c + "-icon-valid") || this.$form.attr("data-" + c + "-feedbackicons-valid"),
                        invalid: this.$form.attr("data-" + c + "-icon-invalid") || this.$form.attr("data-" + c + "-feedbackicons-invalid"),
                        validating: this.$form.attr("data-" + c + "-icon-validating") || this.$form.attr("data-" + c + "-feedbackicons-validating"),
                        feedback: this.$form.attr("data-" + c + "-icon-feedback")
                    },
                    live: this.$form.attr("data-" + c + "-live"),
                    locale: this.$form.attr("data-" + c + "-locale"),
                    message: this.$form.attr("data-" + c + "-message"),
                    onPreValidate: this.$form.attr("data-" + c + "-onprevalidate"),
                    onError: this.$form.attr("data-" + c + "-onerror"),
                    onSuccess: this.$form.attr("data-" + c + "-onsuccess"),
                    row: {
                        selector: this.$form.attr("data-" + c + "-row-selector") || this.$form.attr("data-" + c + "-group"),
                        valid: this.$form.attr("data-" + c + "-row-valid"),
                        invalid: this.$form.attr("data-" + c + "-row-invalid"),
                        feedback: this.$form.attr("data-" + c + "-row-feedback")
                    },
                    threshold: this.$form.attr("data-" + c + "-threshold"),
                    trigger: this.$form.attr("data-" + c + "-trigger"),
                    verbose: this.$form.attr("data-" + c + "-verbose"),
                    fields: {}
                };
            this.$form.attr("novalidate", "novalidate").addClass(this.options.elementClass).on("submit." + c, function (a) {
                a.preventDefault(), b.validate()
            }).on("click." + c, this.options.button.selector, function () {
                b.$submitButton = a(this), b._submitIfValid = !0
            }), (this.options.declarative === !0 || "true" === this.options.declarative) && this.$form.find("[name], [data-" + c + "-field]").each(function () {
                var e = a(this),
                    f = e.attr("name") || e.attr("data-" + c + "-field"),
                    g = b._parseOptions(e);
                g && (e.attr("data-" + c + "-field", f), d.fields[f] = a.extend({}, g, d.fields[f]))
            }), this.options = a.extend(!0, this.options, d), "string" == typeof this.options.err.parent && (this.options.err.parent = new RegExp(this.options.err.parent)), this.options.container && (this.options.err.container = this.options.container, delete this.options.container), this.options.feedbackIcons && (this.options.icon = a.extend(!0, this.options.icon, this.options.feedbackIcons), delete this.options.feedbackIcons), this.options.group && (this.options.row.selector = this.options.group, delete this.options.group), this.options.submitButtons && (this.options.button.selector = this.options.submitButtons, delete this.options.submitButtons), FormValidation.I18n[this.options.locale] || (this.options.locale = a.fn.formValidation.DEFAULT_OPTIONS.locale), (this.options.declarative === !0 || "true" === this.options.declarative) && (this.options = a.extend(!0, this.options, {
                addOns: this._parseAddOnOptions()
            })), this.$hiddenButton = a("<button/>").attr("type", "submit").prependTo(this.$form).addClass("fv-hidden-submit").css({
                display: "none",
                width: 0,
                height: 0
            }), this.$form.on("click." + this._namespace, '[type="submit"]', function (c) {
                if (!c.isDefaultPrevented()) {
                    var d = a(c.target),
                        e = d.is('[type="submit"]') ? d.eq(0) : d.parent('[type="submit"]').eq(0);
                    !b.options.button.selector || e.is(b.options.button.selector) || e.is(b.$hiddenButton) || b.$form.off("submit." + b._namespace).submit()
                }
            });
            for (var e in this.options.fields) this._initField(e);
            for (var f in this.options.addOns) "function" == typeof FormValidation.AddOn[f].init && FormValidation.AddOn[f].init(this, this.options.addOns[f]);
            this.$form.trigger(a.Event(this.options.events.formInit), {
                bv: this,
                fv: this,
                options: this.options
            }), this.options.onPreValidate && this.$form.on(this.options.events.formPreValidate, function (a) {
                FormValidation.Helper.call(b.options.onPreValidate, [a])
            }), this.options.onSuccess && this.$form.on(this.options.events.formSuccess, function (a) {
                FormValidation.Helper.call(b.options.onSuccess, [a])
            }), this.options.onError && this.$form.on(this.options.events.formError, function (a) {
                FormValidation.Helper.call(b.options.onError, [a])
            })
        },
        _initField: function (b) {
            var c = this._namespace,
                d = a([]);
            switch (typeof b) {
                case "object":
                    d = b, b = b.attr("data-" + c + "-field");
                    break;
                case "string":
                    d = this.getFieldElements(b), d.attr("data-" + c + "-field", b)
            }
            if (0 !== d.length && null !== this.options.fields[b] && null !== this.options.fields[b].validators) {
                var e;
                for (e in this.options.fields[b].validators) FormValidation.Validator[e] || delete this.options.fields[b].validators[e];
                null === this.options.fields[b].enabled && (this.options.fields[b].enabled = !0);
                for (var f = this, g = d.length, h = d.attr("type"), i = 1 === g || "radio" === h || "checkbox" === h, j = this._getFieldTrigger(d.eq(0)), k = a.map(j, function (a) {
                        return a + ".update." + c
                    }).join(" "), l = 0; g > l; l++) {
                    var m = d.eq(l),
                        n = this.options.fields[b].row || this.options.row.selector,
                        o = m.closest(n),
                        p = "function" == typeof (this.options.fields[b].container || this.options.fields[b].err || this.options.err.container) ? (this.options.fields[b].container || this.options.fields[b].err || this.options.err.container).call(this, m, this) : this.options.fields[b].container || this.options.fields[b].err || this.options.err.container,
                        q = p && "tooltip" !== p && "popover" !== p ? a(p) : this._getMessageContainer(m, n);
                    p && "tooltip" !== p && "popover" !== p && q.addClass(this.options.err.clazz), q.find("." + this.options.err.clazz.split(" ").join(".") + "[data-" + c + "-validator][data-" + c + '-for="' + b + '"]').remove(), o.find("i[data-" + c + '-icon-for="' + b + '"]').remove(), m.off(k).on(k, function () {
                        f.updateStatus(a(this), f.STATUS_NOT_VALIDATED)
                    }), m.data(c + ".messages", q);
                    for (e in this.options.fields[b].validators) m.data(c + ".result." + e, this.STATUS_NOT_VALIDATED), i && l !== g - 1 || a("<small/>").css("display", "none").addClass(this.options.err.clazz).attr("data-" + c + "-validator", e).attr("data-" + c + "-for", b).attr("data-" + c + "-result", this.STATUS_NOT_VALIDATED).html(this._getMessage(b, e)).appendTo(q), "function" == typeof FormValidation.Validator[e].init && FormValidation.Validator[e].init(this, m, this.options.fields[b].validators[e]);
                    if (this.options.fields[b].icon !== !1 && "false" !== this.options.fields[b].icon && this.options.icon && this.options.icon.valid && this.options.icon.invalid && this.options.icon.validating && (!i || l === g - 1)) {
                        o.addClass(this.options.row.feedback);
                        var r = a("<i/>").css("display", "none").addClass(this.options.icon.feedback).attr("data-" + c + "-icon-for", b).insertAfter(m);
                        (i ? d : m).data(c + ".icon", r), ("tooltip" === p || "popover" === p) && ((i ? d : m).on(this.options.events.fieldError, function () {
                            o.addClass("fv-has-tooltip")
                        }).on(this.options.events.fieldSuccess, function () {
                            o.removeClass("fv-has-tooltip")
                        }), m.off("focus.container." + c).on("focus.container." + c, function () {
                            f._showTooltip(m, p)
                        }).off("blur.container." + c).on("blur.container." + c, function () {
                            f._hideTooltip(m, p)
                        })), "string" == typeof this.options.fields[b].icon && "true" !== this.options.fields[b].icon ? r.appendTo(a(this.options.fields[b].icon)) : this._fixIcon(m, r)
                    }
                }
                d.on(this.options.events.fieldSuccess, function (a, b) {
                    var c = f.getOptions(b.field, null, "onSuccess");
                    c && FormValidation.Helper.call(c, [a, b])
                }).on(this.options.events.fieldError, function (a, b) {
                    var c = f.getOptions(b.field, null, "onError");
                    c && FormValidation.Helper.call(c, [a, b])
                }).on(this.options.events.fieldStatus, function (a, b) {
                    var c = f.getOptions(b.field, null, "onStatus");
                    c && FormValidation.Helper.call(c, [a, b])
                }).on(this.options.events.validatorError, function (a, b) {
                    var c = f.getOptions(b.field, b.validator, "onError");
                    c && FormValidation.Helper.call(c, [a, b])
                }).on(this.options.events.validatorIgnored, function (a, b) {
                    var c = f.getOptions(b.field, b.validator, "onIgnored");
                    c && FormValidation.Helper.call(c, [a, b])
                }).on(this.options.events.validatorSuccess, function (a, b) {
                    var c = f.getOptions(b.field, b.validator, "onSuccess");
                    c && FormValidation.Helper.call(c, [a, b])
                }), this.onLiveChange(d, "live", function () {
                    f._exceedThreshold(a(this)) && f.validateField(a(this))
                }), d.trigger(a.Event(this.options.events.fieldInit), {
                    bv: this,
                    fv: this,
                    field: b,
                    element: d
                })
            }
        },
        _isExcluded: function (b) {
            var c = this._namespace,
                d = b.attr("data-" + c + "-excluded"),
                e = b.attr("data-" + c + "-field") || b.attr("name");
            switch (!0) {
                case !!e && this.options.fields && this.options.fields[e] && ("true" === this.options.fields[e].excluded || this.options.fields[e].excluded === !0):
                case "true" === d:
                case "" === d:
                    return !0;
                case !!e && this.options.fields && this.options.fields[e] && ("false" === this.options.fields[e].excluded || this.options.fields[e].excluded === !1):
                case "false" === d:
                    return !1;
                case !!e && this.options.fields && this.options.fields[e] && "function" == typeof this.options.fields[e].excluded:
                    return this.options.fields[e].excluded.call(this, b, this);
                case !!e && this.options.fields && this.options.fields[e] && "string" == typeof this.options.fields[e].excluded:
                case d:
                    return FormValidation.Helper.call(this.options.fields[e].excluded, [b, this]);
                default:
                    if (this.options.excluded) {
                        "string" == typeof this.options.excluded && (this.options.excluded = a.map(this.options.excluded.split(","), function (b) {
                            return a.trim(b)
                        }));
                        for (var f = this.options.excluded.length, g = 0; f > g; g++)
                            if ("string" == typeof this.options.excluded[g] && b.is(this.options.excluded[g]) || "function" == typeof this.options.excluded[g] && this.options.excluded[g].call(this, b, this) === !0) return !0
                    }
                    return !1
            }
        },
        _getFieldTrigger: function (a) {
            var b = this._namespace,
                c = a.data(b + ".trigger");
            if (c) return c;
            var d = a.attr("type"),
                e = a.attr("data-" + b + "-field"),
                f = "radio" === d || "checkbox" === d || "file" === d || "SELECT" === a.get(0).tagName ? "change" : this._ieVersion >= 10 && a.attr("placeholder") ? "keyup" : this._changeEvent;
            return c = ((this.options.fields[e] ? this.options.fields[e].trigger : null) || this.options.trigger || f).split(" "), a.data(b + ".trigger", c), c
        },
        _getMessage: function (a, b) {
            if (!(this.options.fields[a] && FormValidation.Validator[b] && this.options.fields[a].validators && this.options.fields[a].validators[b])) return "";
            switch (!0) {
                case !!this.options.fields[a].validators[b].message:
                    return this.options.fields[a].validators[b].message;
                case !!this.options.fields[a].message:
                    return this.options.fields[a].message;
                case !!FormValidation.I18n[this.options.locale] && !!FormValidation.I18n[this.options.locale][b] && !!FormValidation.I18n[this.options.locale][b]["default"]:
                    return FormValidation.I18n[this.options.locale][b]["default"];
                default:
                    return this.options.message
            }
        },
        _getMessageContainer: function (a, b) {
            if (!this.options.err.parent) throw new Error("The err.parent option is not defined");
            var c = a.parent();
            if (c.is(b)) return c;
            var d = c.attr("class");
            return d && this.options.err.parent.test(d) ? c : this._getMessageContainer(c, b)
        },
        _parseAddOnOptions: function () {
            var a = this._namespace,
                b = this.$form.attr("data-" + a + "-addons"),
                c = this.options.addOns || {};
            if (b) {
                b = b.replace(/\s/g, "").split(",");
                for (var d = 0; d < b.length; d++) c[b[d]] || (c[b[d]] = {})
            }
            var e, f, g, h;
            for (e in c)
                if (FormValidation.AddOn[e]) {
                    if (f = FormValidation.AddOn[e].html5Attributes)
                        for (g in f) h = this.$form.attr("data-" + a + "-addons-" + e.toLowerCase() + "-" + g.toLowerCase()), h && (c[e][f[g]] = h)
                } else delete c[e];
            return c
        },
        _parseOptions: function (b) {
            var c, d, e, f, g, h, i, j, k, l = this._namespace,
                m = b.attr("name") || b.attr("data-" + l + "-field"),
                n = {};
            for (d in FormValidation.Validator)
                if (c = FormValidation.Validator[d], e = "data-" + l + "-" + d.toLowerCase(), f = b.attr(e) + "", k = "function" == typeof c.enableByHtml5 ? c.enableByHtml5(b) : null, k && "false" !== f || k !== !0 && ("" === f || "true" === f || e === f.toLowerCase())) {
                    c.html5Attributes = a.extend({}, {
                        message: "message",
                        onerror: "onError",
                        onsuccess: "onSuccess",
                        transformer: "transformer"
                    }, c.html5Attributes), n[d] = a.extend({}, k === !0 ? {} : k, n[d]);
                    for (j in c.html5Attributes) g = c.html5Attributes[j], h = "data-" + l + "-" + d.toLowerCase() + "-" + j, i = b.attr(h), i && ("true" === i || h === i.toLowerCase() ? i = !0 : "false" === i && (i = !1), n[d][g] = i)
                }
            var o = {
                    autoFocus: b.attr("data-" + l + "-autofocus"),
                    err: b.attr("data-" + l + "-err-container") || b.attr("data-" + l + "-container"),
                    excluded: b.attr("data-" + l + "-excluded"),
                    icon: b.attr("data-" + l + "-icon") || b.attr("data-" + l + "-feedbackicons") || (this.options.fields && this.options.fields[m] ? this.options.fields[m].feedbackIcons : null),
                    message: b.attr("data-" + l + "-message"),
                    onError: b.attr("data-" + l + "-onerror"),
                    onStatus: b.attr("data-" + l + "-onstatus"),
                    onSuccess: b.attr("data-" + l + "-onsuccess"),
                    row: b.attr("data-" + l + "-row") || b.attr("data-" + l + "-group") || (this.options.fields && this.options.fields[m] ? this.options.fields[m].group : null),
                    selector: b.attr("data-" + l + "-selector"),
                    threshold: b.attr("data-" + l + "-threshold"),
                    transformer: b.attr("data-" + l + "-transformer"),
                    trigger: b.attr("data-" + l + "-trigger"),
                    verbose: b.attr("data-" + l + "-verbose"),
                    validators: n
                },
                p = a.isEmptyObject(o),
                q = a.isEmptyObject(n);
            return !q || !p && this.options.fields && this.options.fields[m] ? (o.validators = n, o) : null
        },
        _submit: function () {
            var b = this.isValid();
            if (null !== b) {
                var c = b ? this.options.events.formSuccess : this.options.events.formError,
                    d = a.Event(c);
                this.$form.trigger(d), this.$submitButton && (b ? this._onSuccess(d) : this._onError(d))
            }
        },
        _onError: function (b) {
            if (!b.isDefaultPrevented()) {
                if ("submitted" === this.options.live) {
                    this.options.live = "enabled";
                    var c = this;
                    for (var d in this.options.fields) ! function (b) {
                        var d = c.getFieldElements(b);
                        d.length && c.onLiveChange(d, "live", function () {
                            c._exceedThreshold(a(this)) && c.validateField(a(this))
                        })
                    }(d)
                }
                for (var e = this._namespace, f = 0; f < this.$invalidFields.length; f++) {
                    var g = this.$invalidFields.eq(f),
                        h = this.isOptionEnabled(g.attr("data-" + e + "-field"), "autoFocus");
                    if (h) {
                        g.focus();
                        break
                    }
                }
            }
        },
        _onFieldValidated: function (b, c) {
            var d = this._namespace,
                e = b.attr("data-" + d + "-field"),
                f = this.options.fields[e].validators,
                g = {},
                h = 0,
                i = {
                    bv: this,
                    fv: this,
                    field: e,
                    element: b,
                    validator: c,
                    result: b.data(d + ".response." + c)
                };
            if (c) switch (b.data(d + ".result." + c)) {
                case this.STATUS_INVALID:
                    b.trigger(a.Event(this.options.events.validatorError), i);
                    break;
                case this.STATUS_VALID:
                    b.trigger(a.Event(this.options.events.validatorSuccess), i);
                    break;
                case this.STATUS_IGNORED:
                    b.trigger(a.Event(this.options.events.validatorIgnored), i)
            }
            g[this.STATUS_NOT_VALIDATED] = 0, g[this.STATUS_VALIDATING] = 0, g[this.STATUS_INVALID] = 0, g[this.STATUS_VALID] = 0, g[this.STATUS_IGNORED] = 0;
            for (var j in f)
                if (f[j].enabled !== !1) {
                    h++;
                    var k = b.data(d + ".result." + j);
                    k && g[k]++
                }
            g[this.STATUS_VALID] + g[this.STATUS_IGNORED] === h ? (this.$invalidFields = this.$invalidFields.not(b), b.trigger(a.Event(this.options.events.fieldSuccess), i)) : (0 === g[this.STATUS_NOT_VALIDATED] || !this.isOptionEnabled(e, "verbose")) && 0 === g[this.STATUS_VALIDATING] && g[this.STATUS_INVALID] > 0 && (this.$invalidFields = this.$invalidFields.add(b), b.trigger(a.Event(this.options.events.fieldError), i))
        },
        _onSuccess: function (a) {
            a.isDefaultPrevented() || this.disableSubmitButtons(!0).defaultSubmit()
        },
        _fixIcon: function () {},
        _createTooltip: function () {},
        _destroyTooltip: function () {},
        _hideTooltip: function () {},
        _showTooltip: function () {},
        defaultSubmit: function () {
            var b = this._namespace;
            this.$submitButton && a("<input/>").attr({
                type: "hidden",
                name: this.$submitButton.attr("name")
            }).attr("data-" + b + "-submit-hidden", "").val(this.$submitButton.val()).appendTo(this.$form), this.$form.off("submit." + b).submit()
        },
        disableSubmitButtons: function (a) {
            return a ? "disabled" !== this.options.live && this.$form.find(this.options.button.selector).attr("disabled", "disabled").addClass(this.options.button.disabled) : this.$form.find(this.options.button.selector).removeAttr("disabled").removeClass(this.options.button.disabled), this
        },
        getFieldElements: function (b) {
            if (!this._cacheFields[b])
                if (this.options.fields[b] && this.options.fields[b].selector) {
                    var c = this.$form.find(this.options.fields[b].selector);
                    this._cacheFields[b] = c.length ? c : a(this.options.fields[b].selector)
                } else this._cacheFields[b] = this.$form.find('[name="' + b + '"]');
            return this._cacheFields[b]
        },
        getFieldValue: function (a, b) {
            var c, d = this._namespace;
            if ("string" == typeof a) {
                if (c = this.getFieldElements(a), 0 === c.length) return null
            } else c = a, a = c.attr("data-" + d + "-field");
            if (!a || !this.options.fields[a]) return c.val();
            var e = (this.options.fields[a].validators && this.options.fields[a].validators[b] ? this.options.fields[a].validators[b].transformer : null) || this.options.fields[a].transformer;
            return e ? FormValidation.Helper.call(e, [c, b, this]) : c.val()
        },
        getNamespace: function () {
            return this._namespace
        },
        getOptions: function (a, b, c) {
            var d = this._namespace;
            if (!a) return c ? this.options[c] : this.options;
            if ("object" == typeof a && (a = a.attr("data-" + d + "-field")), !this.options.fields[a]) return null;
            var e = this.options.fields[a];
            return b ? e.validators && e.validators[b] ? c ? e.validators[b][c] : e.validators[b] : null : c ? e[c] : e
        },
        getStatus: function (a, b) {
            var c = this._namespace;
            switch (typeof a) {
                case "object":
                    return a.data(c + ".result." + b);
                case "string":
                default:
                    return this.getFieldElements(a).eq(0).data(c + ".result." + b)
            }
        },
        isOptionEnabled: function (a, b) {
            return !this.options.fields[a] || "true" !== this.options.fields[a][b] && this.options.fields[a][b] !== !0 ? !this.options.fields[a] || "false" !== this.options.fields[a][b] && this.options.fields[a][b] !== !1 ? "true" === this.options[b] || this.options[b] === !0 : !1 : !0
        },
        isValid: function () {
            for (var a in this.options.fields) {
                var b = this.isValidField(a);
                if (null === b) return null;
                if (b === !1) return !1
            }
            return !0
        },
        isValidContainer: function (b) {
            var c = this,
                d = this._namespace,
                e = [],
                f = "string" == typeof b ? a(b) : b;
            if (0 === f.length) return !0;
            f.find("[data-" + d + "-field]").each(function () {
                var b = a(this);
                c._isExcluded(b) || e.push(b)
            });
            for (var g = e.length, h = 0; g > h; h++) {
                var i = e[h],
                    j = i.attr("data-" + d + "-field"),
                    k = i.data(d + ".messages").find("." + this.options.err.clazz.split(" ").join(".") + "[data-" + d + "-validator][data-" + d + '-for="' + j + '"]');
                if (k.filter("[data-" + d + '-result="' + this.STATUS_INVALID + '"]').length > 0) return !1;
                if (k.filter("[data-" + d + '-result="' + this.STATUS_NOT_VALIDATED + '"]').length > 0 || k.filter("[data-" + d + '-result="' + this.STATUS_VALIDATING + '"]').length > 0) return null
            }
            return !0
        },
        isValidField: function (b) {
            var c = this._namespace,
                d = a([]);
            switch (typeof b) {
                case "object":
                    d = b, b = b.attr("data-" + c + "-field");
                    break;
                case "string":
                    d = this.getFieldElements(b)
            }
            if (0 === d.length || !this.options.fields[b] || this.options.fields[b].enabled === !1) return !0;
            for (var e, f, g, h = d.attr("type"), i = "radio" === h || "checkbox" === h ? 1 : d.length, j = 0; i > j; j++)
                if (e = d.eq(j), !this._isExcluded(e))
                    for (f in this.options.fields[b].validators)
                        if (this.options.fields[b].validators[f].enabled !== !1) {
                            if (g = e.data(c + ".result." + f), g === this.STATUS_VALIDATING || g === this.STATUS_NOT_VALIDATED) return null;
                            if (g === this.STATUS_INVALID) return !1
                        }
            return !0
        },
        offLiveChange: function (b, c) {
            if (null === b || 0 === b.length) return this;
            var d = this._namespace,
                e = this._getFieldTrigger(b.eq(0)),
                f = a.map(e, function (a) {
                    return a + "." + c + "." + d
                }).join(" ");
            return b.off(f), this
        },
        onLiveChange: function (b, c, d) {
            if (null === b || 0 === b.length) return this;
            var e = this._namespace,
                f = this._getFieldTrigger(b.eq(0)),
                g = a.map(f, function (a) {
                    return a + "." + c + "." + e
                }).join(" ");
            switch (this.options.live) {
                case "submitted":
                    break;
                case "disabled":
                    b.off(g);
                    break;
                case "enabled":
                default:
                    b.off(g).on(g, function () {
                        d.apply(this, arguments)
                    })
            }
            return this
        },
        updateMessage: function (b, c, d) {
            var e = this,
                f = this._namespace,
                g = a([]);
            switch (typeof b) {
                case "object":
                    g = b, b = b.attr("data-" + f + "-field");
                    break;
                case "string":
                    g = this.getFieldElements(b)
            }
            return g.each(function () {
                a(this).data(f + ".messages").find("." + e.options.err.clazz + "[data-" + f + '-validator="' + c + '"][data-' + f + '-for="' + b + '"]').html(d)
            }), this
        },
        updateStatus: function (b, c, d) {
            var e = this._namespace,
                f = a([]);
            switch (typeof b) {
                case "object":
                    f = b, b = b.attr("data-" + e + "-field");
                    break;
                case "string":
                    f = this.getFieldElements(b)
            }
            if (!b || !this.options.fields[b]) return this;
            c === this.STATUS_NOT_VALIDATED && (this._submitIfValid = !1);
            for (var g = this, h = f.attr("type"), i = this.options.fields[b].row || this.options.row.selector, j = "radio" === h || "checkbox" === h ? 1 : f.length, k = 0; j > k; k++) {
                var l = f.eq(k);
                if (!this._isExcluded(l)) {
                    var m, n, o = l.closest(i),
                        p = l.data(e + ".messages"),
                        q = p.find("." + this.options.err.clazz.split(" ").join(".") + "[data-" + e + "-validator][data-" + e + '-for="' + b + '"]'),
                        r = d ? q.filter("[data-" + e + '-validator="' + d + '"]') : q,
                        s = l.data(e + ".icon"),
                        t = "function" == typeof (this.options.fields[b].container || this.options.fields[b].err || this.options.err.container) ? (this.options.fields[b].container || this.options.fields[b].err || this.options.err.container).call(this, l, this) : this.options.fields[b].container || this.options.fields[b].err || this.options.err.container,
                        u = null;
                    if (d) l.data(e + ".result." + d, c);
                    else
                        for (var v in this.options.fields[b].validators) l.data(e + ".result." + v, c);
                    switch (r.attr("data-" + e + "-result", c), c) {
                        case this.STATUS_VALIDATING:
                            u = null, this.disableSubmitButtons(!0), l.removeClass(this.options.control.valid).removeClass(this.options.control.invalid), o.removeClass(this.options.row.valid).removeClass(this.options.row.invalid), s && s.removeClass(this.options.icon.valid).removeClass(this.options.icon.invalid).addClass(this.options.icon.validating).show();
                            break;
                        case this.STATUS_INVALID:
                            u = !1, this.disableSubmitButtons(!0), l.removeClass(this.options.control.valid).addClass(this.options.control.invalid), o.removeClass(this.options.row.valid).addClass(this.options.row.invalid), s && s.removeClass(this.options.icon.valid).removeClass(this.options.icon.validating).addClass(this.options.icon.invalid).show();
                            break;
                        case this.STATUS_IGNORED:
                        case this.STATUS_VALID:
                            m = q.filter("[data-" + e + '-result="' + this.STATUS_VALIDATING + '"]').length > 0, n = q.filter("[data-" + e + '-result="' + this.STATUS_NOT_VALIDATED + '"]').length > 0;
                            var w = q.filter("[data-" + e + '-result="' + this.STATUS_IGNORED + '"]').length;
                            u = m || n ? null : q.filter("[data-" + e + '-result="' + this.STATUS_VALID + '"]').length + w === q.length, l.removeClass(this.options.control.valid).removeClass(this.options.control.invalid), u === !0 ? (this.disableSubmitButtons(this.isValid() === !1), c === this.STATUS_VALID && l.addClass(this.options.control.valid)) : u === !1 && (this.disableSubmitButtons(!0), c === this.STATUS_VALID && l.addClass(this.options.control.invalid)), s && (s.removeClass(this.options.icon.invalid).removeClass(this.options.icon.validating).removeClass(this.options.icon.valid), (c === this.STATUS_VALID || w !== q.length) && s.addClass(m ? this.options.icon.validating : null === u ? "" : u ? this.options.icon.valid : this.options.icon.invalid).show());
                            var x = this.isValidContainer(o);
                            null !== x && (o.removeClass(this.options.row.valid).removeClass(this.options.row.invalid), (c === this.STATUS_VALID || w !== q.length) && o.addClass(x ? this.options.row.valid : this.options.row.invalid));
                            break;
                        case this.STATUS_NOT_VALIDATED:
                        default:
                            u = null, this.disableSubmitButtons(!1), l.removeClass(this.options.control.valid).removeClass(this.options.control.invalid), o.removeClass(this.options.row.valid).removeClass(this.options.row.invalid), s && s.removeClass(this.options.icon.valid).removeClass(this.options.icon.invalid).removeClass(this.options.icon.validating).hide()
                    }!s || "tooltip" !== t && "popover" !== t ? c === this.STATUS_INVALID ? r.show() : r.hide() : u === !1 ? this._createTooltip(l, q.filter("[data-" + e + '-result="' + g.STATUS_INVALID + '"]').eq(0).html(), t) : this._destroyTooltip(l, t), l.trigger(a.Event(this.options.events.fieldStatus), {
                        bv: this,
                        fv: this,
                        field: b,
                        element: l,
                        status: c
                    }), this._onFieldValidated(l, d)
                }
            }
            return this
        },
        validate: function () {
            if (a.isEmptyObject(this.options.fields)) return this._submit(), this;
            this.$form.trigger(a.Event(this.options.events.formPreValidate)), this.disableSubmitButtons(!0), this._submitIfValid = !1;
            for (var b in this.options.fields) this.validateField(b);
            return this._submit(), this._submitIfValid = !0, this
        },
        validateField: function (b) {
            var c = this._namespace,
                d = a([]);
            switch (typeof b) {
                case "object":
                    d = b, b = b.attr("data-" + c + "-field");
                    break;
                case "string":
                    d = this.getFieldElements(b)
            }
            if (0 === d.length || !this.options.fields[b] || this.options.fields[b].enabled === !1) return this;
            for (var e, f, g = this, h = d.attr("type"), i = "radio" === h || "checkbox" === h ? 1 : d.length, j = "radio" === h || "checkbox" === h, k = this.options.fields[b].validators, l = this.isOptionEnabled(b, "verbose"), m = 0; i > m; m++) {
                var n = d.eq(m);
                if (!this._isExcluded(n)) {
                    var o = !1;
                    for (e in k) {
                        if (n.data(c + ".dfs." + e) && n.data(c + ".dfs." + e).reject(), o) break;
                        var p = n.data(c + ".result." + e);
                        if (p !== this.STATUS_VALID && p !== this.STATUS_INVALID)
                            if (k[e].enabled !== !1)
                                if (n.data(c + ".result." + e, this.STATUS_VALIDATING), f = FormValidation.Validator[e].validate(this, n, k[e]), "object" == typeof f && f.resolve) this.updateStatus(j ? b : n, this.STATUS_VALIDATING, e), n.data(c + ".dfs." + e, f), f.done(function (a, b, d) {
                                    a.removeData(c + ".dfs." + b).data(c + ".response." + b, d), d.message && g.updateMessage(a, b, d.message), g.updateStatus(j ? a.attr("data-" + c + "-field") : a, d.valid === !0 ? g.STATUS_VALID : d.valid === !1 ? g.STATUS_INVALID : g.STATUS_IGNORED, b), d.valid && g._submitIfValid === !0 ? g._submit() : d.valid !== !1 || l || (o = !0)
                                });
                                else if ("object" == typeof f && void 0 !== f.valid) {
                            if (n.data(c + ".response." + e, f), f.message && this.updateMessage(j ? b : n, e, f.message), this.updateStatus(j ? b : n, f.valid === !0 ? this.STATUS_VALID : f.valid === !1 ? this.STATUS_INVALID : this.STATUS_IGNORED, e), f.valid === !1 && !l) break
                        } else if ("boolean" == typeof f) {
                            if (n.data(c + ".response." + e, f), this.updateStatus(j ? b : n, f ? this.STATUS_VALID : this.STATUS_INVALID, e), !f && !l) break
                        } else null === f && (n.data(c + ".response." + e, f), this.updateStatus(j ? b : n, this.STATUS_IGNORED, e));
                        else this.updateStatus(j ? b : n, this.STATUS_IGNORED, e);
                        else this._onFieldValidated(n, e)
                    }
                }
            }
            return this
        },
        addField: function (b, c) {
            var d = this._namespace,
                e = a([]);
            switch (typeof b) {
                case "object":
                    e = b, b = b.attr("data-" + d + "-field") || b.attr("name");
                    break;
                case "string":
                    delete this._cacheFields[b], e = this.getFieldElements(b)
            }
            e.attr("data-" + d + "-field", b);
            for (var f = e.attr("type"), g = "radio" === f || "checkbox" === f ? 1 : e.length, h = 0; g > h; h++) {
                var i = e.eq(h),
                    j = this._parseOptions(i);
                j = null === j ? c : a.extend(!0, j, c), this.options.fields[b] = a.extend(!0, this.options.fields[b], j), this._cacheFields[b] = this._cacheFields[b] ? this._cacheFields[b].add(i) : i, this._initField("checkbox" === f || "radio" === f ? b : i)
            }
            return this.disableSubmitButtons(!1), this.$form.trigger(a.Event(this.options.events.fieldAdded), {
                field: b,
                element: e,
                options: this.options.fields[b]
            }), this
        },
        destroy: function () {
            var a, b, c, d, e, f, g, h = this._namespace;
            for (b in this.options.fields)
                for (c = this.getFieldElements(b), a = 0; a < c.length; a++) {
                    d = c.eq(a);
                    for (e in this.options.fields[b].validators) d.data(h + ".dfs." + e) && d.data(h + ".dfs." + e).reject(), d.removeData(h + ".result." + e).removeData(h + ".response." + e).removeData(h + ".dfs." + e), "function" == typeof FormValidation.Validator[e].destroy && FormValidation.Validator[e].destroy(this, d, this.options.fields[b].validators[e])
                }
            for (b in this.options.fields)
                for (c = this.getFieldElements(b), g = this.options.fields[b].row || this.options.row.selector, a = 0; a < c.length; a++) {
                    d = c.eq(a), d.data(h + ".messages").find("." + this.options.err.clazz.split(" ").join(".") + "[data-" + h + "-validator][data-" + h + '-for="' + b + '"]').remove().end().end().removeData(h + ".messages").closest(g).removeClass(this.options.row.valid).removeClass(this.options.row.invalid).removeClass(this.options.row.feedback).end().off("." + h).removeAttr("data-" + h + "-field");
                    var i = "function" == typeof (this.options.fields[b].container || this.options.fields[b].err || this.options.err.container) ? (this.options.fields[b].container || this.options.fields[b].err || this.options.err.container).call(this, d, this) : this.options.fields[b].container || this.options.fields[b].err || this.options.err.container;
                    ("tooltip" === i || "popover" === i) && this._destroyTooltip(d, i), f = d.data(h + ".icon"), f && f.remove(), d.removeData(h + ".icon").removeData(h + ".trigger")
                }
            for (var j in this.options.addOns) "function" == typeof FormValidation.AddOn[j].destroy && FormValidation.AddOn[j].destroy(this, this.options.addOns[j]);
            this.disableSubmitButtons(!1), this.$hiddenButton.remove(), this.$form.removeClass(this.options.elementClass).off("." + h).removeData("bootstrapValidator").removeData("formValidation").find("[data-" + h + "-submit-hidden]").remove().end().find('[type="submit"]').off("click." + h)
        },
        enableFieldValidators: function (a, b, c) {
            var d = this.options.fields[a].validators;
            if (c && d && d[c] && d[c].enabled !== b) this.options.fields[a].validators[c].enabled = b, this.updateStatus(a, this.STATUS_NOT_VALIDATED, c);
            else if (!c && this.options.fields[a].enabled !== b) {
                this.options.fields[a].enabled = b;
                for (var e in d) this.enableFieldValidators(a, b, e)
            }
            return this
        },
        getDynamicOption: function (a, b) {
            var c = "string" == typeof a ? this.getFieldElements(a) : a,
                d = c.val();
            if ("function" == typeof b) return FormValidation.Helper.call(b, [d, this, c]);
            if ("string" == typeof b) {
                var e = this.getFieldElements(b);
                return e.length ? e.val() : FormValidation.Helper.call(b, [d, this, c]) || b
            }
            return null
        },
        getForm: function () {
            return this.$form
        },
        getInvalidFields: function () {
            return this.$invalidFields
        },
        getLocale: function () {
            return this.options.locale
        },
        getMessages: function (b, c) {
            var d = this,
                e = this._namespace,
                f = [],
                g = a([]);
            switch (!0) {
                case b && "object" == typeof b:
                    g = b;
                    break;
                case b && "string" == typeof b:
                    var h = this.getFieldElements(b);
                    if (h.length > 0) {
                        var i = h.attr("type");
                        g = "radio" === i || "checkbox" === i ? h.eq(0) : h
                    }
                    break;
                default:
                    g = this.$invalidFields
            }
            var j = c ? "[data-" + e + '-validator="' + c + '"]' : "";
            return g.each(function () {
                f = f.concat(a(this).data(e + ".messages").find("." + d.options.err.clazz + "[data-" + e + '-for="' + a(this).attr("data-" + e + "-field") + '"][data-' + e + '-result="' + d.STATUS_INVALID + '"]' + j).map(function () {
                    var b = a(this).attr("data-" + e + "-validator"),
                        c = a(this).attr("data-" + e + "-for");
                    return d.options.fields[c].validators[b].enabled === !1 ? "" : a(this).html()
                }).get())
            }), f
        },
        getSubmitButton: function () {
            return this.$submitButton
        },
        removeField: function (b) {
            var c = this._namespace,
                d = a([]);
            switch (typeof b) {
                case "object":
                    d = b, b = b.attr("data-" + c + "-field") || b.attr("name"), d.attr("data-" + c + "-field", b);
                    break;
                case "string":
                    d = this.getFieldElements(b)
            }
            if (0 === d.length) return this;
            for (var e = d.attr("type"), f = "radio" === e || "checkbox" === e ? 1 : d.length, g = 0; f > g; g++) {
                var h = d.eq(g);
                this.$invalidFields = this.$invalidFields.not(h), this._cacheFields[b] = this._cacheFields[b].not(h)
            }
            return this._cacheFields[b] && 0 !== this._cacheFields[b].length || delete this.options.fields[b], ("checkbox" === e || "radio" === e) && this._initField(b), this.disableSubmitButtons(!1), this.$form.trigger(a.Event(this.options.events.fieldRemoved), {
                field: b,
                element: d
            }), this
        },
        resetField: function (b, c) {
            var d = this._namespace,
                e = a([]);

            switch (typeof b) {
                case "object":
                    e = b, b = b.attr("data-" + d + "-field");
                    break;
                case "string":
                    e = this.getFieldElements(b)
            }
            var f = e.length;
            if (this.options.fields[b])
                for (var g = 0; f > g; g++)
                    for (var h in this.options.fields[b].validators) e.eq(g).removeData(d + ".dfs." + h);
            if (c) {
                var i = e.attr("type");
                "radio" === i || "checkbox" === i ? e.prop("checked", !1).removeAttr("selected") : e.val("")
            }
            return this.updateStatus(b, this.STATUS_NOT_VALIDATED), this
        },
        resetForm: function (b) {
            for (var c in this.options.fields) this.resetField(c, b);
            return this.$invalidFields = a([]), this.$submitButton = null, this.disableSubmitButtons(!1), this
        },
        revalidateField: function (a) {
            return this.updateStatus(a, this.STATUS_NOT_VALIDATED).validateField(a), this
        },
        setLocale: function (b) {
            return this.options.locale = b, this.$form.trigger(a.Event(this.options.events.localeChanged), {
                locale: b,
                bv: this,
                fv: this
            }), this
        },
        updateOption: function (a, b, c, d) {
            var e = this._namespace;
            return "object" == typeof a && (a = a.attr("data-" + e + "-field")), this.options.fields[a] && this.options.fields[a].validators[b] && (this.options.fields[a].validators[b][c] = d, this.updateStatus(a, this.STATUS_NOT_VALIDATED, b)), this
        },
        validateContainer: function (b) {
            var c = this,
                d = this._namespace,
                e = [],
                f = "string" == typeof b ? a(b) : b;
            if (0 === f.length) return this;
            f.find("[data-" + d + "-field]").each(function () {
                var b = a(this);
                c._isExcluded(b) || e.push(b)
            });
            for (var g = e.length, h = 0; g > h; h++) this.validateField(e[h]);
            return this
        }
    }, a.fn.formValidation = function (b) {
        var c = arguments;
        return this.each(function () {
            var d = a(this),
                e = d.data("formValidation"),
                f = "object" == typeof b && b;
            if (!e) {
                var g = (f.framework || d.attr("data-fv-framework") || "bootstrap").toLowerCase(),
                    h = g.substr(0, 1).toUpperCase() + g.substr(1);
                if ("undefined" == typeof FormValidation.Framework[h]) throw new Error("The class FormValidation.Framework." + h + " is not implemented");
                e = new FormValidation.Framework[h](this, f), d.addClass("fv-form-" + g).data("formValidation", e)
            }
            "string" == typeof b && e[b].apply(e, Array.prototype.slice.call(c, 1))
        })
    }, a.fn.formValidation.Constructor = FormValidation.Base, a.fn.formValidation.DEFAULT_OPTIONS = {
        autoFocus: !0,
        declarative: !0,
        elementClass: "fv-form",
        events: {
            formInit: "init.form.fv",
            formPreValidate: "prevalidate.form.fv",
            formError: "err.form.fv",
            formSuccess: "success.form.fv",
            fieldAdded: "added.field.fv",
            fieldRemoved: "removed.field.fv",
            fieldInit: "init.field.fv",
            fieldError: "err.field.fv",
            fieldSuccess: "success.field.fv",
            fieldStatus: "status.field.fv",
            localeChanged: "changed.locale.fv",
            validatorError: "err.validator.fv",
            validatorSuccess: "success.validator.fv",
            validatorIgnored: "ignored.validator.fv"
        },
        excluded: [":disabled", ":hidden", ":not(:visible)"],
        fields: null,
        live: "enabled",
        locale: "en_US",
        message: "This value is not valid",
        threshold: null,
        verbose: !0,
        button: {
            selector: '[type="submit"]:not([formnovalidate])',
            disabled: ""
        },
        control: {
            valid: "",
            invalid: ""
        },
        err: {
            clazz: "",
            container: null,
            parent: null
        },
        icon: {
            valid: null,
            invalid: null,
            validating: null,
            feedback: ""
        },
        row: {
            selector: null,
            valid: "",
            invalid: "",
            feedback: ""
        }
    }
}(jQuery),
function (a) {
    FormValidation.Helper = {
        call: function (a, b) {
            if ("function" == typeof a) return a.apply(this, b);
            if ("string" == typeof a) {
                "()" === a.substring(a.length - 2) && (a = a.substring(0, a.length - 2));
                for (var c = a.split("."), d = c.pop(), e = window, f = 0; f < c.length; f++) e = e[c[f]];
                return "undefined" == typeof e[d] ? null : e[d].apply(this, b)
            }
        },
        date: function (a, b, c, d) {
            if (isNaN(a) || isNaN(b) || isNaN(c)) return !1;
            if (c.length > 2 || b.length > 2 || a.length > 4) return !1;
            if (c = parseInt(c, 10), b = parseInt(b, 10), a = parseInt(a, 10), 1e3 > a || a > 9999 || 0 >= b || b > 12) return !1;
            var e = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
            if ((a % 400 === 0 || a % 100 !== 0 && a % 4 === 0) && (e[1] = 29), 0 >= c || c > e[b - 1]) return !1;
            if (d === !0) {
                var f = new Date,
                    g = f.getFullYear(),
                    h = f.getMonth(),
                    i = f.getDate();
                return g > a || a === g && h > b - 1 || a === g && b - 1 === h && i > c
            }
            return !0
        },
        format: function (b, c) {
            a.isArray(c) || (c = [c]);
            for (var d in c) b = b.replace("%s", c[d]);
            return b
        },
        luhn: function (a) {
            for (var b = a.length, c = 0, d = [
                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [0, 2, 4, 6, 8, 1, 3, 5, 7, 9]
                ], e = 0; b--;) e += d[c][parseInt(a.charAt(b), 10)], c ^= 1;
            return e % 10 === 0 && e > 0
        },
        mod11And10: function (a) {
            for (var b = 5, c = a.length, d = 0; c > d; d++) b = (2 * (b || 10) % 11 + parseInt(a.charAt(d), 10)) % 10;
            return 1 === b
        },
        mod37And36: function (a, b) {
            b = b || "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            for (var c = b.length, d = a.length, e = Math.floor(c / 2), f = 0; d > f; f++) e = (2 * (e || c) % (c + 1) + b.indexOf(a.charAt(f))) % c;
            return 1 === e
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            between: {
                "default": "Please enter a value between %s and %s",
                notInclusive: "Please enter a value between %s and %s strictly"
            }
        }
    }), FormValidation.Validator.between = {
        html5Attributes: {
            message: "message",
            min: "min",
            max: "max",
            inclusive: "inclusive"
        },
        enableByHtml5: function (a) {
            return "range" === a.attr("type") ? {
                min: a.attr("min"),
                max: a.attr("max")
            } : !1
        },
        validate: function (b, c, d) {
            var e = b.getFieldValue(c, "between");
            if ("" === e) return !0;
            if (e = this._format(e), !a.isNumeric(e)) return !1;
            var f = b.getLocale(),
                g = a.isNumeric(d.min) ? d.min : b.getDynamicOption(c, d.min),
                h = a.isNumeric(d.max) ? d.max : b.getDynamicOption(c, d.max),
                i = this._format(g),
                j = this._format(h);
            return e = parseFloat(e), d.inclusive === !0 || void 0 === d.inclusive ? {
                valid: e >= i && j >= e,
                message: FormValidation.Helper.format(d.message || FormValidation.I18n[f].between["default"], [g, h])
            } : {
                valid: e > i && j > e,
                message: FormValidation.Helper.format(d.message || FormValidation.I18n[f].between.notInclusive, [g, h])
            }
        },
        _format: function (a) {
            return (a + "").replace(",", ".")
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            callback: {
                "default": "Please enter a valid value"
            }
        }
    }), FormValidation.Validator.callback = {
        html5Attributes: {
            message: "message",
            callback: "callback"
        },
        validate: function (b, c, d) {
            var e = b.getFieldValue(c, "callback"),
                f = new a.Deferred,
                g = {
                    valid: !0
                };
            if (d.callback) {
                var h = FormValidation.Helper.call(d.callback, [e, b, c]);
                g = "boolean" == typeof h || null === h ? {
                    valid: h
                } : h
            }
            return f.resolve(c, "callback", g), f
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            choice: {
                "default": "Please enter a valid value",
                less: "Please choose %s options at minimum",
                more: "Please choose %s options at maximum",
                between: "Please choose %s - %s options"
            }
        }
    }), FormValidation.Validator.choice = {
        html5Attributes: {
            message: "message",
            min: "min",
            max: "max"
        },
        validate: function (b, c, d) {
            var e = b.getLocale(),
                f = b.getNamespace(),
                g = c.is("select") ? b.getFieldElements(c.attr("data-" + f + "-field")).find("option").filter(":selected").length : b.getFieldElements(c.attr("data-" + f + "-field")).filter(":checked").length,
                h = d.min ? a.isNumeric(d.min) ? d.min : b.getDynamicOption(c, d.min) : null,
                i = d.max ? a.isNumeric(d.max) ? d.max : b.getDynamicOption(c, d.max) : null,
                j = !0,
                k = d.message || FormValidation.I18n[e].choice["default"];
            switch ((h && g < parseInt(h, 10) || i && g > parseInt(i, 10)) && (j = !1), !0) {
                case !!h && !!i:
                    k = FormValidation.Helper.format(d.message || FormValidation.I18n[e].choice.between, [parseInt(h, 10), parseInt(i, 10)]);
                    break;
                case !!h:
                    k = FormValidation.Helper.format(d.message || FormValidation.I18n[e].choice.less, parseInt(h, 10));
                    break;
                case !!i:
                    k = FormValidation.Helper.format(d.message || FormValidation.I18n[e].choice.more, parseInt(i, 10))
            }
            return {
                valid: j,
                message: k
            }
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            color: {
                "default": "Please enter a valid color"
            }
        }
    }), FormValidation.Validator.color = {
        html5Attributes: {
            message: "message",
            type: "type"
        },
        enableByHtml5: function (a) {
            return "color" === a.attr("type")
        },
        SUPPORTED_TYPES: ["hex", "rgb", "rgba", "hsl", "hsla", "keyword"],
        KEYWORD_COLORS: ["aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkgrey", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkslategrey", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dimgrey", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "grey", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightslategrey", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "slategrey", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "transparent", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen"],
        validate: function (b, c, d) {
            var e = b.getFieldValue(c, "color");
            if ("" === e) return !0;
            if (this.enableByHtml5(c)) return /^#[0-9A-F]{6}$/i.test(e);
            var f = d.type || this.SUPPORTED_TYPES;
            a.isArray(f) || (f = f.replace(/s/g, "").split(","));
            for (var g, h, i = !1, j = 0; j < f.length; j++)
                if (h = f[j], g = "_" + h.toLowerCase(), i = i || this[g](e)) return !0;
            return !1
        },
        _hex: function (a) {
            return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(a)
        },
        _hsl: function (a) {
            return /^hsl\((\s*(-?\d+)\s*,)(\s*(\b(0?\d{1,2}|100)\b%)\s*,)(\s*(\b(0?\d{1,2}|100)\b%)\s*)\)$/.test(a)
        },
        _hsla: function (a) {
            return /^hsla\((\s*(-?\d+)\s*,)(\s*(\b(0?\d{1,2}|100)\b%)\s*,){2}(\s*(0?(\.\d+)?|1(\.0+)?)\s*)\)$/.test(a)
        },
        _keyword: function (b) {
            return a.inArray(b, this.KEYWORD_COLORS) >= 0
        },
        _rgb: function (a) {
            var b = /^rgb\((\s*(\b([01]?\d{1,2}|2[0-4]\d|25[0-5])\b)\s*,){2}(\s*(\b([01]?\d{1,2}|2[0-4]\d|25[0-5])\b)\s*)\)$/,
                c = /^rgb\((\s*(\b(0?\d{1,2}|100)\b%)\s*,){2}(\s*(\b(0?\d{1,2}|100)\b%)\s*)\)$/;
            return b.test(a) || c.test(a)
        },
        _rgba: function (a) {
            var b = /^rgba\((\s*(\b([01]?\d{1,2}|2[0-4]\d|25[0-5])\b)\s*,){3}(\s*(0?(\.\d+)?|1(\.0+)?)\s*)\)$/,
                c = /^rgba\((\s*(\b(0?\d{1,2}|100)\b%)\s*,){3}(\s*(0?(\.\d+)?|1(\.0+)?)\s*)\)$/;
            return b.test(a) || c.test(a)
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            creditCard: {
                "default": "Please enter a valid credit card number"
            }
        }
    }), FormValidation.Validator.creditCard = {
        validate: function (b, c) {
            var d = b.getFieldValue(c, "creditCard");
            if ("" === d) return !0;
            if (/[^0-9-\s]+/.test(d)) return !1;
            if (d = d.replace(/\D/g, ""), !FormValidation.Helper.luhn(d)) return !1;
            var e, f, g = {
                AMERICAN_EXPRESS: {
                    length: [15],
                    prefix: ["34", "37"]
                },
                DINERS_CLUB: {
                    length: [14],
                    prefix: ["300", "301", "302", "303", "304", "305", "36"]
                },
                DINERS_CLUB_US: {
                    length: [16],
                    prefix: ["54", "55"]
                },
                DISCOVER: {
                    length: [16],
                    prefix: ["6011", "622126", "622127", "622128", "622129", "62213", "62214", "62215", "62216", "62217", "62218", "62219", "6222", "6223", "6224", "6225", "6226", "6227", "6228", "62290", "62291", "622920", "622921", "622922", "622923", "622924", "622925", "644", "645", "646", "647", "648", "649", "65"]
                },
                JCB: {
                    length: [16],
                    prefix: ["3528", "3529", "353", "354", "355", "356", "357", "358"]
                },
                LASER: {
                    length: [16, 17, 18, 19],
                    prefix: ["6304", "6706", "6771", "6709"]
                },
                MAESTRO: {
                    length: [12, 13, 14, 15, 16, 17, 18, 19],
                    prefix: ["5018", "5020", "5038", "6304", "6759", "6761", "6762", "6763", "6764", "6765", "6766"]
                },
                MASTERCARD: {
                    length: [16],
                    prefix: ["51", "52", "53", "54", "55"]
                },
                SOLO: {
                    length: [16, 18, 19],
                    prefix: ["6334", "6767"]
                },
                UNIONPAY: {
                    length: [16, 17, 18, 19],
                    prefix: ["622126", "622127", "622128", "622129", "62213", "62214", "62215", "62216", "62217", "62218", "62219", "6222", "6223", "6224", "6225", "6226", "6227", "6228", "62290", "62291", "622920", "622921", "622922", "622923", "622924", "622925"]
                },
                VISA: {
                    length: [16],
                    prefix: ["4"]
                }
            };
            for (e in g)
                for (f in g[e].prefix)
                    if (d.substr(0, g[e].prefix[f].length) === g[e].prefix[f] && -1 !== a.inArray(d.length, g[e].length)) return {
                        valid: !0,
                        type: e
                    };
            return !1
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            date: {
                "default": "Please enter a valid date",
                min: "Please enter a date after %s",
                max: "Please enter a date before %s",
                range: "Please enter a date in the range %s - %s"
            }
        }
    }), FormValidation.Validator.date = {
        html5Attributes: {
            message: "message",
            format: "format",
            min: "min",
            max: "max",
            separator: "separator"
        },
        validate: function (b, c, d) {
            var e = b.getFieldValue(c, "date");
            if ("" === e) return !0;
            d.format = d.format || "MM/DD/YYYY", "date" === c.attr("type") && (d.format = "YYYY-MM-DD");
            var f = b.getLocale(),
                g = d.message || FormValidation.I18n[f].date["default"],
                h = d.format.split(" "),
                i = h[0],
                j = h.length > 1 ? h[1] : null,
                k = h.length > 2 ? h[2] : null,
                l = e.split(" "),
                m = l[0],
                n = l.length > 1 ? l[1] : null;
            if (h.length !== l.length) return {
                valid: !1,
                message: g
            };
            var o = d.separator;
            if (o || (o = -1 !== m.indexOf("/") ? "/" : -1 !== m.indexOf("-") ? "-" : -1 !== m.indexOf(".") ? "." : null), null === o || -1 === m.indexOf(o)) return {
                valid: !1,
                message: g
            };
            if (m = m.split(o), i = i.split(o), m.length !== i.length) return {
                valid: !1,
                message: g
            };
            var p = m[a.inArray("YYYY", i)],
                q = m[a.inArray("MM", i)],
                r = m[a.inArray("DD", i)];
            if (!p || !q || !r || 4 !== p.length) return {
                valid: !1,
                message: g
            };
            var s = null,
                t = null,
                u = null;
            if (j) {
                if (j = j.split(":"), n = n.split(":"), j.length !== n.length) return {
                    valid: !1,
                    message: g
                };
                if (t = n.length > 0 ? n[0] : null, s = n.length > 1 ? n[1] : null, u = n.length > 2 ? n[2] : null, "" === t || "" === s || "" === u) return {
                    valid: !1,
                    message: g
                };
                if (u) {
                    if (isNaN(u) || u.length > 2) return {
                        valid: !1,
                        message: g
                    };
                    if (u = parseInt(u, 10), 0 > u || u > 60) return {
                        valid: !1,
                        message: g
                    }
                }
                if (t) {
                    if (isNaN(t) || t.length > 2) return {
                        valid: !1,
                        message: g
                    };
                    if (t = parseInt(t, 10), 0 > t || t >= 24 || k && t > 12) return {
                        valid: !1,
                        message: g
                    }
                }
                if (s) {
                    if (isNaN(s) || s.length > 2) return {
                        valid: !1,
                        message: g
                    };
                    if (s = parseInt(s, 10), 0 > s || s > 59) return {
                        valid: !1,
                        message: g
                    }
                }
            }
            var v = FormValidation.Helper.date(p, q, r),
                w = null,
                x = null,
                y = d.min,
                z = d.max;
            switch (y && (isNaN(Date.parse(y)) && (y = b.getDynamicOption(c, y)), w = y instanceof Date ? y : this._parseDate(y, i, o), y = y instanceof Date ? this._formatDate(y, d.format) : y), z && (isNaN(Date.parse(z)) && (z = b.getDynamicOption(c, z)), x = z instanceof Date ? z : this._parseDate(z, i, o), z = z instanceof Date ? this._formatDate(z, d.format) : z), m = new Date(p, q - 1, r, t, s, u), !0) {
                case y && !z && v:
                    v = m.getTime() >= w.getTime(), g = d.message || FormValidation.Helper.format(FormValidation.I18n[f].date.min, y);
                    break;
                case z && !y && v:
                    v = m.getTime() <= x.getTime(), g = d.message || FormValidation.Helper.format(FormValidation.I18n[f].date.max, z);
                    break;
                case z && y && v:
                    v = m.getTime() <= x.getTime() && m.getTime() >= w.getTime(), g = d.message || FormValidation.Helper.format(FormValidation.I18n[f].date.range, [y, z])
            }
            return {
                valid: v,
                date: m,
                message: g
            }
        },
        _parseDate: function (b, c, d) {
            var e = 0,
                f = 0,
                g = 0,
                h = b.split(" "),
                i = h[0],
                j = h.length > 1 ? h[1] : null;
            i = i.split(d);
            var k = i[a.inArray("YYYY", c)],
                l = i[a.inArray("MM", c)],
                m = i[a.inArray("DD", c)];
            return j && (j = j.split(":"), f = j.length > 0 ? j[0] : null, e = j.length > 1 ? j[1] : null, g = j.length > 2 ? j[2] : null), new Date(k, l - 1, m, f, e, g)
        },
        _formatDate: function (a, b) {
            b = b.replace(/Y/g, "y").replace(/M/g, "m").replace(/D/g, "d").replace(/:m/g, ":M").replace(/:mm/g, ":MM").replace(/:S/, ":s").replace(/:SS/, ":ss");
            var c = {
                d: function (a) {
                    return a.getDate()
                },
                dd: function (a) {
                    var b = a.getDate();
                    return 10 > b ? "0" + b : b
                },
                m: function (a) {
                    return a.getMonth() + 1
                },
                mm: function (a) {
                    var b = a.getMonth() + 1;
                    return 10 > b ? "0" + b : b
                },
                yy: function (a) {
                    return ("" + a.getFullYear()).substr(2)
                },
                yyyy: function (a) {
                    return a.getFullYear()
                },
                h: function (a) {
                    return a.getHours() % 12 || 12
                },
                hh: function (a) {
                    var b = a.getHours() % 12 || 12;
                    return 10 > b ? "0" + b : b
                },
                H: function (a) {
                    return a.getHours()
                },
                HH: function (a) {
                    var b = a.getHours();
                    return 10 > b ? "0" + b : b
                },
                M: function (a) {
                    return a.getMinutes()
                },
                MM: function (a) {
                    var b = a.getMinutes();
                    return 10 > b ? "0" + b : b
                },
                s: function (a) {
                    return a.getSeconds()
                },
                ss: function (a) {
                    var b = a.getSeconds();
                    return 10 > b ? "0" + b : b
                }
            };
            return b.replace(/d{1,4}|m{1,4}|yy(?:yy)?|([HhMs])\1?|"[^"]*"|'[^']*'/g, function (b) {
                return c[b] ? c[b](a) : b.slice(1, b.length - 1)
            })
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            different: {
                "default": "Please enter a different value"
            }
        }
    }), FormValidation.Validator.different = {
        html5Attributes: {
            message: "message",
            field: "field"
        },
        init: function (a, b, c) {
            for (var d = c.field.split(","), e = 0; e < d.length; e++) {
                var f = a.getFieldElements(d[e]);
                a.onLiveChange(f, "live_different", function () {
                    var c = a.getStatus(b, "different");
                    c !== a.STATUS_NOT_VALIDATED && a.revalidateField(b)
                })
            }
        },
        destroy: function (a, b, c) {
            for (var d = c.field.split(","), e = 0; e < d.length; e++) {
                var f = a.getFieldElements(d[e]);
                a.offLiveChange(f, "live_different")
            }
        },
        validate: function (a, b, c) {
            var d = a.getFieldValue(b, "different");
            if ("" === d) return !0;
            for (var e = c.field.split(","), f = !0, g = 0; g < e.length; g++) {
                var h = a.getFieldElements(e[g]);
                if (null != h && 0 !== h.length) {
                    var i = a.getFieldValue(h, "different");
                    d === i ? f = !1 : "" !== i && a.updateStatus(h, a.STATUS_VALID, "different")
                }
            }
            return f
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            digits: {
                "default": "Por favor, introduzca sólo dígitos"
            },
            noteCreditReceiptFormat: {
                "default": "El formato de la nota de crédito de boleta es inválido"
            },
            invoiceFormat: {
                "default": "El formato de la factura es inválido"
            },
            salesNoteFormat: {
                "default": "El formato de la nota de venta es inválido"
            },
            receiptFormat: {
                "default": "El formato de la boleta es inválido"
            },
            creditNoteInvoiceFormat: {
                "default": "El formato de la nota de crédito de factura es inválido"
            },
            guideFormat: {
                "default": "El formato de la nota de guía de remisión es inválido"
            }
        }
    }), FormValidation.Validator.digits = {
        validate: function (a, b) {
            var c = a.getFieldValue(b, "digits");
            return "" === c ? !0 : /^\d+$/.test(c)
        }
    },
    FormValidation.Validator.noteCreditReceiptFormat = {
        validate: function (a, b) {
            var c = a.getFieldValue(b, "noteCreditReceiptFormat"); //Formato para Nota de credito de boleta
            if ("" === c) return !0;
            var regex = /^[A-Z][A-Z0-9][0-9]{2}-\{\d{1,9}\}$/;
            return regex.test(c);
        }
    },
    FormValidation.Validator.invoiceFormat = {
        validate: function (a, b) {
            var c = a.getFieldValue(b, "invoiceFormat"); //Formato para Factura
            if ("" === c) return !0;
            var regex = /^[A-Z][A-Z0-9][0-9]{2}-\{\d{1,9}\}$/;
            return regex.test(c);
        }
    },
    FormValidation.Validator.salesNoteFormat = {
        validate: function (a, b) {
            var c = a.getFieldValue(b, "salesNoteFormat"); //Formato para Nota de venta
            if ("" === c) return !0;
            var regex = /^[A-Z][A-Z0-9][0-9]{2,3}-\{\d{1,9}\}$/;
            return regex.test(c);
        }
    },
    FormValidation.Validator.receiptFormat = {
        validate: function (a, b) {
            var c = a.getFieldValue(b, "receiptFormat"); //Formato para Boleta
            if ("" === c) return !0;
            var regex = /^[A-Z][A-Z0-9][0-9]{2}-\{\d{1,9}\}$/;
            return regex.test(c);
        }
    },
    FormValidation.Validator.creditNoteInvoiceFormat = {
        validate: function (a, b) {
            var c = a.getFieldValue(b, "creditNoteInvoiceFormat"); //Formato para Nota de credito de factura
            if ("" === c) return !0;
            var regex = /^[A-Z][A-Z0-9][0-9]{2}-\{\d{1,9}\}$/;
            return regex.test(c);
        }
    },
    FormValidation.Validator.guideFormat = {
        validate: function (a, b) {
            var c = a.getFieldValue(b, "guideFormat"); // Formato para Guía de Remisión
            if ("" === c) return !0;
            var regex = /^[A-Z][A-Z0-9][0-9]{2}-\{\d{1,9}\}$/;
            return regex.test(c);
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            emailAddress: {
                "default": 'Ingresa un correo electrónico válido'
            }
        }
    }), FormValidation.Validator.emailAddress = {
        html5Attributes: {
            message: "message",
            multiple: "multiple",
            separator: "separator"
        },
        enableByHtml5: function (a) {
            return "email" === a.attr("type")
        },
        validate: function (a, b, c) {
            var d = a.getFieldValue(b, "emailAddress");
            if ("" === d) return !0;
            var e = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/,
                f = c.multiple === !0 || "true" === c.multiple;
            if (f) {
                for (var g = c.separator || /[,;]/, h = this._splitEmailAddresses(d, g), i = 0; i < h.length; i++)
                    if (!e.test(h[i])) return !1;
                return !0
            }
            return e.test(d)
        },
        _splitEmailAddresses: function (a, b) {
            for (var c = a.split(/"/), d = c.length, e = [], f = "", g = 0; d > g; g++)
                if (g % 2 === 0) {
                    var h = c[g].split(b),
                        i = h.length;
                    if (1 === i) f += h[0];
                    else {
                        e.push(f + h[0]);
                        for (var j = 1; i - 1 > j; j++) e.push(h[j]);
                        f = h[i - 1]
                    }
                } else f += '"' + c[g], d - 1 > g && (f += '"');
            return e.push(f), e
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            file: {
                "default": "Please choose a valid file"
            }
        }
    }), FormValidation.Validator.file = {
        html5Attributes: {
            extension: "extension",
            maxfiles: "maxFiles",
            minfiles: "minFiles",
            maxsize: "maxSize",
            minsize: "minSize",
            maxtotalsize: "maxTotalSize",
            mintotalsize: "minTotalSize",
            message: "message",
            type: "type"
        },
        validate: function (b, c, d) {
            var e = b.getFieldValue(c, "file");
            if ("" === e) return !0;
            var f, g = d.extension ? d.extension.toLowerCase().split(",") : null,
                h = d.type ? d.type.toLowerCase().split(",") : null,
                i = window.File && window.FileList && window.FileReader;
            if (i) {
                var j = c.get(0).files,
                    k = j.length,
                    l = 0;
                if (d.maxFiles && k > parseInt(d.maxFiles, 10) || d.minFiles && k < parseInt(d.minFiles, 10)) return !1;
                for (var m = 0; k > m; m++)
                    if (l += j[m].size, f = j[m].name.substr(j[m].name.lastIndexOf(".") + 1), d.minSize && j[m].size < parseInt(d.minSize, 10) || d.maxSize && j[m].size > parseInt(d.maxSize, 10) || g && -1 === a.inArray(f.toLowerCase(), g) || j[m].type && h && -1 === a.inArray(j[m].type.toLowerCase(), h)) return !1;
                if (d.maxTotalSize && l > parseInt(d.maxTotalSize, 10) || d.minTotalSize && l < parseInt(d.minTotalSize, 10)) return !1
            } else if (f = e.substr(e.lastIndexOf(".") + 1), g && -1 === a.inArray(f.toLowerCase(), g)) return !1;
            return !0
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            greaterThan: {
                "default": "Please enter a value greater than or equal to %s",
                notInclusive: "Please enter a value greater than %s"
            }
        }
    }), FormValidation.Validator.greaterThan = {
        html5Attributes: {
            message: "message",
            value: "value",
            inclusive: "inclusive"
        },
        enableByHtml5: function (a) {
            var b = a.attr("type"),
                c = a.attr("min");
            return c && "date" !== b ? {
                value: c
            } : !1
        },
        validate: function (b, c, d) {
            var e = b.getFieldValue(c, "greaterThan");
            if ("" === e) return !0;
            if (e = this._format(e), !a.isNumeric(e)) return !1;
            var f = b.getLocale(),
                g = a.isNumeric(d.value) ? d.value : b.getDynamicOption(c, d.value),
                h = this._format(g);
            return e = parseFloat(e), d.inclusive === !0 || void 0 === d.inclusive ? {
                valid: e >= h,
                message: FormValidation.Helper.format(d.message || FormValidation.I18n[f].greaterThan["default"], g)
            } : {
                valid: e > h,
                message: FormValidation.Helper.format(d.message || FormValidation.I18n[f].greaterThan.notInclusive, g)
            }
        },
        _format: function (a) {
            return (a + "").replace(",", ".")
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            identical: {
                "default": "Please enter the same value"
            }
        }
    }), FormValidation.Validator.identical = {
        html5Attributes: {
            message: "message",
            field: "field"
        },
        init: function (a, b, c) {
            var d = a.getFieldElements(c.field);
            a.onLiveChange(d, "live_identical", function () {
                var c = a.getStatus(b, "identical");
                c !== a.STATUS_NOT_VALIDATED && a.revalidateField(b)
            })
        },
        destroy: function (a, b, c) {
            var d = a.getFieldElements(c.field);
            a.offLiveChange(d, "live_identical")
        },
        validate: function (a, b, c) {
            var d = a.getFieldValue(b, "identical"),
                e = a.getFieldElements(c.field);
            if (null === e || 0 === e.length) return !0;
            var f = a.getFieldValue(e, "identical");
            return d === f ? (a.updateStatus(e, a.STATUS_VALID, "identical"), !0) : !1
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            integer: {
                "default": "Please enter a valid number"
            }
        }
    }), FormValidation.Validator.integer = {
        enableByHtml5: function (a) {
            return "number" === a.attr("type") && (void 0 === a.attr("step") || a.attr("step") % 1 === 0)
        },
        validate: function (a, b) {
            if (this.enableByHtml5(b) && b.get(0).validity && b.get(0).validity.badInput === !0) return !1;
            var c = a.getFieldValue(b, "integer");
            return "" === c ? !0 : /^(?:-?(?:0|[1-9][0-9]*))$/.test(c)
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            lessThan: {
                "default": "Please enter a value less than or equal to %s",
                notInclusive: "Please enter a value less than %s"
            }
        }
    }), FormValidation.Validator.lessThan = {
        html5Attributes: {
            message: "message",
            value: "value",
            inclusive: "inclusive"
        },
        enableByHtml5: function (a) {
            var b = a.attr("type"),
                c = a.attr("max");
            return c && "date" !== b ? {
                value: c
            } : !1
        },
        validate: function (b, c, d) {
            var e = b.getFieldValue(c, "lessThan");
            if ("" === e) return !0;
            if (e = this._format(e), !a.isNumeric(e)) return !1;
            var f = b.getLocale(),
                g = a.isNumeric(d.value) ? d.value : b.getDynamicOption(c, d.value),
                h = this._format(g);
            return e = parseFloat(e), d.inclusive === !0 || void 0 === d.inclusive ? {
                valid: h >= e,
                message: FormValidation.Helper.format(d.message || FormValidation.I18n[f].lessThan["default"], g)
            } : {
                valid: h > e,
                message: FormValidation.Helper.format(d.message || FormValidation.I18n[f].lessThan.notInclusive, g)
            }
        },
        _format: function (a) {
            return (a + "").replace(",", ".")
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            notEmpty: {
                "default": "Ingrese un valor"
            }
        }
    }), FormValidation.Validator.notEmpty = {
        enableByHtml5: function (a) {
            var b = a.attr("required") + "";
            return "required" === b || "true" === b
        },
        validate: function (b, c) {
            var d = c.attr("type");
            if ("radio" === d || "checkbox" === d) {
                var e = b.getNamespace();
                return b.getFieldElements(c.attr("data-" + e + "-field")).filter(":checked").length > 0
            }
            if ("number" === d && c.get(0).validity && c.get(0).validity.badInput === !0) return !0;
            var f = b.getFieldValue(c, "notEmpty");
            return "" !== a.trim(f)
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            numeric: {
                "default": "Please enter a valid float number"
            }
        }
    }), FormValidation.Validator.numeric = {
        html5Attributes: {
            message: "message",
            separator: "separator"
        },
        enableByHtml5: function (a) {
            return "number" === a.attr("type") && void 0 !== a.attr("step") && a.attr("step") % 1 !== 0
        },
        validate: function (a, b, c) {
            if (this.enableByHtml5(b) && b.get(0).validity && b.get(0).validity.badInput === !0) return !1;
            var d = a.getFieldValue(b, "numeric");
            if ("" === d) return !0;
            var e = c.separator || ".";
            return "." !== e && (d = d.replace(e, ".")), !isNaN(parseFloat(d)) && isFinite(d)
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            promise: {
                "default": "Please enter a valid value"
            }
        }
    }), FormValidation.Validator.promise = {
        html5Attributes: {
            message: "message",
            promise: "promise"
        },
        validate: function (b, c, d) {
            var e = b.getFieldValue(c, "promise"),
                f = new a.Deferred,
                g = FormValidation.Helper.call(d.promise, [e, b, c]);
            return g.done(function (a) {
                f.resolve(c, "promise", a)
            }).fail(function (a) {
                a = a || {}, a.valid = !1, f.resolve(c, "promise", a)
            }), f
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            regexp: {
                "default": "Please enter a value matching the pattern"
            }
        }
    }), FormValidation.Validator.regexp = {
        html5Attributes: {
            message: "message",
            regexp: "regexp"
        },
        enableByHtml5: function (a) {
            var b = a.attr("pattern");
            return b ? {
                regexp: b
            } : !1
        },
        validate: function (a, b, c) {
            var d = a.getFieldValue(b, "regexp");
            if ("" === d) return !0;
            var e = "string" == typeof c.regexp ? new RegExp(c.regexp) : c.regexp;
            return e.test(d)
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            remote: {
                "default": "Please enter a valid value"
            }
        }
    }), FormValidation.Validator.remote = {
        html5Attributes: {
            crossdomain: "crossDomain",
            data: "data",
            datatype: "dataType",
            delay: "delay",
            message: "message",
            name: "name",
            type: "type",
            url: "url",
            validkey: "validKey"
        },
        destroy: function (a, b) {
            var c = a.getNamespace(),
                d = b.data(c + ".remote.timer");
            d && (clearTimeout(d), b.removeData(c + ".remote.timer"))
        },
        validate: function (b, c, d) {
            function e() {
                var b = a.ajax(m);
                return b.success(function (a) {
                    a.valid = a[l] === !0 || "true" === a[l] ? !0 : a[l] === !1 || "false" === a[l] ? !1 : null, h.resolve(c, "remote", a)
                }).error(function () {
                    h.resolve(c, "remote", {
                        valid: !1
                    })
                }), h.fail(function () {
                    b.abort()
                }), h
            }
            var f = b.getNamespace(),
                g = b.getFieldValue(c, "remote"),
                h = new a.Deferred;
            if ("" === g) return h.resolve(c, "remote", {
                valid: !0
            }), h;
            var i = c.attr("data-" + f + "-field"),
                j = d.data || {},
                k = d.url,
                l = d.validKey || "valid";
            "function" == typeof j && (j = j.call(this, b, c, g)), "string" == typeof j && (j = JSON.parse(j)), "function" == typeof k && (k = k.call(this, b, c, g)), j[d.name || i] = g;
            var m = {
                data: j,
                dataType: d.dataType || "json",
                headers: d.headers || {},
                type: d.type || "GET",
                url: k
            };
            return null !== d.crossDomain && (m.crossDomain = d.crossDomain === !0 || "true" === d.crossDomain), d.delay ? (c.data(f + ".remote.timer") && clearTimeout(c.data(f + ".remote.timer")), c.data(f + ".remote.timer", setTimeout(e, d.delay)), h) : e()
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            stringLength: {
                "default": "Por favor, ingrese un valor con una longitud válida",
                less: "Por favor, ingrese menos de %s caracteres",
                more: "Por favor, ingrese más de %s caracteres",
                between: "Por favor, ingrese un valor entre %s y %s caracteres de largo"
            }
        }
    }), FormValidation.Validator.stringLength = {
        html5Attributes: {
            message: "message",
            min: "min",
            max: "max",
            trim: "trim",
            utf8bytes: "utf8Bytes"
        },
        enableByHtml5: function (b) {
            var c = {},
                d = b.attr("maxlength"),
                e = b.attr("minlength");
            return d && (c.max = parseInt(d, 10)), e && (c.min = parseInt(e, 10)), a.isEmptyObject(c) ? !1 : c
        },
        validate: function (b, c, d) {
            var e = b.getFieldValue(c, "stringLength");
            if ((d.trim === !0 || "true" === d.trim) && (e = a.trim(e)), "" === e) return !0;
            var f = b.getLocale(),
                g = a.isNumeric(d.min) ? d.min : b.getDynamicOption(c, d.min),
                h = a.isNumeric(d.max) ? d.max : b.getDynamicOption(c, d.max),
                i = function (a) {
                    for (var b = a.length, c = a.length - 1; c >= 0; c--) {
                        var d = a.charCodeAt(c);
                        d > 127 && 2047 >= d ? b++ : d > 2047 && 65535 >= d && (b += 2), d >= 56320 && 57343 >= d && c--
                    }
                    return b
                },
                j = d.utf8Bytes ? i(e) : e.length,
                k = !0,
                l = d.message || FormValidation.I18n[f].stringLength["default"];
            switch ((g && j < parseInt(g, 10) || h && j > parseInt(h, 10)) && (k = !1), !0) {
                case !!g && !!h:
                    l = FormValidation.Helper.format(d.message || FormValidation.I18n[f].stringLength.between, [parseInt(g, 10), parseInt(h, 10)]);
                    break;
                case !!g:
                    l = FormValidation.Helper.format(d.message || FormValidation.I18n[f].stringLength.more, parseInt(g, 10));
                    break;
                case !!h:
                    l = FormValidation.Helper.format(d.message || FormValidation.I18n[f].stringLength.less, parseInt(h, 10))
            }
            return {
                valid: k,
                message: l
            }
        }
    }
}(jQuery),
function (a) {
    FormValidation.I18n = a.extend(!0, FormValidation.I18n || {}, {
        en_US: {
            uri: {
                "default": "Please enter a valid URI"
            },
            fixedLength: {
                "default": "Por favor ingrese %s caracteres exactamente"
            },
            maxLengthRequired: {
                "default": "Por favor ingrese no mas de %s caracteres",
                required: "El campo es requerido"
            }
        }
    }), FormValidation.Validator.uri = {
        html5Attributes: {
            message: "message",
            allowlocal: "allowLocal",
            allowemptyprotocol: "allowEmptyProtocol",
            protocol: "protocol"
        },
        enableByHtml5: function (a) {
            return "url" === a.attr("type")
        },
        validate: function (a, b, c) {
            var d = a.getFieldValue(b, "uri");
            if ("" === d) return !0;
            var e = c.allowLocal === !0 || "true" === c.allowLocal,
                f = c.allowEmptyProtocol === !0 || "true" === c.allowEmptyProtocol,
                g = (c.protocol || "http, https, ftp").split(",").join("|").replace(/\s/g, ""),
                h = new RegExp("^(?:(?:" + g + ")://)" + (f ? "?" : "") + "(?:\\S+(?::\\S*)?@)?(?:" + (e ? "" : "(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})") + "(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]-?)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]-?)*[a-z\\u00a1-\\uffff0-9])*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,}))" + (e ? "?" : "") + ")(?::\\d{2,5})?(?:/[^\\s]*)?$", "i");
            return h.test(d)
        }
    },
    FormValidation.Validator.fixedLength = {
        html5Attributes: {
            message: "message",
            length: "length"
        },
        validate: function (a, b, c) {
            
            var d = a.getFieldValue(b, "fixedLength");
            var length = parseInt(c.length, 10);
            if (isNaN(length)) {
                return false;
            }
            return d.length === length;
        }
    },FormValidation.Validator.maxLengthRequired = {
        html5Attributes: {
            message: "message",
            max: "max"
        },
        validate: function (validator, $field, options) {
            var value = validator.getFieldValue($field, "maxLengthRequired");
            var maxLength = parseInt(options.max, 10);

            if (value === "") {
                return {
                    valid: false,
                    message: FormValidation.I18n.en_US.maxLengthRequired.required
                };
            }

            if (isNaN(maxLength)) {
                return false;
            }

            if (value.length > maxLength) {
                return {
                    valid: false,
                    message: FormValidation.I18n.en_US.maxLengthRequired["default"].replace("%s", maxLength)
                };
            }

            return true;
        }
    };
}(jQuery);