chrome.runtime.onInstalled.addListener(() => {
    fetch(chrome.runtime.getURL('computer_config.json'))
        .then(response => response.json())
        .then(data => {
            chrome.storage.local.set({ computerName: data.computerName }, () => {
                console.log("Nome do computador salvo com sucesso:", data.computerName);
            });
        })
        .catch(error => console.error("Erro ao carregar o nome do computador:", error));
    
    const domainNicknames = {
        "agibank.com.br": "Agibank",
        "bradesco.com.br": "Bradesco",
        "bancobmg.com.br": "Banco BMG",
        "bancobs2.com.br": "Banco BS2",
        "btgpactual.com": "BTG Pactual",
        "c6bank.com.br": "C6 Bank",
        "citibank.com": "Citibank",
        "sicoob.com.br": "Sicoob",
        "sicredi.com.br": "Sicredi",
        "daycoval.com.br": "Daycoval",
        "bb.com.br": "Banco do Brasil",
        "bancobrasil.com.br": "Banco do Brasil",
        "inter.co": "Banco Inter",
        "safra.com.br": "Safra",
        "original.com.br": "Banco Original",
        "picpay.com": "PicPay",
        "bancopan.com.br": "Banco PAN",
        "pine.com": "Banco Pine",
        "santander.com.br": "Santander",
        "bancotopazio.com.br": "Banco Topázio",
        "bv.com.br": "BV",
        "cora.com.br": "Cora",
        "linker.com.br": "Linker",
        "tribanco.com.br": "Tribanco",
        "infinitepay.io": "InfinitePay",
        "safrapay.com.br": "SafraPay",
        "mercadopago.com.br": "Mercado Pago",
        "sejaefi.com.br": "Efi",
        "iugu.com": "Iugu",
        "bancoamazonia.com.br": "Banco da Amazônia",
        "asaas.com": "Asaas",
        "jeev.es": "Jeeves",
        "banrisul.com.br": "Banrisul",
        "binance.com": "Binance",
        "mercadobitcoin.com.br": "Mercado Bitcoin",
        "caixa.gov.br": "Caixa Econômica Federal",
        "confesol.com.br": "Confesol",
        "stone.com.br": "Stone",
        "uniswap.org": "Uniswap",
        "banco.bradesco": "Bradesco",
        "bnb.gov.br": "Banco do Nordeste",
        "neon.com.br": "Neon",
        "pagseguro.uol.com.br": "PagSeguro",
        "meubmg.com.br": "Meu BMG",
        "next.b.br": "Next",
        "ailos.coop.br": "Ailos",
        "acentra.coop.br": "Acentra",
        "civia.coop.br": "Civia",
        "credelesc.coop.br": "Credelesc",
        "credifoz.coop.br": "Credifoz",
        "evolua.coop.br": "Evolua",
        "unilos.coop.br": "Únilos",
        "viacredialtovale.coop.br": "Viacredi Alto Vale",
        "acredi.coop.br": "Acredicoop",
        "credcrea.coop.br": "CredCrea",
        "credicomin.coop.br": "Credicomin",
        "crevisc.coop.br": "Crevisc",
        "transpocred.coop.br": "Transpocred",
        "viacredi.coop.br": "Viacredi",
        "bitfinex.com": "Bitfinex",
        "coinbase.com": "Coinbase",
        "kucoin.com": "KuCoin",
        "paxful.com": "Paxful",
        "bitstamp.net": "Bitstamp",
        "foxbit.com.br": "Foxbit",
		"totalbank.com.br": "Total Bank",
		"moneyp.com.br": "Banco BMP",
        "cgd.pt": "Caixa Geral de Depósitos",
        "santander.pt": "Banco Santander Totta",
        "bpi.pt": "Banco BPI",
        "millenniumbcp.pt": "Millennium BCP",
        "novobanco.pt": "Novo Banco",
        "bancomontepio.pt": "Banco Montepio",
        "bancoctt.pt": "Banco CTT",
        "bancobig.pt": "Banco BIG",
        "atlantico.eu": "Banco Atlântico Europa",
        "eurobic.pt": "EuroBic",
        "abanca.pt": "Abanca",
        "activobank.pt": "ActivoBank",
        "finantia.com": "Banco Finantia",
        "bancoinvest.pt": "Banco Invest",
        "bancobest.pt": "Banco Best",
        "bancocarregosa.com": "Banco Carregosa",
        "baieuropa.eu": "Banco BAI Europa",
        "creditoagricola.pt": "Crédito Agrícola",
        "bancoefisa.com": "Banco Efisa",
        "bpg.pt": "Banco Português de Gestão",
        "bancoprimus.pt": "Banco Primus",
        "bca.pt": "Banco Comercial do Atlântico",
        "bnpparibas-pf.pt": "Banco BNP Paribas Personal Finance",
        "bancosabadell.pt": "Banco Sabadell",
        "oney.pt": "Oney Bank",
        "credibom.pt": "Banco Credibom",
        "barclays.pt": "Banco Barclays",
        "porschebank.pt": "Banco Porsche",
        "nobanco.com.br": "Nobank",
		"ing.com": "ING Group",
        "bancsabadell.com": "Banco Sabadell",
        "unicredit.eu": "UniCredit",
        "intesa.it": "Intesa Sanpaolo",
        "bnpparibas.com": "BNP Paribas",
        "societegenerale.com": "Société Générale",
        "credit-agricole.com": "Crédit Agricole",
        "caixabank.es": "CaixaBank",
        "deutsche-bank.de": "Deutsche Bank",
        "commerzbank.de": "Commerzbank",
        "dzbank.de": "DZ Bank",
        "bbva.com": "BBVA",
        "abnamro.nl": "ABN AMRO",
        "rabobank.com": "Rabobank",
        "kbc.com": "KBC Group",
        "belfius.be": "Belfius Bank",
        "dexia.com": "Dexia",
        "hsbc.co.uk": "HSBC",
        "barclays.co.uk": "Barclays",
        "lloydsbank.com": "Lloyds Bank",
        "natwest.com": "NatWest",
        "standardchartered.com": "Standard Chartered",
        "bankofireland.com": "Bank of Ireland",
        "aib.ie": "Allied Irish Banks (AIB)",
        "nordea.com": "Nordea",
        "seb.se": "Skandinaviska Enskilda Banken (SEB)",
        "handelsbanken.se": "Handelsbanken",
        "danskebank.com": "Danske Bank",
        "swedbank.com": "Swedbank",
        "op.fi": "OP Financial Group",
        "santander.com": "Banco Santander",
        "unicajabanco.es": "Unicaja Banco",
        "raiffeisen.at": "Raiffeisen Bank International",
        "erstegroup.com": "Erste Group",
        "otpbank.hu": "OTP Bank",
        "pkobp.pl": "PKO Bank Polski",
        "mbank.pl": "mBank",
        "credit-suisse.com": "Credit Suisse",
        "ubs.com": "UBS",
        "bankia.es": "Bankia",
        "bunq.com": "bunq",
        "n26.com": "N26",
        "revolut.com": "Revolut",
        "monzo.com": "Monzo",
        "starlingbank.com": "Starling Bank",
        "finecobank.com": "FinecoBank",
        "aliorbank.pl": "Alior Bank",
        "bcr.ro": "Banca Comercială Română (BCR)",
        "unicreditbank.ro": "UniCredit Bank România",
        "bankmillennium.pl": "Bank Millennium",
        "bancopopolare.it": "Banco Popolare",
        "popso.it": "Banca Popolare di Sondrio",
        "bancodonordeste.gov.br": "Banco do Nordeste",
        "bancorural.com.br": "Banco Rural",
        "modalmais.com.br": "ModalMais",
        "credsystem.com.br": "CredSystem"
    };

    chrome.storage.local.set({ domainNicknames }, () => {
        console.log("Apelidos de domínios salvos com sucesso.");
    });
});
