function getComputerNameAndNotify() {
    chrome.storage.local.get(['computerName', 'lastNotification', 'lastDomain', 'domainNicknames'], (result) => {
        let computerName = result.computerName || 'Computador Desconhecido';
        let lastNotification = result.lastNotification;
        let lastDomain = result.lastDomain;
        let domainNicknames = result.domainNicknames || {};
        let currentTime = Date.now();
        let fiveMinutes = 5 * 60 * 1000;

        const url = new URL(window.location.href);
        const domainParts = url.hostname.split('.');

        // Pegando domínio raiz de forma mais confiável
        let rootDomain = domainParts.slice(-2).join('.');
        if (domainParts.length > 2 && ["com", "gov", "org", "net", "coop"].includes(domainParts[domainParts.length - 2])) {
            rootDomain = domainParts.slice(-3).join('.');
        }

        // Verificar se o domínio raiz está na lista de monitoramento
        if (!(rootDomain in domainNicknames)) {
            console.log("Domínio não está na lista de monitoramento. Ignorando...");
            return;
        }

        let nickname = domainNicknames[rootDomain] || rootDomain;

        if (lastDomain === rootDomain && lastNotification && (currentTime - lastNotification) < fiveMinutes) {
            console.log("Notificação já enviada para este domínio raiz nos últimos 5 minutos. Ignorando...");
            return;
        }

        console.log("Apelido do Domínio Extraído:", nickname);

        const message = `Acesso detectado em ${computerName} >>> ${nickname} (${url.hostname})`;

        const botToken = '8002725412:AAGe_fsPjcvwQt0OmPHIdjXivouNIvIUcg0';
        const chatId = '-4933749612';

        console.log("Enviando mensagem para o Telegram:", message);

        fetch(`https://api.telegram.org/bot${botToken}/sendMessage`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                chat_id: chatId,
                text: message,
            }),
        }).then(() => {
            console.log("Mensagem enviada com sucesso!");
            chrome.storage.local.set({ lastNotification: currentTime, lastDomain: rootDomain });
        }).catch((error) => {
            console.error('Erro ao enviar mensagem para o Telegram:', error);
        });
    });
}
getComputerNameAndNotify();

