function createTable(tableData) {
    var tableBody = document.createElement('tbody');
    var options = {year: 'numeric', month: 'short', day: 'numeric'};

    if (tableData != undefined) {
        tableData.reverse().forEach(function (rowData) {
            var tempDate = new Date(rowData.date);
            var row = document.createElement('tr');
            var cell1 = document.createElement('td');
            var cell2 = document.createElement('td');
            var cell3 = document.createElement('td');
            var cell4 = document.createElement('td');
            cell1.appendChild(document.createTextNode(tempDate.toLocaleDateString("en-US", options)));
            cell2.appendChild(document.createTextNode(rowData.time));
            cell3.appendChild(document.createTextNode(rowData.site));
            cell4.appendChild(document.createTextNode(rowData.value));
            row.appendChild(cell1);
            row.appendChild(cell2);
            row.appendChild(cell3);
            row.appendChild(cell4);

            tableBody.appendChild(row);
        });
    }

    $('table').append(tableBody);

}

var logs = '';

chrome.storage.local.get(['key'], function (result) {
    logs = result.key;
    createTable(logs);
    var table = $('table').DataTable({
        "order": []
    });
    $('nav').append($('#DataTables_Table_0_filter'));

    // $('#min').change( function() { table.draw(); } );
    // $('#max').change( function() { table.draw(); } );
    // Add event listeners to the two range filtering inputs

});
